/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.HistoricalExternalEventSourceType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;

public class HistoricalExternalEventSourceTypeNode
extends BaseObjectTypeNode
implements HistoricalExternalEventSourceType {
    public HistoricalExternalEventSourceTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String getServer() throws UaException {
        PropertyTypeNode node = this.getServerNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setServer(String value) throws UaException {
        PropertyTypeNode node = this.getServerNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readServer() throws UaException {
        try {
            return this.readServerAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeServer(String value) throws UaException {
        try {
            this.writeServerAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readServerAsync() {
        return ((CompletableFuture)this.getServerNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServerAsync(String server) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)server));
        return this.getServerNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServerNode() throws UaException {
        try {
            return this.getServerNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServerNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Server", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getEndpointUrl() throws UaException {
        PropertyTypeNode node = this.getEndpointUrlNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setEndpointUrl(String value) throws UaException {
        PropertyTypeNode node = this.getEndpointUrlNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readEndpointUrl() throws UaException {
        try {
            return this.readEndpointUrlAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeEndpointUrl(String value) throws UaException {
        try {
            this.writeEndpointUrlAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readEndpointUrlAsync() {
        return ((CompletableFuture)this.getEndpointUrlNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEndpointUrlAsync(String endpointUrl) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)endpointUrl));
        return this.getEndpointUrlNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEndpointUrlNode() throws UaException {
        try {
            return this.getEndpointUrlNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEndpointUrlNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EndpointUrl", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public MessageSecurityMode getSecurityMode() throws UaException {
        PropertyTypeNode node = this.getSecurityModeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return MessageSecurityMode.from((int)((Integer)value));
        }
        if (value instanceof MessageSecurityMode) {
            return (MessageSecurityMode)value;
        }
        return null;
    }

    @Override
    public void setSecurityMode(MessageSecurityMode value) throws UaException {
        PropertyTypeNode node = this.getSecurityModeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public MessageSecurityMode readSecurityMode() throws UaException {
        try {
            return this.readSecurityModeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSecurityMode(MessageSecurityMode value) throws UaException {
        try {
            this.writeSecurityModeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends MessageSecurityMode> readSecurityModeAsync() {
        return ((CompletableFuture)this.getSecurityModeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return MessageSecurityMode.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityModeAsync(MessageSecurityMode securityMode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityMode));
        return this.getSecurityModeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecurityModeNode() throws UaException {
        try {
            return this.getSecurityModeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecurityModeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityMode", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getSecurityPolicyUri() throws UaException {
        PropertyTypeNode node = this.getSecurityPolicyUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSecurityPolicyUri(String value) throws UaException {
        PropertyTypeNode node = this.getSecurityPolicyUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readSecurityPolicyUri() throws UaException {
        try {
            return this.readSecurityPolicyUriAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSecurityPolicyUri(String value) throws UaException {
        try {
            this.writeSecurityPolicyUriAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readSecurityPolicyUriAsync() {
        return ((CompletableFuture)this.getSecurityPolicyUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityPolicyUriAsync(String securityPolicyUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityPolicyUri));
        return this.getSecurityPolicyUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecurityPolicyUriNode() throws UaException {
        try {
            return this.getSecurityPolicyUriNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecurityPolicyUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityPolicyUri", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UserTokenPolicy getIdentityTokenPolicy() throws UaException {
        PropertyTypeNode node = this.getIdentityTokenPolicyNode();
        return this.cast(node.getValue().getValue().getValue(), UserTokenPolicy.class);
    }

    @Override
    public void setIdentityTokenPolicy(UserTokenPolicy value) throws UaException {
        PropertyTypeNode node = this.getIdentityTokenPolicyNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public UserTokenPolicy readIdentityTokenPolicy() throws UaException {
        try {
            return this.readIdentityTokenPolicyAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeIdentityTokenPolicy(UserTokenPolicy value) throws UaException {
        try {
            this.writeIdentityTokenPolicyAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UserTokenPolicy> readIdentityTokenPolicyAsync() {
        return ((CompletableFuture)this.getIdentityTokenPolicyNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), UserTokenPolicy.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeIdentityTokenPolicyAsync(UserTokenPolicy identityTokenPolicy) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)identityTokenPolicy);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getIdentityTokenPolicyNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getIdentityTokenPolicyNode() throws UaException {
        try {
            return this.getIdentityTokenPolicyNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getIdentityTokenPolicyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "IdentityTokenPolicy", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getTransportProfileUri() throws UaException {
        PropertyTypeNode node = this.getTransportProfileUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setTransportProfileUri(String value) throws UaException {
        PropertyTypeNode node = this.getTransportProfileUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readTransportProfileUri() throws UaException {
        try {
            return this.readTransportProfileUriAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeTransportProfileUri(String value) throws UaException {
        try {
            this.writeTransportProfileUriAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readTransportProfileUriAsync() {
        return ((CompletableFuture)this.getTransportProfileUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTransportProfileUriAsync(String transportProfileUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)transportProfileUri));
        return this.getTransportProfileUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getTransportProfileUriNode() throws UaException {
        try {
            return this.getTransportProfileUriNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getTransportProfileUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransportProfileUri", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public EventFilter getHistoricalEventFilter() throws UaException {
        PropertyTypeNode node = this.getHistoricalEventFilterNode();
        return this.cast(node.getValue().getValue().getValue(), EventFilter.class);
    }

    @Override
    public void setHistoricalEventFilter(EventFilter value) throws UaException {
        PropertyTypeNode node = this.getHistoricalEventFilterNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public EventFilter readHistoricalEventFilter() throws UaException {
        try {
            return this.readHistoricalEventFilterAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeHistoricalEventFilter(EventFilter value) throws UaException {
        try {
            this.writeHistoricalEventFilterAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends EventFilter> readHistoricalEventFilterAsync() {
        return ((CompletableFuture)this.getHistoricalEventFilterNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), EventFilter.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeHistoricalEventFilterAsync(EventFilter historicalEventFilter) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)historicalEventFilter);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getHistoricalEventFilterNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getHistoricalEventFilterNode() throws UaException {
        try {
            return this.getHistoricalEventFilterNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getHistoricalEventFilterNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HistoricalEventFilter", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

