/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.ConnectionTransportTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.DatagramConnectionTransportType;
import org.eclipse.milo.opcua.sdk.client.model.objects.NetworkAddressTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.QosDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class DatagramConnectionTransportTypeNode
extends ConnectionTransportTypeNode
implements DatagramConnectionTransportType {
    public DatagramConnectionTransportTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UInteger getDiscoveryAnnounceRate() throws UaException {
        PropertyTypeNode node = this.getDiscoveryAnnounceRateNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setDiscoveryAnnounceRate(UInteger value) throws UaException {
        PropertyTypeNode node = this.getDiscoveryAnnounceRateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readDiscoveryAnnounceRate() throws UaException {
        try {
            return this.readDiscoveryAnnounceRateAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDiscoveryAnnounceRate(UInteger value) throws UaException {
        try {
            this.writeDiscoveryAnnounceRateAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readDiscoveryAnnounceRateAsync() {
        return ((CompletableFuture)this.getDiscoveryAnnounceRateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDiscoveryAnnounceRateAsync(UInteger discoveryAnnounceRate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)discoveryAnnounceRate));
        return this.getDiscoveryAnnounceRateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDiscoveryAnnounceRateNode() throws UaException {
        try {
            return this.getDiscoveryAnnounceRateNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDiscoveryAnnounceRateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DiscoveryAnnounceRate", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getDiscoveryMaxMessageSize() throws UaException {
        PropertyTypeNode node = this.getDiscoveryMaxMessageSizeNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setDiscoveryMaxMessageSize(UInteger value) throws UaException {
        PropertyTypeNode node = this.getDiscoveryMaxMessageSizeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readDiscoveryMaxMessageSize() throws UaException {
        try {
            return this.readDiscoveryMaxMessageSizeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDiscoveryMaxMessageSize(UInteger value) throws UaException {
        try {
            this.writeDiscoveryMaxMessageSizeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readDiscoveryMaxMessageSizeAsync() {
        return ((CompletableFuture)this.getDiscoveryMaxMessageSizeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDiscoveryMaxMessageSizeAsync(UInteger discoveryMaxMessageSize) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)discoveryMaxMessageSize));
        return this.getDiscoveryMaxMessageSizeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDiscoveryMaxMessageSizeNode() throws UaException {
        try {
            return this.getDiscoveryMaxMessageSizeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDiscoveryMaxMessageSizeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DiscoveryMaxMessageSize", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getQosCategory() throws UaException {
        PropertyTypeNode node = this.getQosCategoryNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setQosCategory(String value) throws UaException {
        PropertyTypeNode node = this.getQosCategoryNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readQosCategory() throws UaException {
        try {
            return this.readQosCategoryAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeQosCategory(String value) throws UaException {
        try {
            this.writeQosCategoryAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readQosCategoryAsync() {
        return ((CompletableFuture)this.getQosCategoryNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeQosCategoryAsync(String qosCategory) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)qosCategory));
        return this.getQosCategoryNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getQosCategoryNode() throws UaException {
        try {
            return this.getQosCategoryNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getQosCategoryNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "QosCategory", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public QosDataType[] getDatagramQos() throws UaException {
        PropertyTypeNode node = this.getDatagramQosNode();
        return this.cast(node.getValue().getValue().getValue(), QosDataType[].class);
    }

    @Override
    public void setDatagramQos(QosDataType[] value) throws UaException {
        PropertyTypeNode node = this.getDatagramQosNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public QosDataType[] readDatagramQos() throws UaException {
        try {
            return this.readDatagramQosAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDatagramQos(QosDataType[] value) throws UaException {
        try {
            this.writeDatagramQosAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends QosDataType[]> readDatagramQosAsync() {
        return ((CompletableFuture)this.getDatagramQosNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), QosDataType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDatagramQosAsync(QosDataType[] datagramQos) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])datagramQos);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDatagramQosNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDatagramQosNode() throws UaException {
        try {
            return this.getDatagramQosNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDatagramQosNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DatagramQos", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NetworkAddressTypeNode getDiscoveryAddressNode() throws UaException {
        try {
            return this.getDiscoveryAddressNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends NetworkAddressTypeNode> getDiscoveryAddressNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DiscoveryAddress", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (NetworkAddressTypeNode)node);
    }
}

