/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseEventType;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.TimeZoneDataType;

public class BaseEventTypeNode
extends BaseObjectTypeNode
implements BaseEventType {
    public BaseEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public ByteString getEventId() throws UaException {
        PropertyTypeNode node = this.getEventIdNode();
        return (ByteString)node.getValue().getValue().getValue();
    }

    @Override
    public void setEventId(ByteString value) throws UaException {
        PropertyTypeNode node = this.getEventIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ByteString readEventId() throws UaException {
        try {
            return this.readEventIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeEventId(ByteString value) throws UaException {
        try {
            this.writeEventIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends ByteString> readEventIdAsync() {
        return ((CompletableFuture)this.getEventIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ByteString)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEventIdAsync(ByteString eventId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)eventId));
        return this.getEventIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEventIdNode() throws UaException {
        try {
            return this.getEventIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEventIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EventId", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId getEventType() throws UaException {
        PropertyTypeNode node = this.getEventTypeNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setEventType(NodeId value) throws UaException {
        PropertyTypeNode node = this.getEventTypeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readEventType() throws UaException {
        try {
            return this.readEventTypeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeEventType(NodeId value) throws UaException {
        try {
            this.writeEventTypeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readEventTypeAsync() {
        return ((CompletableFuture)this.getEventTypeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEventTypeAsync(NodeId eventType) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)eventType));
        return this.getEventTypeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEventTypeNode() throws UaException {
        try {
            return this.getEventTypeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEventTypeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EventType", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId getSourceNode() throws UaException {
        PropertyTypeNode node = this.getSourceNodeNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setSourceNode(NodeId value) throws UaException {
        PropertyTypeNode node = this.getSourceNodeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readSourceNode() throws UaException {
        try {
            return this.readSourceNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSourceNode(NodeId value) throws UaException {
        try {
            this.writeSourceNodeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readSourceNodeAsync() {
        return ((CompletableFuture)this.getSourceNodeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSourceNodeAsync(NodeId sourceNode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sourceNode));
        return this.getSourceNodeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSourceNodeNode() throws UaException {
        try {
            return this.getSourceNodeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSourceNodeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SourceNode", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getSourceName() throws UaException {
        PropertyTypeNode node = this.getSourceNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSourceName(String value) throws UaException {
        PropertyTypeNode node = this.getSourceNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readSourceName() throws UaException {
        try {
            return this.readSourceNameAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSourceName(String value) throws UaException {
        try {
            this.writeSourceNameAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readSourceNameAsync() {
        return ((CompletableFuture)this.getSourceNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSourceNameAsync(String sourceName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sourceName));
        return this.getSourceNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSourceNameNode() throws UaException {
        try {
            return this.getSourceNameNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSourceNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SourceName", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getTime() throws UaException {
        PropertyTypeNode node = this.getTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setTime(DateTime value) throws UaException {
        PropertyTypeNode node = this.getTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readTime() throws UaException {
        try {
            return this.readTimeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeTime(DateTime value) throws UaException {
        try {
            this.writeTimeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readTimeAsync() {
        return ((CompletableFuture)this.getTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTimeAsync(DateTime time) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)time));
        return this.getTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getTimeNode() throws UaException {
        try {
            return this.getTimeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Time", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getReceiveTime() throws UaException {
        PropertyTypeNode node = this.getReceiveTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setReceiveTime(DateTime value) throws UaException {
        PropertyTypeNode node = this.getReceiveTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readReceiveTime() throws UaException {
        try {
            return this.readReceiveTimeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeReceiveTime(DateTime value) throws UaException {
        try {
            this.writeReceiveTimeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readReceiveTimeAsync() {
        return ((CompletableFuture)this.getReceiveTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeReceiveTimeAsync(DateTime receiveTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)receiveTime));
        return this.getReceiveTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getReceiveTimeNode() throws UaException {
        try {
            return this.getReceiveTimeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getReceiveTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReceiveTime", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public TimeZoneDataType getLocalTime() throws UaException {
        PropertyTypeNode node = this.getLocalTimeNode();
        return this.cast(node.getValue().getValue().getValue(), TimeZoneDataType.class);
    }

    @Override
    public void setLocalTime(TimeZoneDataType value) throws UaException {
        PropertyTypeNode node = this.getLocalTimeNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public TimeZoneDataType readLocalTime() throws UaException {
        try {
            return this.readLocalTimeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeLocalTime(TimeZoneDataType value) throws UaException {
        try {
            this.writeLocalTimeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends TimeZoneDataType> readLocalTimeAsync() {
        return ((CompletableFuture)this.getLocalTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), TimeZoneDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeLocalTimeAsync(TimeZoneDataType localTime) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)localTime);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getLocalTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLocalTimeNode() throws UaException {
        try {
            return this.getLocalTimeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLocalTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LocalTime", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getMessage() throws UaException {
        PropertyTypeNode node = this.getMessageNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setMessage(LocalizedText value) throws UaException {
        PropertyTypeNode node = this.getMessageNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readMessage() throws UaException {
        try {
            return this.readMessageAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMessage(LocalizedText value) throws UaException {
        try {
            this.writeMessageAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readMessageAsync() {
        return ((CompletableFuture)this.getMessageNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMessageAsync(LocalizedText message) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)message));
        return this.getMessageNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMessageNode() throws UaException {
        try {
            return this.getMessageNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMessageNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Message", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getSeverity() throws UaException {
        PropertyTypeNode node = this.getSeverityNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setSeverity(UShort value) throws UaException {
        PropertyTypeNode node = this.getSeverityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readSeverity() throws UaException {
        try {
            return this.readSeverityAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSeverity(UShort value) throws UaException {
        try {
            this.writeSeverityAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readSeverityAsync() {
        return ((CompletableFuture)this.getSeverityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSeverityAsync(UShort severity) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)severity));
        return this.getSeverityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSeverityNode() throws UaException {
        try {
            return this.getSeverityNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSeverityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Severity", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId getConditionClassId() throws UaException {
        PropertyTypeNode node = this.getConditionClassIdNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionClassId(NodeId value) throws UaException {
        PropertyTypeNode node = this.getConditionClassIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readConditionClassId() throws UaException {
        try {
            return this.readConditionClassIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeConditionClassId(NodeId value) throws UaException {
        try {
            this.writeConditionClassIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readConditionClassIdAsync() {
        return ((CompletableFuture)this.getConditionClassIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionClassIdAsync(NodeId conditionClassId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)conditionClassId));
        return this.getConditionClassIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionClassIdNode() throws UaException {
        try {
            return this.getConditionClassIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConditionClassIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionClassId", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getConditionClassName() throws UaException {
        PropertyTypeNode node = this.getConditionClassNameNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionClassName(LocalizedText value) throws UaException {
        PropertyTypeNode node = this.getConditionClassNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readConditionClassName() throws UaException {
        try {
            return this.readConditionClassNameAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeConditionClassName(LocalizedText value) throws UaException {
        try {
            this.writeConditionClassNameAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readConditionClassNameAsync() {
        return ((CompletableFuture)this.getConditionClassNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionClassNameAsync(LocalizedText conditionClassName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)conditionClassName));
        return this.getConditionClassNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionClassNameNode() throws UaException {
        try {
            return this.getConditionClassNameNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConditionClassNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionClassName", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId[] getConditionSubClassId() throws UaException {
        PropertyTypeNode node = this.getConditionSubClassIdNode();
        return (NodeId[])node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionSubClassId(NodeId[] value) throws UaException {
        PropertyTypeNode node = this.getConditionSubClassIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId[] readConditionSubClassId() throws UaException {
        try {
            return this.readConditionSubClassIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeConditionSubClassId(NodeId[] value) throws UaException {
        try {
            this.writeConditionSubClassIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends NodeId[]> readConditionSubClassIdAsync() {
        return ((CompletableFuture)this.getConditionSubClassIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionSubClassIdAsync(NodeId[] conditionSubClassId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)conditionSubClassId));
        return this.getConditionSubClassIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionSubClassIdNode() throws UaException {
        try {
            return this.getConditionSubClassIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConditionSubClassIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionSubClassId", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText[] getConditionSubClassName() throws UaException {
        PropertyTypeNode node = this.getConditionSubClassNameNode();
        return (LocalizedText[])node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionSubClassName(LocalizedText[] value) throws UaException {
        PropertyTypeNode node = this.getConditionSubClassNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText[] readConditionSubClassName() throws UaException {
        try {
            return this.readConditionSubClassNameAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeConditionSubClassName(LocalizedText[] value) throws UaException {
        try {
            this.writeConditionSubClassNameAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText[]> readConditionSubClassNameAsync() {
        return ((CompletableFuture)this.getConditionSubClassNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionSubClassNameAsync(LocalizedText[] conditionSubClassName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)conditionSubClassName));
        return this.getConditionSubClassNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionSubClassNameNode() throws UaException {
        try {
            return this.getConditionSubClassNameNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConditionSubClassNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionSubClassName", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

