/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AuditUpdateMethodEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.AuditUpdateStateEventType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class AuditUpdateStateEventTypeNode
extends AuditUpdateMethodEventTypeNode
implements AuditUpdateStateEventType {
    public AuditUpdateStateEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public Object getOldStateId() throws UaException {
        PropertyTypeNode node = this.getOldStateIdNode();
        return node.getValue().getValue().getValue();
    }

    @Override
    public void setOldStateId(Object value) throws UaException {
        PropertyTypeNode node = this.getOldStateIdNode();
        node.setValue(new Variant(value));
    }

    @Override
    public Object readOldStateId() throws UaException {
        try {
            return this.readOldStateIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeOldStateId(Object value) throws UaException {
        try {
            this.writeOldStateIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<?> readOldStateIdAsync() {
        return ((CompletableFuture)this.getOldStateIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeOldStateIdAsync(Object oldStateId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant(oldStateId));
        return this.getOldStateIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getOldStateIdNode() throws UaException {
        try {
            return this.getOldStateIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getOldStateIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OldStateId", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Object getNewStateId() throws UaException {
        PropertyTypeNode node = this.getNewStateIdNode();
        return node.getValue().getValue().getValue();
    }

    @Override
    public void setNewStateId(Object value) throws UaException {
        PropertyTypeNode node = this.getNewStateIdNode();
        node.setValue(new Variant(value));
    }

    @Override
    public Object readNewStateId() throws UaException {
        try {
            return this.readNewStateIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeNewStateId(Object value) throws UaException {
        try {
            this.writeNewStateIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<?> readNewStateIdAsync() {
        return ((CompletableFuture)this.getNewStateIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNewStateIdAsync(Object newStateId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant(newStateId));
        return this.getNewStateIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNewStateIdNode() throws UaException {
        try {
            return this.getNewStateIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNewStateIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NewStateId", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

