/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AggregateConfigurationType;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class AggregateConfigurationTypeNode
extends BaseObjectTypeNode
implements AggregateConfigurationType {
    public AggregateConfigurationTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public Boolean getTreatUncertainAsBad() throws UaException {
        PropertyTypeNode node = this.getTreatUncertainAsBadNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setTreatUncertainAsBad(Boolean value) throws UaException {
        PropertyTypeNode node = this.getTreatUncertainAsBadNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readTreatUncertainAsBad() throws UaException {
        try {
            return this.readTreatUncertainAsBadAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeTreatUncertainAsBad(Boolean value) throws UaException {
        try {
            this.writeTreatUncertainAsBadAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readTreatUncertainAsBadAsync() {
        return ((CompletableFuture)this.getTreatUncertainAsBadNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTreatUncertainAsBadAsync(Boolean treatUncertainAsBad) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)treatUncertainAsBad));
        return this.getTreatUncertainAsBadNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getTreatUncertainAsBadNode() throws UaException {
        try {
            return this.getTreatUncertainAsBadNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getTreatUncertainAsBadNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TreatUncertainAsBad", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UByte getPercentDataBad() throws UaException {
        PropertyTypeNode node = this.getPercentDataBadNode();
        return (UByte)node.getValue().getValue().getValue();
    }

    @Override
    public void setPercentDataBad(UByte value) throws UaException {
        PropertyTypeNode node = this.getPercentDataBadNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte readPercentDataBad() throws UaException {
        try {
            return this.readPercentDataBadAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writePercentDataBad(UByte value) throws UaException {
        try {
            this.writePercentDataBadAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UByte> readPercentDataBadAsync() {
        return ((CompletableFuture)this.getPercentDataBadNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePercentDataBadAsync(UByte percentDataBad) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)percentDataBad));
        return this.getPercentDataBadNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPercentDataBadNode() throws UaException {
        try {
            return this.getPercentDataBadNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPercentDataBadNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PercentDataBad", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UByte getPercentDataGood() throws UaException {
        PropertyTypeNode node = this.getPercentDataGoodNode();
        return (UByte)node.getValue().getValue().getValue();
    }

    @Override
    public void setPercentDataGood(UByte value) throws UaException {
        PropertyTypeNode node = this.getPercentDataGoodNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte readPercentDataGood() throws UaException {
        try {
            return this.readPercentDataGoodAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writePercentDataGood(UByte value) throws UaException {
        try {
            this.writePercentDataGoodAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UByte> readPercentDataGoodAsync() {
        return ((CompletableFuture)this.getPercentDataGoodNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePercentDataGoodAsync(UByte percentDataGood) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)percentDataGood));
        return this.getPercentDataGoodNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPercentDataGoodNode() throws UaException {
        try {
            return this.getPercentDataGoodNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPercentDataGoodNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PercentDataGood", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getUseSlopedExtrapolation() throws UaException {
        PropertyTypeNode node = this.getUseSlopedExtrapolationNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setUseSlopedExtrapolation(Boolean value) throws UaException {
        PropertyTypeNode node = this.getUseSlopedExtrapolationNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readUseSlopedExtrapolation() throws UaException {
        try {
            return this.readUseSlopedExtrapolationAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeUseSlopedExtrapolation(Boolean value) throws UaException {
        try {
            this.writeUseSlopedExtrapolationAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readUseSlopedExtrapolationAsync() {
        return ((CompletableFuture)this.getUseSlopedExtrapolationNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeUseSlopedExtrapolationAsync(Boolean useSlopedExtrapolation) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)useSlopedExtrapolation));
        return this.getUseSlopedExtrapolationNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getUseSlopedExtrapolationNode() throws UaException {
        try {
            return this.getUseSlopedExtrapolationNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUseSlopedExtrapolationNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UseSlopedExtrapolation", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

