/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.methods;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.methods.UaMethodException;
import org.eclipse.milo.opcua.sdk.client.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaObjectNode;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;

public class UaMethod {
    private final OpcUaClient client;
    private final UaObjectNode objectNode;
    private final UaMethodNode methodNode;
    private final Argument[] inputArguments;
    private final Argument[] outputArguments;

    public UaMethod(OpcUaClient client, UaObjectNode objectNode, UaMethodNode methodNode, Argument[] inputArguments, Argument[] outputArguments) {
        this.client = client;
        this.objectNode = objectNode;
        this.methodNode = methodNode;
        this.inputArguments = inputArguments;
        this.outputArguments = outputArguments;
    }

    public UaObjectNode getObjectNode() {
        return this.objectNode;
    }

    public UaMethodNode getMethodNode() {
        return this.methodNode;
    }

    public Argument[] getInputArguments() {
        return this.inputArguments;
    }

    public Argument[] getOutputArguments() {
        return this.outputArguments;
    }

    public Variant[] call(Variant[] inputs) throws UaMethodException, UaException {
        try {
            return this.callAsync(inputs).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Object var4_3 = UaException.extract((Throwable)e).orElse(null);
            if (var4_3 instanceof UaMethodException) {
                UaMethodException mx = var4_3;
                throw new UaMethodException(mx.getCause(), mx.getStatusCode(), mx.getInputArgumentResults(), mx.getInputArgumentDiagnostics());
            }
            throw new UaException((Throwable)e);
        }
    }

    public CompletableFuture<Variant[]> callAsync(Variant[] inputs) {
        CallMethodRequest request = new CallMethodRequest(this.objectNode.getNodeId(), this.methodNode.getNodeId(), inputs);
        return ((CompletableFuture)this.client.callAsync(List.of(request)).thenApply(response -> Objects.requireNonNull(response.getResults())[0])).thenCompose(result -> {
            StatusCode statusCode = result.getStatusCode();
            if (statusCode.isGood()) {
                return CompletableFuture.completedFuture(result.getOutputArguments());
            }
            return CompletableFuture.failedFuture((Throwable)((Object)new UaMethodException(statusCode, result.getInputArgumentResults(), result.getInputArgumentDiagnosticInfos())));
        });
    }
}

