/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.identity;

import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.client.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.identity.SignedIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.AnonymousIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;

public class AnonymousProvider
implements IdentityProvider {
    public static final IdentityProvider INSTANCE = new AnonymousProvider();

    @Override
    public SignedIdentityToken getIdentityToken(EndpointDescription endpoint, ByteString serverNonce) throws Exception {
        UserTokenPolicy[] userIdentityTokens = Objects.requireNonNullElse(endpoint.getUserIdentityTokens(), new UserTokenPolicy[0]);
        return Stream.of(userIdentityTokens).filter(t -> t.getTokenType() == UserTokenType.Anonymous).findFirst().map(policy -> {
            AnonymousIdentityToken token = new AnonymousIdentityToken(policy.getPolicyId());
            return new SignedIdentityToken((UserIdentityToken)token, new SignatureData(null, null));
        }).orElseThrow(() -> new Exception("no anonymous token policy found"));
    }

    public String toString() {
        return "AnonymousProvider{}";
    }
}

