/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.client.BrowseHelper;
import org.eclipse.milo.opcua.sdk.client.NodeCache;
import org.eclipse.milo.opcua.sdk.client.ObjectTypeManager;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.VariableTypeManager;
import org.eclipse.milo.opcua.sdk.client.model.objects.ServerTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaDataTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaViewNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.OptionSetUInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UNumber;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.shaded.com.google.common.base.Preconditions;
import org.eclipse.milo.shaded.com.google.common.collect.Sets;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressSpace {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private NodeCache nodeCache = new NodeCache();
    private BrowseOptions browseOptions = new BrowseOptions();
    private final OpcUaClient client;

    public AddressSpace(OpcUaClient client) {
        this.client = client;
    }

    public UaNode getNode(NodeId nodeId) throws UaException {
        try {
            return this.getNodeAsync(nodeId).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends UaNode> getNodeAsync(NodeId nodeId) {
        UaNode cachedNode = this.nodeCache.getIfPresent(nodeId);
        if (cachedNode != null) {
            return CompletableFuture.completedFuture(cachedNode);
        }
        return this.createNode(nodeId).whenComplete((node, ex) -> {
            if (node != null) {
                this.nodeCache.put(nodeId, (UaNode)node);
            }
        });
    }

    public UaObjectNode getObjectNode(NodeId nodeId) throws UaException {
        try {
            return this.getObjectNodeAsync(nodeId).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public UaObjectNode getObjectNode(NodeId nodeId, NodeId typeDefinitionId) throws UaException {
        try {
            return this.getObjectNodeAsync(nodeId, typeDefinitionId).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<UaObjectNode> getObjectNodeAsync(NodeId nodeId) {
        UaNode cachedNode = this.nodeCache.getIfPresent(nodeId);
        if (cachedNode instanceof UaObjectNode) {
            return CompletableFuture.completedFuture((UaObjectNode)cachedNode);
        }
        CompletableFuture<NodeId> typeDefinitionFuture = this.readTypeDefinition(nodeId);
        return typeDefinitionFuture.thenCompose(typeDefinitionId -> this.getObjectNodeAsync(nodeId, (NodeId)typeDefinitionId));
    }

    public CompletableFuture<UaObjectNode> getObjectNodeAsync(NodeId nodeId, NodeId typeDefinitionId) {
        UaNode cachedNode = this.nodeCache.getIfPresent(nodeId);
        if (cachedNode instanceof UaObjectNode) {
            return CompletableFuture.completedFuture((UaObjectNode)cachedNode);
        }
        CompletableFuture<ReadResponse> future = this.readAttributes(nodeId, AttributeId.OBJECT_ATTRIBUTES);
        return future.thenCompose(response -> {
            DataValue[] attributeValues = Objects.requireNonNull(response.getResults());
            try {
                UaObjectNode node = this.newObjectNode(nodeId, typeDefinitionId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    public UaVariableNode getVariableNode(NodeId nodeId) throws UaException {
        try {
            return this.getVariableNodeAsync(nodeId).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public UaVariableNode getVariableNode(NodeId nodeId, NodeId typeDefinitionId) throws UaException {
        try {
            return this.getVariableNodeAsync(nodeId, typeDefinitionId).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<UaVariableNode> getVariableNodeAsync(NodeId nodeId) {
        UaNode cachedNode = this.nodeCache.getIfPresent(nodeId);
        if (cachedNode instanceof UaVariableNode) {
            return CompletableFuture.completedFuture((UaVariableNode)cachedNode);
        }
        CompletableFuture<NodeId> typeDefinitionFuture = this.readTypeDefinition(nodeId);
        return typeDefinitionFuture.thenCompose(typeDefinitionId -> this.getVariableNodeAsync(nodeId, (NodeId)typeDefinitionId));
    }

    public CompletableFuture<UaVariableNode> getVariableNodeAsync(NodeId nodeId, NodeId typeDefinitionId) {
        UaNode cachedNode = this.nodeCache.getIfPresent(nodeId);
        if (cachedNode instanceof UaVariableNode) {
            return CompletableFuture.completedFuture((UaVariableNode)cachedNode);
        }
        CompletableFuture<ReadResponse> future = this.readAttributes(nodeId, AttributeId.VARIABLE_ATTRIBUTES);
        return future.thenCompose(response -> {
            DataValue[] variableAttributeValues = Objects.requireNonNull(response.getResults());
            try {
                UaVariableNode node = this.newVariableNode(nodeId, typeDefinitionId, variableAttributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    public UaObjectNode getObjectsFolderNode() throws UaException {
        return this.getObjectNode(NodeIds.ObjectsFolder);
    }

    public UaObjectNode getRootFolderNode() throws UaException {
        return this.getObjectNode(NodeIds.RootFolder);
    }

    public UaObjectNode getTypesFolderNode() throws UaException {
        return this.getObjectNode(NodeIds.TypesFolder);
    }

    public ServerTypeNode getServerNode() throws UaException {
        return (ServerTypeNode)this.getObjectNode(NodeIds.Server, NodeIds.ServerType);
    }

    public List<ReferenceDescription> browse(UaNode node) throws UaException {
        return this.browse(node, this.getBrowseOptions());
    }

    public List<ReferenceDescription> browse(UaNode node, BrowseOptions browseOptions) throws UaException {
        try {
            return this.browseAsync(node, browseOptions).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public List<ReferenceDescription> browse(NodeId nodeId) throws UaException {
        return this.browse(nodeId, this.getBrowseOptions());
    }

    public List<ReferenceDescription> browse(NodeId nodeId, BrowseOptions browseOptions) throws UaException {
        try {
            return this.browseAsync(nodeId, browseOptions).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<List<ReferenceDescription>> browseAsync(UaNode node) {
        return this.browseAsync(node.getNodeId(), this.getBrowseOptions());
    }

    public CompletableFuture<List<ReferenceDescription>> browseAsync(UaNode node, BrowseOptions browseOptions) {
        return this.browseAsync(node.getNodeId(), browseOptions);
    }

    public CompletableFuture<List<ReferenceDescription>> browseAsync(NodeId nodeId) {
        return this.browseAsync(nodeId, this.getBrowseOptions());
    }

    public CompletableFuture<List<ReferenceDescription>> browseAsync(NodeId nodeId, BrowseOptions browseOptions) {
        BrowseDescription browseDescription = new BrowseDescription(nodeId, browseOptions.getBrowseDirection(), browseOptions.getReferenceTypeId(), Boolean.valueOf(browseOptions.isIncludeSubtypes()), browseOptions.getNodeClassMask(), browseOptions.getResultMask());
        return BrowseHelper.browse(this.client, browseDescription, browseOptions.getMaxReferencesPerNode());
    }

    public List<? extends UaNode> browseNodes(UaNode node) throws UaException {
        return this.browseNodes(node, this.getBrowseOptions());
    }

    public List<? extends UaNode> browseNodes(UaNode node, BrowseOptions browseOptions) throws UaException {
        try {
            return this.browseNodesAsync(node, browseOptions).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public List<? extends UaNode> browseNodes(NodeId nodeId) throws UaException {
        return this.browseNodes(nodeId, this.getBrowseOptions());
    }

    public List<? extends UaNode> browseNodes(NodeId nodeId, BrowseOptions browseOptions) throws UaException {
        try {
            return this.browseNodesAsync(nodeId, browseOptions).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<List<? extends UaNode>> browseNodesAsync(UaNode node) {
        return this.browseNodesAsync(node.getNodeId());
    }

    public CompletableFuture<List<? extends UaNode>> browseNodesAsync(UaNode node, BrowseOptions browseOptions) {
        return this.browseNodesAsync(node.getNodeId(), browseOptions);
    }

    public CompletableFuture<List<? extends UaNode>> browseNodesAsync(NodeId nodeId) {
        return this.browseNodesAsync(nodeId, this.getBrowseOptions());
    }

    public CompletableFuture<List<? extends UaNode>> browseNodesAsync(NodeId nodeId, BrowseOptions browseOptions) {
        BrowseDescription browseDescription = new BrowseDescription(nodeId, browseOptions.getBrowseDirection(), browseOptions.getReferenceTypeId(), Boolean.valueOf(browseOptions.isIncludeSubtypes()), browseOptions.getNodeClassMask(), browseOptions.getResultMask());
        CompletableFuture<List<ReferenceDescription>> browse = BrowseHelper.browse(this.client, browseDescription, browseOptions.getMaxReferencesPerNode());
        return browse.thenCompose(references -> {
            List<CompletableFuture<? extends UaNode>> cfs = references.stream().map(reference -> {
                NodeClass nodeClass = reference.getNodeClass();
                ExpandedNodeId xNodeId = reference.getNodeId();
                ExpandedNodeId xTypeDefinitionId = reference.getTypeDefinition();
                switch (nodeClass) {
                    case Object: 
                    case Variable: {
                        CompletionStage ff = this.toNodeIdAsync(xNodeId).thenCombine(this.toNodeIdAsync(xTypeDefinitionId), (targetNodeId, typeDefinitionId) -> {
                            if (nodeClass == NodeClass.Object) {
                                return this.getObjectNodeAsync((NodeId)targetNodeId, (NodeId)typeDefinitionId);
                            }
                            return this.getVariableNodeAsync((NodeId)targetNodeId, (NodeId)typeDefinitionId);
                        });
                        return AddressSpace.unwrap((CompletableFuture<CompletableFuture<? extends UaNode>>)ff).exceptionally(ex -> {
                            this.logger.warn("Failed to create Node from Reference to {}", (Object)reference.getNodeId(), ex);
                            return null;
                        });
                    }
                }
                return ((CompletableFuture)this.toNodeIdAsync(xNodeId).thenCompose(this::getNodeAsync)).exceptionally(ex -> {
                    this.logger.warn("Failed to create Node from Reference to {}", (Object)reference.getNodeId(), ex);
                    return null;
                });
            }).collect(Collectors.toList());
            return AddressSpace.sequence(cfs);
        });
    }

    private static CompletableFuture<List<? extends UaNode>> sequence(List<CompletableFuture<? extends UaNode>> cfs) {
        if (cfs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture[] fa = cfs.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(fa).thenApply(v -> {
            ArrayList<UaNode> results = new ArrayList<UaNode>(cfs.size());
            for (CompletableFuture cf : cfs) {
                UaNode node = (UaNode)cf.join();
                if (node == null) continue;
                results.add(node);
            }
            return results;
        });
    }

    private static CompletableFuture<? extends UaNode> unwrap(CompletableFuture<CompletableFuture<? extends UaNode>> future) {
        return future.thenCompose(node -> node);
    }

    public NodeId toNodeId(ExpandedNodeId xni) {
        try {
            return this.toNodeIdAsync(xni).get();
        }
        catch (InterruptedException | ExecutionException e) {
            return NodeId.NULL_VALUE;
        }
    }

    public CompletableFuture<NodeId> toNodeIdAsync(ExpandedNodeId xni) {
        if (xni.isLocal()) {
            Optional local = xni.toNodeId(this.client.getNamespaceTable());
            return local.map(CompletableFuture::completedFuture).orElse((CompletableFuture)((CompletableFuture)this.client.readNamespaceTableAsync().thenCompose(namespaceTable -> CompletableFuture.completedFuture(xni.toNodeId(namespaceTable).orElse(NodeId.NULL_VALUE)))).exceptionally(e -> NodeId.NULL_VALUE));
        }
        return CompletableFuture.completedFuture(NodeId.NULL_VALUE);
    }

    public synchronized BrowseOptions getBrowseOptions() {
        return this.browseOptions;
    }

    public synchronized void modifyBrowseOptions(Consumer<BrowseOptions.Builder> builderConsumer) {
        BrowseOptions.Builder builder = new BrowseOptions.Builder(this.browseOptions);
        builderConsumer.accept(builder);
        this.setBrowseOptions(builder.build());
    }

    public synchronized void setBrowseOptions(BrowseOptions browseOptions) {
        this.browseOptions = browseOptions;
    }

    public synchronized NodeCache getNodeCache() {
        return this.nodeCache;
    }

    public synchronized void setNodeCache(NodeCache nodeCache) {
        this.nodeCache = nodeCache;
    }

    private CompletableFuture<NodeId> readTypeDefinition(NodeId nodeId) {
        CompletableFuture<BrowseResult> browseFuture = this.client.browseAsync(new BrowseDescription(nodeId, BrowseDirection.Forward, NodeIds.HasTypeDefinition, Boolean.valueOf(false), Unsigned.uint((int)0), Unsigned.uint((int)BrowseResultMask.All.getValue())));
        return browseFuture.thenCompose(result -> {
            if (result.getStatusCode().isGood()) {
                ReferenceDescription[] references = Objects.requireNonNullElse(result.getReferences(), new ReferenceDescription[0]);
                Optional<ExpandedNodeId> typeDefinitionId = Stream.of(references).filter(r -> Objects.equals(NodeIds.HasTypeDefinition, r.getReferenceTypeId())).map(ReferenceDescription::getNodeId).findFirst();
                return typeDefinitionId.map(this::toNodeIdAsync).orElse(CompletableFuture.completedFuture(NodeId.NULL_VALUE));
            }
            return CompletableFuture.completedFuture(NodeId.NULL_VALUE);
        });
    }

    private CompletableFuture<? extends UaNode> createNode(NodeId nodeId) {
        CompletableFuture<ReadResponse> future = this.readAttributes(nodeId, AttributeId.BASE_ATTRIBUTES);
        return future.thenCompose(response -> {
            DataValue[] results = Objects.requireNonNull(response.getResults());
            return this.createNodeFromBaseAttributes(nodeId, results);
        });
    }

    private CompletableFuture<? extends UaNode> createNodeFromBaseAttributes(NodeId nodeId, DataValue[] baseAttributeValues) {
        StatusCode nodeIdStatusCode = baseAttributeValues[0].statusCode();
        if (nodeIdStatusCode.isBad()) {
            return FutureUtils.failedUaFuture((StatusCode)nodeIdStatusCode);
        }
        Integer nodeClassValue = (Integer)baseAttributeValues[1].value().value();
        if (nodeClassValue == null) {
            return FutureUtils.failedUaFuture((long)2153709568L);
        }
        NodeClass nodeClass = NodeClass.from((int)nodeClassValue);
        if (nodeClass == null) {
            return FutureUtils.failedUaFuture((long)2153709568L);
        }
        switch (nodeClass) {
            case DataType: {
                return this.createDataTypeNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case Method: {
                return this.createMethodNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case Object: {
                return this.createObjectNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case ObjectType: {
                return this.createObjectTypeNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case ReferenceType: {
                return this.createReferenceTypeNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case Variable: {
                return this.createVariableNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case VariableType: {
                return this.createVariableTypeNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case View: {
                return this.createViewNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
        }
        throw new IllegalArgumentException("NodeClass: " + String.valueOf(nodeClass));
    }

    private CompletableFuture<UaDataTypeNode> createDataTypeNodeFromBaseAttributes(NodeId nodeId, DataValue[] baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.DATA_TYPE_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        return attributesFuture.thenCompose(response -> {
            DataValue[] dataTypeAttributeValues = Objects.requireNonNull(response.getResults());
            DataValue[] attributeValues = AddressSpace.concat(baseAttributeValues, dataTypeAttributeValues);
            try {
                UaDataTypeNode node = this.newDataTypeNode(nodeId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaMethodNode> createMethodNodeFromBaseAttributes(NodeId nodeId, DataValue[] baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.METHOD_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        return attributesFuture.thenCompose(response -> {
            DataValue[] methodAttributeValues = Objects.requireNonNull(response.getResults());
            DataValue[] attributeValues = AddressSpace.concat(baseAttributeValues, methodAttributeValues);
            try {
                UaMethodNode node = this.newMethodNode(nodeId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaObjectNode> createObjectNodeFromBaseAttributes(NodeId nodeId, DataValue[] baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.OBJECT_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        CompletableFuture<NodeId> typeDefinitionFuture = this.readTypeDefinition(nodeId);
        return CompletableFuture.allOf(attributesFuture, typeDefinitionFuture).thenCompose(ignored -> {
            ReadResponse response = (ReadResponse)attributesFuture.join();
            NodeId typeDefinitionId = (NodeId)typeDefinitionFuture.join();
            DataValue[] objectAttributeValues = Objects.requireNonNull(response.getResults());
            DataValue[] attributeValues = AddressSpace.concat(baseAttributeValues, objectAttributeValues);
            try {
                UaObjectNode node = this.newObjectNode(nodeId, typeDefinitionId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaObjectTypeNode> createObjectTypeNodeFromBaseAttributes(NodeId nodeId, DataValue[] baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.OBJECT_TYPE_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        return attributesFuture.thenCompose(response -> {
            DataValue[] objectTypeAttributeValues = Objects.requireNonNull(response.getResults());
            DataValue[] attributeValues = AddressSpace.concat(baseAttributeValues, objectTypeAttributeValues);
            try {
                UaObjectTypeNode node = this.newObjectTypeNode(nodeId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaReferenceTypeNode> createReferenceTypeNodeFromBaseAttributes(NodeId nodeId, DataValue[] baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.REFERENCE_TYPE_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        return attributesFuture.thenCompose(response -> {
            DataValue[] referenceTypeAttributeValues = Objects.requireNonNull(response.getResults());
            DataValue[] attributeValues = AddressSpace.concat(baseAttributeValues, referenceTypeAttributeValues);
            try {
                UaReferenceTypeNode node = this.newReferenceTypeNode(nodeId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaVariableNode> createVariableNodeFromBaseAttributes(NodeId nodeId, DataValue[] baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.VARIABLE_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        CompletableFuture<NodeId> typeDefinitionFuture = this.readTypeDefinition(nodeId);
        return CompletableFuture.allOf(attributesFuture, typeDefinitionFuture).thenCompose(ignored -> {
            ReadResponse response = (ReadResponse)attributesFuture.join();
            NodeId typeDefinitionId = (NodeId)typeDefinitionFuture.join();
            DataValue[] variableAttributeValues = Objects.requireNonNull(response.getResults());
            DataValue[] attributeValues = AddressSpace.concat(baseAttributeValues, variableAttributeValues);
            try {
                UaVariableNode node = this.newVariableNode(nodeId, typeDefinitionId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaVariableTypeNode> createVariableTypeNodeFromBaseAttributes(NodeId nodeId, DataValue[] baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.VARIABLE_TYPE_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        return attributesFuture.thenCompose(response -> {
            DataValue[] variableTypeAttributeValues = Objects.requireNonNull(response.getResults());
            DataValue[] attributeValues = AddressSpace.concat(baseAttributeValues, variableTypeAttributeValues);
            try {
                UaVariableTypeNode node = this.newVariableTypeNode(nodeId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaViewNode> createViewNodeFromBaseAttributes(NodeId nodeId, DataValue[] baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.VIEW_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        return attributesFuture.thenCompose(response -> {
            DataValue[] viewAttributeValues = Objects.requireNonNull(response.getResults());
            DataValue[] attributeValues = AddressSpace.concat(baseAttributeValues, viewAttributeValues);
            try {
                UaViewNode node = this.newViewNode(nodeId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<ReadResponse> readAttributes(NodeId nodeId, Set<AttributeId> attributeIds) {
        List<ReadValueId> readValueIds = attributeIds.stream().map(id -> new ReadValueId(nodeId, id.uid(), null, QualifiedName.NULL_VALUE)).collect(Collectors.toList());
        return this.client.readAsync(0.0, TimestampsToReturn.Neither, readValueIds);
    }

    private UaDataTypeNode newDataTypeNode(NodeId nodeId, DataValue[] attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues[0];
        StatusCode nodeIdStatusCode = nodeIdDataValue.statusCode();
        if (nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)Objects.requireNonNullElse(attributeValues[1].value().value(), 0));
            Preconditions.checkArgument((nodeClass == NodeClass.DataType ? 1 : 0) != 0, (Object)("expected NodeClass.DataType, got NodeClass." + String.valueOf(nodeClass)));
            QualifiedName browseName = (QualifiedName)attributeValues[2].value().value();
            LocalizedText displayName = (LocalizedText)attributeValues[3].value().value();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues[4], LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues[5], UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues[6], UInteger.class);
            RolePermissionType[] rolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[7], RolePermissionType[].class);
            RolePermissionType[] userRolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[8], RolePermissionType[].class);
            AccessRestrictionType accessRestrictions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[9], AccessRestrictionType.class);
            Boolean isAbstract = (Boolean)attributeValues[10].value().value();
            DataTypeDefinition dataTypeDefinition = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[11], DataTypeDefinition.class);
            return new UaDataTypeNode(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, isAbstract, dataTypeDefinition);
        }
        catch (Throwable t) {
            throw new UaException(t);
        }
    }

    private UaMethodNode newMethodNode(NodeId nodeId, DataValue[] attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues[0];
        StatusCode nodeIdStatusCode = nodeIdDataValue.statusCode();
        if (nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)Objects.requireNonNullElse(attributeValues[1].value().value(), 0));
            Preconditions.checkArgument((nodeClass == NodeClass.Method ? 1 : 0) != 0, (Object)("expected NodeClass.Method, got NodeClass." + String.valueOf(nodeClass)));
            QualifiedName browseName = (QualifiedName)attributeValues[2].value().value();
            LocalizedText displayName = (LocalizedText)attributeValues[3].value().value();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues[4], LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues[5], UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues[6], UInteger.class);
            RolePermissionType[] rolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[7], RolePermissionType[].class);
            RolePermissionType[] userRolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[8], RolePermissionType[].class);
            AccessRestrictionType accessRestrictions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[9], AccessRestrictionType.class);
            Boolean executable = (Boolean)attributeValues[10].value().value();
            Boolean userExecutable = (Boolean)attributeValues[11].value().value();
            return new UaMethodNode(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, executable, userExecutable);
        }
        catch (Throwable t) {
            throw new UaException(t);
        }
    }

    private UaObjectNode newObjectNode(NodeId nodeId, NodeId typeDefinitionId, DataValue[] attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues[0];
        StatusCode nodeIdStatusCode = nodeIdDataValue.statusCode();
        if (nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)Objects.requireNonNullElse(attributeValues[1].value().value(), 0));
            Preconditions.checkArgument((nodeClass == NodeClass.Object ? 1 : 0) != 0, (Object)("expected NodeClass.Object, got NodeClass." + String.valueOf(nodeClass)));
            QualifiedName browseName = (QualifiedName)attributeValues[2].value().value();
            LocalizedText displayName = (LocalizedText)attributeValues[3].value().value();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues[4], LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues[5], UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues[6], UInteger.class);
            RolePermissionType[] rolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[7], RolePermissionType[].class);
            RolePermissionType[] userRolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[8], RolePermissionType[].class);
            AccessRestrictionType accessRestrictions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[9], AccessRestrictionType.class);
            UByte eventNotifier = (UByte)attributeValues[10].value().value();
            ObjectTypeManager.ObjectNodeConstructor constructor = this.client.getObjectTypeManager().getNodeConstructor(typeDefinitionId).orElse(UaObjectNode::new);
            return constructor.apply(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
        }
        catch (Throwable t) {
            throw new UaException(t);
        }
    }

    private UaObjectTypeNode newObjectTypeNode(NodeId nodeId, DataValue[] attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues[0];
        StatusCode nodeIdStatusCode = nodeIdDataValue.statusCode();
        if (nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)Objects.requireNonNullElse(attributeValues[1].value().value(), 0));
            Preconditions.checkArgument((nodeClass == NodeClass.ObjectType ? 1 : 0) != 0, (Object)("expected NodeClass.ObjectType, got NodeClass." + String.valueOf(nodeClass)));
            QualifiedName browseName = (QualifiedName)attributeValues[2].value().value();
            LocalizedText displayName = (LocalizedText)attributeValues[3].value().value();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues[4], LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues[5], UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues[6], UInteger.class);
            RolePermissionType[] rolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[7], RolePermissionType[].class);
            RolePermissionType[] userRolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[8], RolePermissionType[].class);
            AccessRestrictionType accessRestrictions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[9], AccessRestrictionType.class);
            Boolean isAbstract = (Boolean)attributeValues[10].value().value();
            return new UaObjectTypeNode(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, isAbstract);
        }
        catch (Throwable t) {
            throw new UaException(t);
        }
    }

    private UaReferenceTypeNode newReferenceTypeNode(NodeId nodeId, DataValue[] attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues[0];
        StatusCode nodeIdStatusCode = nodeIdDataValue.statusCode();
        if (nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)Objects.requireNonNullElse(attributeValues[1].value().value(), 0));
            Preconditions.checkArgument((nodeClass == NodeClass.ReferenceType ? 1 : 0) != 0, (Object)("expected NodeClass.ReferenceType, got NodeClass." + String.valueOf(nodeClass)));
            QualifiedName browseName = (QualifiedName)attributeValues[2].value().value();
            LocalizedText displayName = (LocalizedText)attributeValues[3].value().value();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues[4], LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues[5], UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues[6], UInteger.class);
            RolePermissionType[] rolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[7], RolePermissionType[].class);
            RolePermissionType[] userRolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[8], RolePermissionType[].class);
            AccessRestrictionType accessRestrictions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[9], AccessRestrictionType.class);
            Boolean isAbstract = (Boolean)attributeValues[10].value().value();
            Boolean symmetric = (Boolean)attributeValues[11].value().value();
            LocalizedText inverseName = AddressSpace.getAttributeOrNull(attributeValues[12], LocalizedText.class);
            return new UaReferenceTypeNode(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, isAbstract, symmetric, inverseName);
        }
        catch (Throwable t) {
            throw new UaException(t);
        }
    }

    private UaVariableNode newVariableNode(NodeId nodeId, NodeId typeDefinitionId, DataValue[] attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues[0];
        StatusCode nodeIdStatusCode = nodeIdDataValue.statusCode();
        if (nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)Objects.requireNonNullElse(attributeValues[1].value().value(), 0));
            Preconditions.checkArgument((nodeClass == NodeClass.Variable ? 1 : 0) != 0, (Object)("expected NodeClass.Variable, got NodeClass." + String.valueOf(nodeClass)));
            QualifiedName browseName = (QualifiedName)attributeValues[2].value().value();
            LocalizedText displayName = (LocalizedText)attributeValues[3].value().value();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues[4], LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues[5], UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues[6], UInteger.class);
            RolePermissionType[] rolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[7], RolePermissionType[].class);
            RolePermissionType[] userRolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[8], RolePermissionType[].class);
            AccessRestrictionType accessRestrictions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[9], AccessRestrictionType.class);
            DataValue value = attributeValues[10];
            NodeId dataType = (NodeId)attributeValues[11].value().value();
            Integer valueRank = (Integer)attributeValues[12].value().value();
            UInteger[] arrayDimensions = AddressSpace.getAttributeOrNull(attributeValues[13], UInteger[].class);
            UByte accessLevel = (UByte)attributeValues[14].value().value();
            UByte userAccessLevel = (UByte)attributeValues[15].value().value();
            Double minimumSamplingInterval = AddressSpace.getAttributeOrNull(attributeValues[16], Double.class);
            Boolean historizing = (Boolean)attributeValues[17].value().value();
            AccessLevelExType accessLevelEx = AddressSpace.getAttributeOrNull(attributeValues[18], AccessLevelExType.class);
            VariableTypeManager.VariableNodeConstructor constructor = this.client.getVariableTypeManager().getNodeConstructor(typeDefinitionId).orElse(UaVariableNode::new);
            return constructor.apply(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
        }
        catch (Throwable t) {
            throw new UaException(t);
        }
    }

    private UaVariableTypeNode newVariableTypeNode(NodeId nodeId, DataValue[] attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues[0];
        StatusCode nodeIdStatusCode = nodeIdDataValue.statusCode();
        if (nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)Objects.requireNonNullElse(attributeValues[1].value().value(), 0));
            Preconditions.checkArgument((nodeClass == NodeClass.VariableType ? 1 : 0) != 0, (Object)("expected NodeClass.VariableType, got NodeClass." + String.valueOf(nodeClass)));
            QualifiedName browseName = (QualifiedName)attributeValues[2].value().value();
            LocalizedText displayName = (LocalizedText)attributeValues[3].value().value();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues[4], LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues[5], UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues[6], UInteger.class);
            RolePermissionType[] rolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[7], RolePermissionType[].class);
            RolePermissionType[] userRolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[8], RolePermissionType[].class);
            AccessRestrictionType accessRestrictions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[9], AccessRestrictionType.class);
            DataValue value = attributeValues[10];
            NodeId dataType = (NodeId)attributeValues[11].value().value();
            Integer valueRank = (Integer)attributeValues[12].value().value();
            UInteger[] arrayDimensions = AddressSpace.getAttributeOrNull(attributeValues[13], UInteger[].class);
            Boolean isAbstract = (Boolean)attributeValues[14].value().value();
            return new UaVariableTypeNode(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, isAbstract);
        }
        catch (Throwable t) {
            throw new UaException(t);
        }
    }

    private UaViewNode newViewNode(NodeId nodeId, DataValue[] attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues[0];
        StatusCode nodeIdStatusCode = nodeIdDataValue.statusCode();
        if (nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)Objects.requireNonNullElse(attributeValues[1].value().value(), 0));
            Preconditions.checkArgument((nodeClass == NodeClass.View ? 1 : 0) != 0, (Object)("expected NodeClass.View, got NodeClass." + String.valueOf(nodeClass)));
            QualifiedName browseName = (QualifiedName)attributeValues[2].value().value();
            LocalizedText displayName = (LocalizedText)attributeValues[3].value().value();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues[4], LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues[5], UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues[6], UInteger.class);
            RolePermissionType[] rolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[7], RolePermissionType[].class);
            RolePermissionType[] userRolePermissions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[8], RolePermissionType[].class);
            AccessRestrictionType accessRestrictions = AddressSpace.getAttributeOrNull(this.client.getStaticEncodingContext(), attributeValues[9], AccessRestrictionType.class);
            Boolean containsNoLoops = (Boolean)attributeValues[10].value().value();
            UByte eventNotifier = (UByte)attributeValues[11].value().value();
            return new UaViewNode(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, containsNoLoops, eventNotifier);
        }
        catch (Throwable t) {
            throw new UaException(t);
        }
    }

    private static <T> @Nullable T getAttributeOrNull(DataValue value, Class<T> attributeClazz) {
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            return null;
        }
        Object attributeValue = value.value().value();
        try {
            return attributeClazz.cast(attributeValue);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private static <T> @Nullable T getAttributeOrNull(EncodingContext context, DataValue value, Class<T> attributeClazz) {
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            return null;
        }
        Object o = value.value().value();
        try {
            if (o instanceof ExtensionObject) {
                ExtensionObject xo = (ExtensionObject)o;
                UaStructuredType decoded = xo.decode(context);
                return attributeClazz.cast(decoded);
            }
            if (o instanceof ExtensionObject[]) {
                ExtensionObject[] xos = (ExtensionObject[])o;
                Class<?> componentType = attributeClazz.getComponentType();
                Object array = Array.newInstance(componentType, xos.length);
                for (int i = 0; i < xos.length; ++i) {
                    ExtensionObject xo = xos[i];
                    UaStructuredType decoded = xo.decode(context);
                    Array.set(array, i, componentType.cast(decoded));
                }
                return attributeClazz.cast(array);
            }
            if (OptionSetUInteger.class.isAssignableFrom(attributeClazz) && o instanceof UNumber) {
                T optionSet = attributeClazz.getDeclaredConstructor(o.getClass()).newInstance(o);
                return attributeClazz.cast(optionSet);
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static DataValue[] concat(DataValue[] left, DataValue[] right) {
        return (DataValue[])Stream.concat(Stream.of(left), Stream.of(right)).toArray(DataValue[]::new);
    }

    public static class BrowseOptions {
        private final BrowseDirection browseDirection;
        private final NodeId referenceTypeId;
        private final boolean includeSubtypes;
        private final UInteger nodeClassMask;
        private final UInteger resultMask;
        private final UInteger maxReferencesPerNode;

        public BrowseOptions() {
            this(BrowseDirection.Forward, NodeIds.HierarchicalReferences, true, Unsigned.uint((int)255), Unsigned.uint((int)63), Unsigned.uint((int)0));
        }

        public BrowseOptions(BrowseDirection browseDirection, NodeId referenceTypeId, boolean includeSubtypes, UInteger nodeClassMask, UInteger resultMask, UInteger maxReferencesPerNode) {
            this.browseDirection = browseDirection;
            this.referenceTypeId = referenceTypeId;
            this.includeSubtypes = includeSubtypes;
            this.nodeClassMask = nodeClassMask;
            this.resultMask = resultMask;
            this.maxReferencesPerNode = maxReferencesPerNode;
        }

        public BrowseDirection getBrowseDirection() {
            return this.browseDirection;
        }

        public NodeId getReferenceTypeId() {
            return this.referenceTypeId;
        }

        public boolean isIncludeSubtypes() {
            return this.includeSubtypes;
        }

        public UInteger getNodeClassMask() {
            return this.nodeClassMask;
        }

        public UInteger getResultMask() {
            return this.resultMask;
        }

        public UInteger getMaxReferencesPerNode() {
            return this.maxReferencesPerNode;
        }

        public BrowseOptions copy(Consumer<Builder> builderConsumer) {
            Builder builder = new Builder(this);
            builderConsumer.accept(builder);
            return builder.build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private BrowseDirection browseDirection = BrowseDirection.Forward;
            private NodeId referenceTypeId = NodeIds.HierarchicalReferences;
            private boolean includeSubtypes = true;
            private UInteger nodeClassMask = Unsigned.uint((int)255);
            private UInteger resultMask = Unsigned.uint((int)63);
            private UInteger maxReferencesPerNode = Unsigned.uint((int)0);

            private Builder() {
            }

            private Builder(BrowseOptions browseOptions) {
                this.browseDirection = browseOptions.getBrowseDirection();
                this.referenceTypeId = browseOptions.getReferenceTypeId();
                this.includeSubtypes = browseOptions.isIncludeSubtypes();
                this.nodeClassMask = browseOptions.getNodeClassMask();
                this.resultMask = browseOptions.getResultMask();
                this.maxReferencesPerNode = browseOptions.getMaxReferencesPerNode();
            }

            public Builder setBrowseDirection(BrowseDirection browseDirection) {
                this.browseDirection = browseDirection;
                return this;
            }

            public Builder setReferenceType(NodeId referenceTypeId) {
                this.referenceTypeId = referenceTypeId;
                return this;
            }

            public Builder setIncludeSubtypes(boolean includeSubtypes) {
                this.includeSubtypes = includeSubtypes;
                return this;
            }

            public Builder setNodeClassMask(UInteger nodeClassMask) {
                this.nodeClassMask = nodeClassMask;
                return this;
            }

            public Builder setNodeClassMask(Set<NodeClass> nodeClasses) {
                int mask = 0;
                for (NodeClass nodeClass : nodeClasses) {
                    mask |= nodeClass.getValue();
                }
                return this.setNodeClassMask(Unsigned.uint((int)mask));
            }

            public Builder setResultMask(UInteger resultMask) {
                this.resultMask = resultMask;
                return this;
            }

            public Builder setResultMask(Set<BrowseResultMask> resultMasks) {
                int mask = 0;
                for (BrowseResultMask result : resultMasks) {
                    mask |= result.getValue();
                }
                return this.setResultMask(Unsigned.uint((int)mask));
            }

            public Builder setMaxReferencesPerNode(UInteger maxReferencesPerNode) {
                this.maxReferencesPerNode = maxReferencesPerNode;
                return this;
            }

            public BrowseOptions build() {
                return new BrowseOptions(this.browseDirection, this.referenceTypeId, this.includeSubtypes, this.nodeClassMask, this.resultMask, this.maxReferencesPerNode);
            }
        }
    }
}

