/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.typetree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.typetree.ClientVariableType;
import org.eclipse.milo.opcua.sdk.core.typetree.VariableType;
import org.eclipse.milo.opcua.sdk.core.typetree.VariableTypeTree;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.util.Lists;
import org.eclipse.milo.opcua.stack.core.util.Tree;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableTypeTreeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableTypeTreeBuilder.class);

    public static VariableTypeTree build(OpcUaClient client) throws UaException {
        Tree root = new Tree(null, (Object)new ClientVariableType(QualifiedName.parse((String)"0:BaseVariableType"), NodeIds.BaseVariableType, new DataValue(Variant.NULL_VALUE), NodeIds.BaseDataType, -1, null, true));
        NamespaceTable namespaceTable = client.readNamespaceTable();
        UInteger[] operationLimits = VariableTypeTreeBuilder.readOperationLimits(client);
        UInteger maxNodesPerBrowse = operationLimits[0];
        UInteger maxNodesPerRead = operationLimits[1];
        VariableTypeTreeBuilder.addChildren(List.of(root), client, namespaceTable, maxNodesPerBrowse, maxNodesPerRead);
        return new VariableTypeTree(root);
    }

    public static CompletableFuture<VariableTypeTree> buildAsync(OpcUaClient client) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return VariableTypeTreeBuilder.build(client);
            }
            catch (UaException e) {
                throw new CompletionException(e);
            }
        }, client.getTransport().getConfig().getExecutor());
    }

    private static void addChildren(List<Tree<VariableType>> parentTypes, OpcUaClient client, NamespaceTable namespaceTable, UInteger maxNodesPerBrowse, UInteger maxNodesPerRead) {
        List<List<ReferenceDescription>> parentSubtypes = VariableTypeTreeBuilder.browseWithOperationLimits(client, parentTypes.stream().map(tree -> new BrowseDescription(((VariableType)tree.getValue()).getNodeId(), BrowseDirection.Forward, NodeIds.HasSubtype, Boolean.valueOf(true), Unsigned.uint((int)NodeClass.VariableType.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue()))).collect(Collectors.toList()), maxNodesPerBrowse);
        ArrayList<Tree<VariableType>> childTypes = new ArrayList<Tree<VariableType>>();
        for (int i = 0; i < parentTypes.size(); ++i) {
            Tree<VariableType> tree2 = parentTypes.get(i);
            List<ReferenceDescription> subtypes = parentSubtypes.get(i);
            List<NodeId> variableTypeIds = subtypes.stream().map(reference -> reference.getNodeId().toNodeId(namespaceTable).orElse(NodeId.NULL_VALUE)).collect(Collectors.toList());
            List<Attributes> variableTypeAttributes = VariableTypeTreeBuilder.readVariableTypeAttributes(client, variableTypeIds, maxNodesPerRead);
            assert (subtypes.size() == variableTypeIds.size() && subtypes.size() == variableTypeAttributes.size());
            ArrayList<ClientVariableType> variableTypes = new ArrayList<ClientVariableType>();
            for (int j = 0; j < subtypes.size(); ++j) {
                QualifiedName browseName = subtypes.get(j).getBrowseName();
                NodeId variableTypeId = variableTypeIds.get(j);
                Attributes attributes = variableTypeAttributes.get(j);
                ClientVariableType variableType = new ClientVariableType(browseName, variableTypeId, attributes.value, attributes.dataType, attributes.valueRank, attributes.arrayDimensions, attributes.isAbstract);
                variableTypes.add(variableType);
                LOGGER.debug("Added VariableType: {}", (Object)variableType.getBrowseName().toParseableString());
            }
            for (ClientVariableType variableType : variableTypes) {
                Tree childNode = tree2.addChild((Object)variableType);
                childTypes.add((Tree<VariableType>)childNode);
            }
        }
        if (!childTypes.isEmpty()) {
            VariableTypeTreeBuilder.addChildren(childTypes, client, namespaceTable, maxNodesPerBrowse, maxNodesPerRead);
        }
    }

    private static List<Attributes> readVariableTypeAttributes(OpcUaClient client, List<NodeId> variableTypeIds, UInteger maxNodesPerRead) {
        if (variableTypeIds.isEmpty()) {
            return List.of();
        }
        ArrayList<ReadValueId> readValueIds = new ArrayList<ReadValueId>();
        for (NodeId variableTypeId : variableTypeIds) {
            readValueIds.add(new ReadValueId(variableTypeId, AttributeId.IsAbstract.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(variableTypeId, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(variableTypeId, AttributeId.DataType.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(variableTypeId, AttributeId.ValueRank.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(variableTypeId, AttributeId.ArrayDimensions.uid(), null, QualifiedName.NULL_VALUE));
        }
        ArrayList<Attributes> attributes = new ArrayList<Attributes>();
        List<DataValue> values = VariableTypeTreeBuilder.readWithOperationLimits(client, readValueIds, maxNodesPerRead);
        for (int i = 0; i < values.size(); i += 5) {
            DataValue isAbstractValue = values.get(i);
            DataValue valueValue = values.get(i + 1);
            DataValue dataTypeValue = values.get(i + 2);
            DataValue valueRankValue = values.get(i + 3);
            DataValue arrayDimensionsValue = values.get(i + 4);
            Boolean isAbstract = false;
            DataValue value = new DataValue(Variant.NULL_VALUE);
            NodeId dataType = NodeIds.BaseDataType;
            Integer valueRank = -1;
            UInteger[] arrayDimensions = null;
            if (isAbstractValue.statusCode().isGood()) {
                isAbstract = (Boolean)isAbstractValue.value().value();
            }
            if (valueValue.statusCode().isGood()) {
                value = valueValue;
            }
            if (dataTypeValue.statusCode().isGood()) {
                dataType = (NodeId)dataTypeValue.value().value();
            }
            if (valueRankValue.statusCode().isGood()) {
                valueRank = (Integer)valueRankValue.value().value();
            }
            if (arrayDimensionsValue.statusCode().isGood()) {
                arrayDimensions = (UInteger[])arrayDimensionsValue.value().value();
            }
            attributes.add(new Attributes(isAbstract, value, dataType, valueRank, arrayDimensions));
        }
        return attributes;
    }

    private static List<List<ReferenceDescription>> browse(OpcUaClient client, List<BrowseDescription> browseDescriptions) {
        if (browseDescriptions.isEmpty()) {
            return List.of();
        }
        ArrayList<List<ReferenceDescription>> referenceDescriptionLists = new ArrayList<List<ReferenceDescription>>();
        try {
            client.browse(browseDescriptions).forEach(result -> {
                if (result.getStatusCode().isGood()) {
                    ArrayList<ReferenceDescription> references = new ArrayList<ReferenceDescription>();
                    ReferenceDescription[] refs = Objects.requireNonNullElse(result.getReferences(), new ReferenceDescription[0]);
                    Collections.addAll(references, refs);
                    ByteString continuationPoint = result.getContinuationPoint();
                    List<ReferenceDescription> nextRefs = VariableTypeTreeBuilder.maybeBrowseNext(client, continuationPoint);
                    references.addAll(nextRefs);
                    referenceDescriptionLists.add(references);
                } else {
                    referenceDescriptionLists.add(List.of());
                }
            });
        }
        catch (UaException e) {
            referenceDescriptionLists.addAll(Collections.nCopies(browseDescriptions.size(), List.of()));
        }
        return referenceDescriptionLists;
    }

    private static List<ReferenceDescription> maybeBrowseNext(OpcUaClient client, ByteString continuationPoint) {
        ArrayList<ReferenceDescription> references = new ArrayList<ReferenceDescription>();
        while (continuationPoint != null && continuationPoint.isNotNull()) {
            try {
                BrowseNextResponse response = client.browseNext(false, List.of(continuationPoint));
                BrowseResult result = Objects.requireNonNull(response.getResults())[0];
                ReferenceDescription[] rds = Objects.requireNonNullElse(result.getReferences(), new ReferenceDescription[0]);
                references.addAll(List.of(rds));
                continuationPoint = result.getContinuationPoint();
            }
            catch (Exception e) {
                LOGGER.warn("BrowseNext failed: {}", (Object)e.getMessage(), (Object)e);
                return references;
            }
        }
        return references;
    }

    private static UInteger[] readOperationLimits(OpcUaClient client) throws UaException {
        DataValue maxNodesPerRead;
        UInteger[] operationLimits = new UInteger[]{Unsigned.uint((int)10), Unsigned.uint((int)100)};
        List<DataValue> dataValues = client.readValues(0.0, TimestampsToReturn.Neither, List.of(NodeIds.OperationLimitsType_MaxNodesPerBrowse, NodeIds.OperationLimitsType_MaxNodesPerRead));
        DataValue maxNodesPerBrowse = dataValues.get(0);
        if (maxNodesPerBrowse.statusCode().isGood() && maxNodesPerBrowse.value().value() instanceof UInteger) {
            operationLimits[0] = (UInteger)maxNodesPerBrowse.value().value();
        }
        if ((maxNodesPerRead = dataValues.get(1)).statusCode().isGood() && dataValues.get(1).value().value() instanceof UInteger) {
            operationLimits[1] = (UInteger)maxNodesPerRead.value().value();
        }
        return operationLimits;
    }

    private static List<DataValue> readWithOperationLimits(OpcUaClient client, List<ReadValueId> readValueIds, UInteger maxNodesPerRead) {
        int partitionSize;
        if (readValueIds.isEmpty()) {
            return List.of();
        }
        LOGGER.debug("readWithOperationLimits: {}", (Object)readValueIds.size());
        int n = partitionSize = maxNodesPerRead.longValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : maxNodesPerRead.intValue();
        if (partitionSize == 0) {
            partitionSize = Integer.MAX_VALUE;
        }
        ArrayList<DataValue> values = new ArrayList<DataValue>();
        Lists.partition(readValueIds, (int)partitionSize).forEach(partition -> {
            try {
                ReadResponse response = client.read(0.0, TimestampsToReturn.Neither, (List<ReadValueId>)partition);
                DataValue[] results = response.getResults();
                Collections.addAll(values, Objects.requireNonNull(results));
            }
            catch (UaException e) {
                DataValue value = new DataValue(e.getStatusCode());
                values.addAll(Collections.nCopies(partition.size(), value));
            }
        });
        return values;
    }

    private static List<List<ReferenceDescription>> browseWithOperationLimits(OpcUaClient client, List<BrowseDescription> browseDescriptions, UInteger maxNodesPerBrowse) {
        int partitionSize;
        if (browseDescriptions.isEmpty()) {
            return List.of();
        }
        LOGGER.debug("browseWithOperationLimits: {}", (Object)browseDescriptions.size());
        int n = partitionSize = maxNodesPerBrowse.longValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : maxNodesPerBrowse.intValue();
        if (partitionSize == 0) {
            partitionSize = Integer.MAX_VALUE;
        }
        ArrayList<List<ReferenceDescription>> references = new ArrayList<List<ReferenceDescription>>();
        Lists.partition(browseDescriptions, (int)partitionSize).forEach(partition -> references.addAll(VariableTypeTreeBuilder.browse(client, partition)));
        return references;
    }

    private static class Attributes {
        final Boolean isAbstract;
        final DataValue value;
        final NodeId dataType;
        final Integer valueRank;
        final @Nullable UInteger[] arrayDimensions;

        private Attributes(Boolean isAbstract, DataValue value, NodeId dataType, Integer valueRank, @Nullable UInteger[] arrayDimensions) {
            this.isAbstract = isAbstract;
            this.value = value;
            this.dataType = dataType;
            this.valueRank = valueRank;
            this.arrayDimensions = arrayDimensions;
        }
    }
}

