/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.typetree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.typetree.ClientObjectType;
import org.eclipse.milo.opcua.sdk.core.typetree.ObjectType;
import org.eclipse.milo.opcua.sdk.core.typetree.ObjectTypeTree;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.util.Lists;
import org.eclipse.milo.opcua.stack.core.util.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTypeTreeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectTypeTreeBuilder.class);

    public static ObjectTypeTree build(OpcUaClient client) throws UaException {
        Tree root = new Tree(null, (Object)new ClientObjectType(QualifiedName.parse((String)"0:BaseObjectType"), NodeIds.BaseObjectType, false));
        NamespaceTable namespaceTable = client.readNamespaceTable();
        UInteger[] operationLimits = ObjectTypeTreeBuilder.readOperationLimits(client);
        UInteger maxNodesPerBrowse = operationLimits[0];
        UInteger maxNodesPerRead = operationLimits[1];
        ObjectTypeTreeBuilder.addChildren(List.of(root), client, namespaceTable, maxNodesPerBrowse, maxNodesPerRead);
        return new ObjectTypeTree(root);
    }

    public static CompletableFuture<ObjectTypeTree> buildAsync(OpcUaClient client) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return ObjectTypeTreeBuilder.build(client);
            }
            catch (UaException e) {
                throw new CompletionException(e);
            }
        }, client.getTransport().getConfig().getExecutor());
    }

    private static void addChildren(List<Tree<ObjectType>> parentTypes, OpcUaClient client, NamespaceTable namespaceTable, UInteger maxNodesPerBrowse, UInteger maxNodesPerRead) {
        List<List<ReferenceDescription>> parentSubtypes = ObjectTypeTreeBuilder.browseWithOperationLimits(client, parentTypes.stream().map(tree -> new BrowseDescription(((ObjectType)tree.getValue()).getNodeId(), BrowseDirection.Forward, NodeIds.HasSubtype, Boolean.valueOf(true), Unsigned.uint((int)NodeClass.ObjectType.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue()))).collect(Collectors.toList()), maxNodesPerBrowse);
        ArrayList<Tree<ObjectType>> childTypes = new ArrayList<Tree<ObjectType>>();
        for (int i = 0; i < parentTypes.size(); ++i) {
            Tree<ObjectType> tree2 = parentTypes.get(i);
            List<ReferenceDescription> subtypes = parentSubtypes.get(i);
            List<NodeId> objectTypeIds = subtypes.stream().map(reference -> reference.getNodeId().toNodeId(namespaceTable).orElse(NodeId.NULL_VALUE)).collect(Collectors.toList());
            List<Boolean> isAbstractValues = ObjectTypeTreeBuilder.readIsAbstractAttributes(client, objectTypeIds, maxNodesPerRead);
            assert (subtypes.size() == objectTypeIds.size() && subtypes.size() == isAbstractValues.size());
            ArrayList<ClientObjectType> objectTypes = new ArrayList<ClientObjectType>();
            for (int j = 0; j < subtypes.size(); ++j) {
                QualifiedName browseName = subtypes.get(j).getBrowseName();
                NodeId objectTypeId = objectTypeIds.get(j);
                Boolean isAbstract = isAbstractValues.get(j);
                ClientObjectType objectType = new ClientObjectType(browseName, objectTypeId, isAbstract);
                objectTypes.add(objectType);
                LOGGER.debug("Added ObjectType: {}", (Object)objectType.getBrowseName().toParseableString());
            }
            for (ClientObjectType objectType : objectTypes) {
                Tree childNode = tree2.addChild((Object)objectType);
                childTypes.add((Tree<ObjectType>)childNode);
            }
        }
        if (!childTypes.isEmpty()) {
            ObjectTypeTreeBuilder.addChildren(childTypes, client, namespaceTable, maxNodesPerBrowse, maxNodesPerRead);
        }
    }

    private static List<Boolean> readIsAbstractAttributes(OpcUaClient client, List<NodeId> objectTypeIds, UInteger maxNodesPerRead) {
        if (objectTypeIds.isEmpty()) {
            return List.of();
        }
        ArrayList<ReadValueId> readValueIds = new ArrayList<ReadValueId>();
        for (NodeId objectTypeId : objectTypeIds) {
            readValueIds.add(new ReadValueId(objectTypeId, AttributeId.IsAbstract.uid(), null, QualifiedName.NULL_VALUE));
        }
        ArrayList<Boolean> isAbstractValues = new ArrayList<Boolean>();
        List<DataValue> values = ObjectTypeTreeBuilder.readWithOperationLimits(client, readValueIds, maxNodesPerRead);
        for (DataValue value : values) {
            Boolean isAbstract = false;
            if (value.statusCode().isGood()) {
                isAbstract = (Boolean)value.value().value();
            }
            isAbstractValues.add(isAbstract);
        }
        return isAbstractValues;
    }

    private static List<List<ReferenceDescription>> browse(OpcUaClient client, List<BrowseDescription> browseDescriptions) {
        if (browseDescriptions.isEmpty()) {
            return List.of();
        }
        ArrayList<List<ReferenceDescription>> referenceDescriptionLists = new ArrayList<List<ReferenceDescription>>();
        try {
            client.browse(browseDescriptions).forEach(result -> {
                if (result.getStatusCode().isGood()) {
                    ArrayList<ReferenceDescription> references = new ArrayList<ReferenceDescription>();
                    ReferenceDescription[] refs = Objects.requireNonNullElse(result.getReferences(), new ReferenceDescription[0]);
                    Collections.addAll(references, refs);
                    ByteString continuationPoint = result.getContinuationPoint();
                    List<ReferenceDescription> nextRefs = ObjectTypeTreeBuilder.maybeBrowseNext(client, continuationPoint);
                    references.addAll(nextRefs);
                    referenceDescriptionLists.add(references);
                } else {
                    referenceDescriptionLists.add(List.of());
                }
            });
        }
        catch (UaException e) {
            referenceDescriptionLists.addAll(Collections.nCopies(browseDescriptions.size(), List.of()));
        }
        return referenceDescriptionLists;
    }

    private static List<ReferenceDescription> maybeBrowseNext(OpcUaClient client, ByteString continuationPoint) {
        ArrayList<ReferenceDescription> references = new ArrayList<ReferenceDescription>();
        while (continuationPoint != null && continuationPoint.isNotNull()) {
            try {
                BrowseNextResponse response = client.browseNext(false, List.of(continuationPoint));
                BrowseResult result = Objects.requireNonNull(response.getResults())[0];
                ReferenceDescription[] rds = Objects.requireNonNullElse(result.getReferences(), new ReferenceDescription[0]);
                references.addAll(List.of(rds));
                continuationPoint = result.getContinuationPoint();
            }
            catch (Exception e) {
                LOGGER.warn("BrowseNext failed: {}", (Object)e.getMessage(), (Object)e);
                return references;
            }
        }
        return references;
    }

    private static UInteger[] readOperationLimits(OpcUaClient client) throws UaException {
        DataValue maxNodesPerRead;
        UInteger[] operationLimits = new UInteger[]{Unsigned.uint((int)10), Unsigned.uint((int)100)};
        List<DataValue> dataValues = client.readValues(0.0, TimestampsToReturn.Neither, List.of(NodeIds.OperationLimitsType_MaxNodesPerBrowse, NodeIds.OperationLimitsType_MaxNodesPerRead));
        DataValue maxNodesPerBrowse = dataValues.get(0);
        if (maxNodesPerBrowse.statusCode().isGood() && maxNodesPerBrowse.value().value() instanceof UInteger) {
            operationLimits[0] = (UInteger)maxNodesPerBrowse.value().value();
        }
        if ((maxNodesPerRead = dataValues.get(1)).statusCode().isGood() && dataValues.get(1).value().value() instanceof UInteger) {
            operationLimits[1] = (UInteger)maxNodesPerRead.value().value();
        }
        return operationLimits;
    }

    private static List<DataValue> readWithOperationLimits(OpcUaClient client, List<ReadValueId> readValueIds, UInteger maxNodesPerRead) {
        int partitionSize;
        if (readValueIds.isEmpty()) {
            return List.of();
        }
        LOGGER.debug("readWithOperationLimits: {}", (Object)readValueIds.size());
        int n = partitionSize = maxNodesPerRead.longValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : maxNodesPerRead.intValue();
        if (partitionSize == 0) {
            partitionSize = Integer.MAX_VALUE;
        }
        ArrayList<DataValue> values = new ArrayList<DataValue>();
        Lists.partition(readValueIds, (int)partitionSize).forEach(partition -> {
            try {
                ReadResponse response = client.read(0.0, TimestampsToReturn.Neither, (List<ReadValueId>)partition);
                DataValue[] results = response.getResults();
                Collections.addAll(values, Objects.requireNonNull(results));
            }
            catch (UaException e) {
                DataValue value = new DataValue(e.getStatusCode());
                values.addAll(Collections.nCopies(partition.size(), value));
            }
        });
        return values;
    }

    private static List<List<ReferenceDescription>> browseWithOperationLimits(OpcUaClient client, List<BrowseDescription> browseDescriptions, UInteger maxNodesPerBrowse) {
        int partitionSize;
        if (browseDescriptions.isEmpty()) {
            return List.of();
        }
        LOGGER.debug("browseWithOperationLimits: {}", (Object)browseDescriptions.size());
        int n = partitionSize = maxNodesPerBrowse.longValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : maxNodesPerBrowse.intValue();
        if (partitionSize == 0) {
            partitionSize = Integer.MAX_VALUE;
        }
        ArrayList<List<ReferenceDescription>> references = new ArrayList<List<ReferenceDescription>>();
        Lists.partition(browseDescriptions, (int)partitionSize).forEach(partition -> references.addAll(ObjectTypeTreeBuilder.browse(client, partition)));
        return references;
    }
}

