/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.typetree;

import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.milo.opcua.sdk.core.typetree.VariableType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

class ClientVariableType
implements VariableType {
    private final QualifiedName browseName;
    private final NodeId nodeId;
    private final DataValue value;
    private final NodeId dataType;
    private final Integer valueRank;
    private final UInteger[] arrayDimensions;
    private final Boolean isAbstract;

    public ClientVariableType(QualifiedName browseName, NodeId nodeId, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, Boolean isAbstract) {
        this.browseName = browseName;
        this.nodeId = nodeId;
        this.value = value;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.isAbstract = isAbstract;
    }

    public QualifiedName getBrowseName() {
        return this.browseName;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public DataValue getValue() {
        return this.value;
    }

    public NodeId getDataType() {
        return this.dataType;
    }

    public Integer getValueRank() {
        return this.valueRank;
    }

    public UInteger[] getArrayDimensions() {
        return this.arrayDimensions;
    }

    public Boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientVariableType that = (ClientVariableType)o;
        return this.browseName.equals((Object)that.browseName) && this.nodeId.equals((Object)that.nodeId) && Objects.equals(this.value, that.value) && Objects.equals(this.dataType, that.dataType) && Objects.equals(this.valueRank, that.valueRank) && Arrays.equals(this.arrayDimensions, that.arrayDimensions) && Objects.equals(this.isAbstract, that.isAbstract);
    }

    public int hashCode() {
        int result = Objects.hash(this.browseName, this.nodeId, this.value, this.dataType, this.valueRank, this.isAbstract);
        result = 31 * result + Arrays.hashCode(this.arrayDimensions);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", ClientVariableType.class.getSimpleName() + "{", "}").add("browseName=" + String.valueOf(this.browseName)).add("nodeId=" + String.valueOf(this.nodeId)).add("value=" + String.valueOf(this.value)).add("dataType=" + String.valueOf(this.dataType)).add("valueRank=" + this.valueRank).add("arrayDimensions=" + Arrays.toString(this.arrayDimensions)).add("isAbstract=" + this.isAbstract).toString();
    }
}

