/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;

public class EventFilterBuilder {
    private final List<SimpleAttributeOperand> selectClauses = new ArrayList<SimpleAttributeOperand>();
    private ContentFilter whereClause = new ContentFilter(null);

    public EventFilterBuilder select(NodeId typeDefinitionId, QualifiedName browseName) {
        SimpleAttributeOperand operand = new SimpleAttributeOperand(typeDefinitionId, new QualifiedName[]{browseName}, AttributeId.Value.uid(), null);
        return this.select(operand);
    }

    public EventFilterBuilder select(NodeId typeDefinitionId, QualifiedName ... browseNames) {
        SimpleAttributeOperand operand = new SimpleAttributeOperand(typeDefinitionId, browseNames, AttributeId.Value.uid(), null);
        return this.select(operand);
    }

    public EventFilterBuilder select(NodeId typeDefinitionId, List<QualifiedName> browseNames) {
        SimpleAttributeOperand operand = new SimpleAttributeOperand(typeDefinitionId, browseNames.toArray(new QualifiedName[0]), AttributeId.Value.uid(), null);
        return this.select(operand);
    }

    public EventFilterBuilder select(SimpleAttributeOperand selectClause) {
        this.selectClauses.add(selectClause);
        return this;
    }

    public EventFilterBuilder where(ContentFilter whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public EventFilter build() {
        return new EventFilter(this.selectClauses.toArray(new SimpleAttributeOperand[0]), this.whereClause);
    }
}

