/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.core.nodes.ReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.core.nodes.ReferenceTypeNodeProperties;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class UaReferenceTypeNode
extends UaNode
implements ReferenceTypeNode {
    private Boolean isAbstract;
    private Boolean symmetric;
    private LocalizedText inverseName;

    public UaReferenceTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean isAbstract, Boolean symmetric, LocalizedText inverseName) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
        this.symmetric = symmetric;
        this.inverseName = inverseName;
    }

    public UaReferenceTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, Boolean isAbstract, Boolean symmetric, LocalizedText inverseName) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions);
        this.isAbstract = isAbstract;
        this.symmetric = symmetric;
        this.inverseName = inverseName;
    }

    public synchronized Boolean getIsAbstract() {
        return this.isAbstract;
    }

    public synchronized Boolean getSymmetric() {
        return this.symmetric;
    }

    public synchronized LocalizedText getInverseName() {
        return this.inverseName;
    }

    public synchronized void setIsAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public synchronized void setSymmetric(Boolean symmetric) {
        this.symmetric = symmetric;
    }

    public synchronized void setInverseName(LocalizedText inverseName) {
        this.inverseName = inverseName;
    }

    public Boolean readIsAbstract() throws UaException {
        DataValue value = this.readAttribute(AttributeId.IsAbstract);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read IsAbstract failed");
        }
        Boolean isAbstract = (Boolean)value.value().value();
        this.setIsAbstract(isAbstract);
        return isAbstract;
    }

    public Boolean readSymmetric() throws UaException {
        DataValue value = this.readAttribute(AttributeId.Symmetric);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read Symmetric failed");
        }
        Boolean symmetric = (Boolean)value.value().value();
        this.setSymmetric(symmetric);
        return symmetric;
    }

    public LocalizedText readInverseName() throws UaException {
        DataValue value = this.readAttribute(AttributeId.InverseName);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read InverseName failed");
        }
        LocalizedText inverseName = (LocalizedText)value.value().value();
        this.setInverseName(inverseName);
        return inverseName;
    }

    public void writeIsAbstract(Boolean isAbstract) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)isAbstract));
        StatusCode statusCode = this.writeAttribute(AttributeId.IsAbstract, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write IsAbstract failed");
        }
        this.setIsAbstract(isAbstract);
    }

    public void writeSymmetric(Boolean symmetric) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)symmetric));
        StatusCode statusCode = this.writeAttribute(AttributeId.Symmetric, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write Symmetric failed");
        }
        this.setSymmetric(symmetric);
    }

    public void writeInverseName(LocalizedText inverseName) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)inverseName));
        StatusCode statusCode = this.writeAttribute(AttributeId.InverseName, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write InverseName failed");
        }
        this.setInverseName(inverseName);
    }

    public CompletableFuture<? extends String> readNodeVersionAsync() {
        return this.getProperty(ReferenceTypeNodeProperties.NodeVersion);
    }

    public CompletableFuture<StatusCode> writeNodeVersionAsync(String nodeVersion) {
        return this.setProperty(ReferenceTypeNodeProperties.NodeVersion, nodeVersion);
    }

    @Override
    protected DataValue getAttributeValue(AttributeId attributeId) {
        return switch (attributeId) {
            case AttributeId.IsAbstract -> DataValue.valueOnly((Variant)new Variant((Object)this.getIsAbstract()));
            case AttributeId.Symmetric -> DataValue.valueOnly((Variant)new Variant((Object)this.getSymmetric()));
            case AttributeId.InverseName -> DataValue.valueOnly((Variant)new Variant((Object)this.getInverseName()));
            default -> super.getAttributeValue(attributeId);
        };
    }

    @Override
    protected void setAttributeValue(AttributeId attributeId, DataValue value) {
        switch (attributeId) {
            case IsAbstract: {
                this.setIsAbstract((Boolean)value.value().value());
                break;
            }
            case Symmetric: {
                this.setSymmetric((Boolean)value.value().value());
                break;
            }
            case InverseName: {
                this.setInverseName((LocalizedText)value.value().value());
                break;
            }
            default: {
                super.setAttributeValue(attributeId, value);
            }
        }
    }
}

