/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.core.nodes.DataTypeNode;
import org.eclipse.milo.opcua.sdk.core.nodes.DataTypeNodeProperties;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumValueType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.jspecify.annotations.Nullable;

public class UaDataTypeNode
extends UaNode
implements DataTypeNode {
    private Boolean isAbstract;
    private DataTypeDefinition dataTypeDefinition;

    public UaDataTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean isAbstract) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
    }

    public UaDataTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, Boolean isAbstract, DataTypeDefinition dataTypeDefinition) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions);
        this.isAbstract = isAbstract;
        this.dataTypeDefinition = dataTypeDefinition;
    }

    public synchronized Boolean getIsAbstract() {
        return this.isAbstract;
    }

    public synchronized @Nullable DataTypeDefinition getDataTypeDefinition() {
        return this.dataTypeDefinition;
    }

    public synchronized void setIsAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public synchronized void setDataTypeDefinition(DataTypeDefinition dataTypeDefinition) {
        this.dataTypeDefinition = dataTypeDefinition;
    }

    public Boolean readIsAbstract() throws UaException {
        DataValue value = this.readAttribute(AttributeId.IsAbstract);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read IsAbstract failed");
        }
        Boolean isAbstract = (Boolean)value.value().value();
        this.setIsAbstract(isAbstract);
        return isAbstract;
    }

    public @Nullable DataTypeDefinition readDataTypeDefinition() throws UaException {
        DataValue value = this.readAttribute(AttributeId.DataTypeDefinition);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read DataTypeDefinition failed");
        }
        ExtensionObject xo = (ExtensionObject)value.value().value();
        if (xo == null || xo.isNull()) {
            this.setDataTypeDefinition(null);
        } else {
            DataTypeDefinition dataTypeDefinition = (DataTypeDefinition)xo.decode(this.client.getStaticEncodingContext());
            this.setDataTypeDefinition(dataTypeDefinition);
        }
        return this.dataTypeDefinition;
    }

    public void writeIsAbstract(Boolean isAbstract) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)isAbstract));
        StatusCode statusCode = this.writeAttribute(AttributeId.IsAbstract, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write IsAbstract failed");
        }
        this.setIsAbstract(isAbstract);
    }

    public void writeDataTypeDefinition(DataTypeDefinition dataTypeDefinition) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataTypeDefinition));
        StatusCode statusCode = this.writeAttribute(AttributeId.DataTypeDefinition, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write DataTypeDefinition failed");
        }
        this.setDataTypeDefinition(dataTypeDefinition);
    }

    public CompletableFuture<? extends String> readNodeVersionAsync() {
        return this.getProperty(DataTypeNodeProperties.NodeVersion);
    }

    public CompletableFuture<? extends LocalizedText[]> readEnumStringsAsync() {
        return this.getProperty(DataTypeNodeProperties.EnumStrings);
    }

    public CompletableFuture<? extends EnumValueType[]> readEnumValuesAsync() {
        return this.getProperty(DataTypeNodeProperties.EnumValues);
    }

    public CompletableFuture<? extends LocalizedText[]> readOptionSetValuesAsync() {
        return this.getProperty(DataTypeNodeProperties.OptionSetValues);
    }

    public CompletableFuture<StatusCode> writeNodeVersionAsync(String nodeVersion) {
        return this.setProperty(DataTypeNodeProperties.NodeVersion, nodeVersion);
    }

    public CompletableFuture<StatusCode> writeEnumStringsAsync(LocalizedText[] enumStrings) {
        return this.setProperty(DataTypeNodeProperties.EnumStrings, enumStrings);
    }

    public CompletableFuture<StatusCode> writeEnumValuesAsync(EnumValueType[] enumValues) {
        return this.setProperty(DataTypeNodeProperties.EnumValues, enumValues);
    }

    public CompletableFuture<StatusCode> writeOptionSetValuesAsync(LocalizedText[] optionSetValues) {
        return this.setProperty(DataTypeNodeProperties.OptionSetValues, optionSetValues);
    }

    @Override
    protected DataValue getAttributeValue(AttributeId attributeId) {
        return switch (attributeId) {
            case AttributeId.IsAbstract -> DataValue.valueOnly((Variant)new Variant((Object)this.getIsAbstract()));
            case AttributeId.DataType -> DataValue.valueOnly((Variant)new Variant((Object)this.getDataTypeDefinition()));
            default -> super.getAttributeValue(attributeId);
        };
    }

    @Override
    protected void setAttributeValue(AttributeId attributeId, DataValue value) {
        switch (attributeId) {
            case IsAbstract: {
                this.setIsAbstract((Boolean)value.value().value());
                break;
            }
            case DataTypeDefinition: {
                ExtensionObject xo = (ExtensionObject)value.value().value();
                this.setDataTypeDefinition((DataTypeDefinition)xo.decode(this.client.getStaticEncodingContext()));
                break;
            }
            default: {
                super.setAttributeValue(attributeId, value);
            }
        }
    }
}

