/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.TransitionVariableType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class TransitionVariableTypeNode
extends BaseDataVariableTypeNode
implements TransitionVariableType {
    public TransitionVariableTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public Object getId() throws UaException {
        PropertyTypeNode node = this.getIdNode();
        return node.getValue().getValue().getValue();
    }

    @Override
    public void setId(Object value) throws UaException {
        PropertyTypeNode node = this.getIdNode();
        node.setValue(new Variant(value));
    }

    @Override
    public Object readId() throws UaException {
        try {
            return this.readIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeId(Object value) throws UaException {
        try {
            this.writeIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<?> readIdAsync() {
        return ((CompletableFuture)this.getIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeIdAsync(Object id) {
        DataValue value = DataValue.valueOnly((Variant)new Variant(id));
        return this.getIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getIdNode() throws UaException {
        try {
            return this.getIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Id", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public QualifiedName getName() throws UaException {
        PropertyTypeNode node = this.getNameNode();
        return (QualifiedName)node.getValue().getValue().getValue();
    }

    @Override
    public void setName(QualifiedName value) throws UaException {
        PropertyTypeNode node = this.getNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public QualifiedName readName() throws UaException {
        try {
            return this.readNameAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeName(QualifiedName value) throws UaException {
        try {
            this.writeNameAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends QualifiedName> readNameAsync() {
        return ((CompletableFuture)this.getNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (QualifiedName)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNameAsync(QualifiedName name) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)name));
        return this.getNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNameNode() throws UaException {
        try {
            return this.getNameNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Name", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getNumber() throws UaException {
        PropertyTypeNode node = this.getNumberNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setNumber(UInteger value) throws UaException {
        PropertyTypeNode node = this.getNumberNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readNumber() throws UaException {
        try {
            return this.readNumberAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeNumber(UInteger value) throws UaException {
        try {
            this.writeNumberAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readNumberAsync() {
        return ((CompletableFuture)this.getNumberNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNumberAsync(UInteger number) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)number));
        return this.getNumberNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNumberNode() throws UaException {
        try {
            return this.getNumberNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNumberNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Number", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getTransitionTime() throws UaException {
        PropertyTypeNode node = this.getTransitionTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setTransitionTime(DateTime value) throws UaException {
        PropertyTypeNode node = this.getTransitionTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readTransitionTime() throws UaException {
        try {
            return this.readTransitionTimeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeTransitionTime(DateTime value) throws UaException {
        try {
            this.writeTransitionTimeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readTransitionTimeAsync() {
        return ((CompletableFuture)this.getTransitionTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTransitionTimeAsync(DateTime transitionTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)transitionTime));
        return this.getTransitionTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getTransitionTimeNode() throws UaException {
        try {
            return this.getTransitionTimeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getTransitionTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransitionTime", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getEffectiveTransitionTime() throws UaException {
        PropertyTypeNode node = this.getEffectiveTransitionTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setEffectiveTransitionTime(DateTime value) throws UaException {
        PropertyTypeNode node = this.getEffectiveTransitionTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readEffectiveTransitionTime() throws UaException {
        try {
            return this.readEffectiveTransitionTimeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeEffectiveTransitionTime(DateTime value) throws UaException {
        try {
            this.writeEffectiveTransitionTimeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readEffectiveTransitionTimeAsync() {
        return ((CompletableFuture)this.getEffectiveTransitionTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEffectiveTransitionTimeAsync(DateTime effectiveTransitionTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)effectiveTransitionTime));
        return this.getEffectiveTransitionTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEffectiveTransitionTimeNode() throws UaException {
        try {
            return this.getEffectiveTransitionTimeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEffectiveTransitionTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EffectiveTransitionTime", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

