/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.SelectionListType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class SelectionListTypeNode
extends BaseDataVariableTypeNode
implements SelectionListType {
    public SelectionListTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public Object[] getSelections() throws UaException {
        PropertyTypeNode node = this.getSelectionsNode();
        return (Object[])node.getValue().getValue().getValue();
    }

    @Override
    public void setSelections(Object[] value) throws UaException {
        PropertyTypeNode node = this.getSelectionsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Object[] readSelections() throws UaException {
        try {
            return this.readSelectionsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSelections(Object[] value) throws UaException {
        try {
            this.writeSelectionsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Object[]> readSelectionsAsync() {
        return ((CompletableFuture)this.getSelectionsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Object[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSelectionsAsync(Object[] selections) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)selections));
        return this.getSelectionsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSelectionsNode() throws UaException {
        try {
            return this.getSelectionsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSelectionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Selections", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText[] getSelectionDescriptions() throws UaException {
        PropertyTypeNode node = this.getSelectionDescriptionsNode();
        return (LocalizedText[])node.getValue().getValue().getValue();
    }

    @Override
    public void setSelectionDescriptions(LocalizedText[] value) throws UaException {
        PropertyTypeNode node = this.getSelectionDescriptionsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText[] readSelectionDescriptions() throws UaException {
        try {
            return this.readSelectionDescriptionsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSelectionDescriptions(LocalizedText[] value) throws UaException {
        try {
            this.writeSelectionDescriptionsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText[]> readSelectionDescriptionsAsync() {
        return ((CompletableFuture)this.getSelectionDescriptionsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSelectionDescriptionsAsync(LocalizedText[] selectionDescriptions) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)selectionDescriptions));
        return this.getSelectionDescriptionsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSelectionDescriptionsNode() throws UaException {
        try {
            return this.getSelectionDescriptionsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSelectionDescriptionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SelectionDescriptions", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getRestrictToList() throws UaException {
        PropertyTypeNode node = this.getRestrictToListNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setRestrictToList(Boolean value) throws UaException {
        PropertyTypeNode node = this.getRestrictToListNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readRestrictToList() throws UaException {
        try {
            return this.readRestrictToListAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeRestrictToList(Boolean value) throws UaException {
        try {
            this.writeRestrictToListAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readRestrictToListAsync() {
        return ((CompletableFuture)this.getRestrictToListNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRestrictToListAsync(Boolean restrictToList) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)restrictToList));
        return this.getRestrictToListNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getRestrictToListNode() throws UaException {
        try {
            return this.getRestrictToListNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getRestrictToListNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RestrictToList", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

