/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.SamplingIntervalDiagnosticsType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class SamplingIntervalDiagnosticsTypeNode
extends BaseDataVariableTypeNode
implements SamplingIntervalDiagnosticsType {
    public SamplingIntervalDiagnosticsTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public Double getSamplingInterval() throws UaException {
        BaseDataVariableTypeNode node = this.getSamplingIntervalNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setSamplingInterval(Double value) throws UaException {
        BaseDataVariableTypeNode node = this.getSamplingIntervalNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readSamplingInterval() throws UaException {
        try {
            return this.readSamplingIntervalAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSamplingInterval(Double value) throws UaException {
        try {
            this.writeSamplingIntervalAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readSamplingIntervalAsync() {
        return ((CompletableFuture)this.getSamplingIntervalNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSamplingIntervalAsync(Double samplingInterval) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)samplingInterval));
        return this.getSamplingIntervalNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSamplingIntervalNode() throws UaException {
        try {
            return this.getSamplingIntervalNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSamplingIntervalNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SamplingInterval", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getSampledMonitoredItemsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getSampledMonitoredItemsCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setSampledMonitoredItemsCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getSampledMonitoredItemsCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readSampledMonitoredItemsCount() throws UaException {
        try {
            return this.readSampledMonitoredItemsCountAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSampledMonitoredItemsCount(UInteger value) throws UaException {
        try {
            this.writeSampledMonitoredItemsCountAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readSampledMonitoredItemsCountAsync() {
        return ((CompletableFuture)this.getSampledMonitoredItemsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSampledMonitoredItemsCountAsync(UInteger sampledMonitoredItemsCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sampledMonitoredItemsCount));
        return this.getSampledMonitoredItemsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSampledMonitoredItemsCountNode() throws UaException {
        try {
            return this.getSampledMonitoredItemsCountNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSampledMonitoredItemsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SampledMonitoredItemsCount", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getMaxSampledMonitoredItemsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getMaxSampledMonitoredItemsCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxSampledMonitoredItemsCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getMaxSampledMonitoredItemsCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxSampledMonitoredItemsCount() throws UaException {
        try {
            return this.readMaxSampledMonitoredItemsCountAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxSampledMonitoredItemsCount(UInteger value) throws UaException {
        try {
            this.writeMaxSampledMonitoredItemsCountAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxSampledMonitoredItemsCountAsync() {
        return ((CompletableFuture)this.getMaxSampledMonitoredItemsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxSampledMonitoredItemsCountAsync(UInteger maxSampledMonitoredItemsCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxSampledMonitoredItemsCount));
        return this.getMaxSampledMonitoredItemsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMaxSampledMonitoredItemsCountNode() throws UaException {
        try {
            return this.getMaxSampledMonitoredItemsCountNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMaxSampledMonitoredItemsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxSampledMonitoredItemsCount", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getDisabledMonitoredItemsSamplingCount() throws UaException {
        BaseDataVariableTypeNode node = this.getDisabledMonitoredItemsSamplingCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setDisabledMonitoredItemsSamplingCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getDisabledMonitoredItemsSamplingCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readDisabledMonitoredItemsSamplingCount() throws UaException {
        try {
            return this.readDisabledMonitoredItemsSamplingCountAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDisabledMonitoredItemsSamplingCount(UInteger value) throws UaException {
        try {
            this.writeDisabledMonitoredItemsSamplingCountAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readDisabledMonitoredItemsSamplingCountAsync() {
        return ((CompletableFuture)this.getDisabledMonitoredItemsSamplingCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDisabledMonitoredItemsSamplingCountAsync(UInteger disabledMonitoredItemsSamplingCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)disabledMonitoredItemsSamplingCount));
        return this.getDisabledMonitoredItemsSamplingCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDisabledMonitoredItemsSamplingCountNode() throws UaException {
        try {
            return this.getDisabledMonitoredItemsSamplingCountNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDisabledMonitoredItemsSamplingCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DisabledMonitoredItemsSamplingCount", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

