/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.BuildInfoType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class BuildInfoTypeNode
extends BaseDataVariableTypeNode
implements BuildInfoType {
    public BuildInfoTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public String getProductUri() throws UaException {
        BaseDataVariableTypeNode node = this.getProductUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setProductUri(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getProductUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readProductUri() throws UaException {
        try {
            return this.readProductUriAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeProductUri(String value) throws UaException {
        try {
            this.writeProductUriAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readProductUriAsync() {
        return ((CompletableFuture)this.getProductUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeProductUriAsync(String productUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)productUri));
        return this.getProductUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getProductUriNode() throws UaException {
        try {
            return this.getProductUriNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getProductUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ProductUri", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getManufacturerName() throws UaException {
        BaseDataVariableTypeNode node = this.getManufacturerNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setManufacturerName(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getManufacturerNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readManufacturerName() throws UaException {
        try {
            return this.readManufacturerNameAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeManufacturerName(String value) throws UaException {
        try {
            this.writeManufacturerNameAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readManufacturerNameAsync() {
        return ((CompletableFuture)this.getManufacturerNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeManufacturerNameAsync(String manufacturerName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)manufacturerName));
        return this.getManufacturerNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getManufacturerNameNode() throws UaException {
        try {
            return this.getManufacturerNameNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getManufacturerNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ManufacturerName", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getProductName() throws UaException {
        BaseDataVariableTypeNode node = this.getProductNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setProductName(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getProductNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readProductName() throws UaException {
        try {
            return this.readProductNameAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeProductName(String value) throws UaException {
        try {
            this.writeProductNameAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readProductNameAsync() {
        return ((CompletableFuture)this.getProductNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeProductNameAsync(String productName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)productName));
        return this.getProductNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getProductNameNode() throws UaException {
        try {
            return this.getProductNameNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getProductNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ProductName", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getSoftwareVersion() throws UaException {
        BaseDataVariableTypeNode node = this.getSoftwareVersionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSoftwareVersion(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getSoftwareVersionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readSoftwareVersion() throws UaException {
        try {
            return this.readSoftwareVersionAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSoftwareVersion(String value) throws UaException {
        try {
            this.writeSoftwareVersionAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readSoftwareVersionAsync() {
        return ((CompletableFuture)this.getSoftwareVersionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSoftwareVersionAsync(String softwareVersion) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)softwareVersion));
        return this.getSoftwareVersionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSoftwareVersionNode() throws UaException {
        try {
            return this.getSoftwareVersionNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSoftwareVersionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SoftwareVersion", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getBuildNumber() throws UaException {
        BaseDataVariableTypeNode node = this.getBuildNumberNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setBuildNumber(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getBuildNumberNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readBuildNumber() throws UaException {
        try {
            return this.readBuildNumberAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeBuildNumber(String value) throws UaException {
        try {
            this.writeBuildNumberAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readBuildNumberAsync() {
        return ((CompletableFuture)this.getBuildNumberNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeBuildNumberAsync(String buildNumber) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)buildNumber));
        return this.getBuildNumberNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getBuildNumberNode() throws UaException {
        try {
            return this.getBuildNumberNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getBuildNumberNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BuildNumber", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public DateTime getBuildDate() throws UaException {
        BaseDataVariableTypeNode node = this.getBuildDateNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setBuildDate(DateTime value) throws UaException {
        BaseDataVariableTypeNode node = this.getBuildDateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readBuildDate() throws UaException {
        try {
            return this.readBuildDateAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeBuildDate(DateTime value) throws UaException {
        try {
            this.writeBuildDateAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readBuildDateAsync() {
        return ((CompletableFuture)this.getBuildDateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeBuildDateAsync(DateTime buildDate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)buildDate));
        return this.getBuildDateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getBuildDateNode() throws UaException {
        try {
            return this.getBuildDateNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getBuildDateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BuildDate", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

