/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.UserManagementType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.PasswordOptionsMask;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.UserManagementDataType;

public class UserManagementTypeNode
extends BaseObjectTypeNode
implements UserManagementType {
    public UserManagementTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UserManagementDataType[] getUsers() throws UaException {
        PropertyTypeNode node = this.getUsersNode();
        return this.cast(node.getValue().getValue().getValue(), UserManagementDataType[].class);
    }

    @Override
    public void setUsers(UserManagementDataType[] value) throws UaException {
        PropertyTypeNode node = this.getUsersNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public UserManagementDataType[] readUsers() throws UaException {
        try {
            return this.readUsersAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeUsers(UserManagementDataType[] value) throws UaException {
        try {
            this.writeUsersAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UserManagementDataType[]> readUsersAsync() {
        return ((CompletableFuture)this.getUsersNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), UserManagementDataType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeUsersAsync(UserManagementDataType[] users) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])users);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getUsersNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getUsersNode() throws UaException {
        try {
            return this.getUsersNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUsersNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Users", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Range getPasswordLength() throws UaException {
        PropertyTypeNode node = this.getPasswordLengthNode();
        return this.cast(node.getValue().getValue().getValue(), Range.class);
    }

    @Override
    public void setPasswordLength(Range value) throws UaException {
        PropertyTypeNode node = this.getPasswordLengthNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public Range readPasswordLength() throws UaException {
        try {
            return this.readPasswordLengthAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writePasswordLength(Range value) throws UaException {
        try {
            this.writePasswordLengthAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Range> readPasswordLengthAsync() {
        return ((CompletableFuture)this.getPasswordLengthNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), Range.class));
    }

    @Override
    public CompletableFuture<StatusCode> writePasswordLengthAsync(Range passwordLength) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)passwordLength);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getPasswordLengthNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPasswordLengthNode() throws UaException {
        try {
            return this.getPasswordLengthNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPasswordLengthNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PasswordLength", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public PasswordOptionsMask getPasswordOptions() throws UaException {
        PropertyTypeNode node = this.getPasswordOptionsNode();
        return (PasswordOptionsMask)node.getValue().getValue().getValue();
    }

    @Override
    public void setPasswordOptions(PasswordOptionsMask value) throws UaException {
        PropertyTypeNode node = this.getPasswordOptionsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public PasswordOptionsMask readPasswordOptions() throws UaException {
        try {
            return this.readPasswordOptionsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writePasswordOptions(PasswordOptionsMask value) throws UaException {
        try {
            this.writePasswordOptionsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends PasswordOptionsMask> readPasswordOptionsAsync() {
        return ((CompletableFuture)this.getPasswordOptionsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (PasswordOptionsMask)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePasswordOptionsAsync(PasswordOptionsMask passwordOptions) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)passwordOptions));
        return this.getPasswordOptionsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPasswordOptionsNode() throws UaException {
        try {
            return this.getPasswordOptionsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPasswordOptionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PasswordOptions", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getPasswordRestrictions() throws UaException {
        PropertyTypeNode node = this.getPasswordRestrictionsNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setPasswordRestrictions(LocalizedText value) throws UaException {
        PropertyTypeNode node = this.getPasswordRestrictionsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readPasswordRestrictions() throws UaException {
        try {
            return this.readPasswordRestrictionsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writePasswordRestrictions(LocalizedText value) throws UaException {
        try {
            this.writePasswordRestrictionsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readPasswordRestrictionsAsync() {
        return ((CompletableFuture)this.getPasswordRestrictionsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePasswordRestrictionsAsync(LocalizedText passwordRestrictions) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)passwordRestrictions));
        return this.getPasswordRestrictionsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPasswordRestrictionsNode() throws UaException {
        try {
            return this.getPasswordRestrictionsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPasswordRestrictionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PasswordRestrictions", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

