/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.SystemOffNormalAlarmTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.TrustListOutOfDateAlarmType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class TrustListOutOfDateAlarmTypeNode
extends SystemOffNormalAlarmTypeNode
implements TrustListOutOfDateAlarmType {
    public TrustListOutOfDateAlarmTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public NodeId getTrustListId() throws UaException {
        PropertyTypeNode node = this.getTrustListIdNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setTrustListId(NodeId value) throws UaException {
        PropertyTypeNode node = this.getTrustListIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readTrustListId() throws UaException {
        try {
            return this.readTrustListIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeTrustListId(NodeId value) throws UaException {
        try {
            this.writeTrustListIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readTrustListIdAsync() {
        return ((CompletableFuture)this.getTrustListIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTrustListIdAsync(NodeId trustListId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)trustListId));
        return this.getTrustListIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getTrustListIdNode() throws UaException {
        try {
            return this.getTrustListIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getTrustListIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TrustListId", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getLastUpdateTime() throws UaException {
        PropertyTypeNode node = this.getLastUpdateTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastUpdateTime(DateTime value) throws UaException {
        PropertyTypeNode node = this.getLastUpdateTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readLastUpdateTime() throws UaException {
        try {
            return this.readLastUpdateTimeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeLastUpdateTime(DateTime value) throws UaException {
        try {
            this.writeLastUpdateTimeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readLastUpdateTimeAsync() {
        return ((CompletableFuture)this.getLastUpdateTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastUpdateTimeAsync(DateTime lastUpdateTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastUpdateTime));
        return this.getLastUpdateTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLastUpdateTimeNode() throws UaException {
        try {
            return this.getLastUpdateTimeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLastUpdateTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastUpdateTime", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getUpdateFrequency() throws UaException {
        PropertyTypeNode node = this.getUpdateFrequencyNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setUpdateFrequency(Double value) throws UaException {
        PropertyTypeNode node = this.getUpdateFrequencyNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readUpdateFrequency() throws UaException {
        try {
            return this.readUpdateFrequencyAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeUpdateFrequency(Double value) throws UaException {
        try {
            this.writeUpdateFrequencyAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readUpdateFrequencyAsync() {
        return ((CompletableFuture)this.getUpdateFrequencyNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeUpdateFrequencyAsync(Double updateFrequency) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)updateFrequency));
        return this.getUpdateFrequencyNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getUpdateFrequencyNode() throws UaException {
        try {
            return this.getUpdateFrequencyNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUpdateFrequencyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UpdateFrequency", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

