/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.TransactionDiagnosticsType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.TransactionErrorType;

public class TransactionDiagnosticsTypeNode
extends BaseObjectTypeNode
implements TransactionDiagnosticsType {
    public TransactionDiagnosticsTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public DateTime getStartTime() throws UaException {
        PropertyTypeNode node = this.getStartTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setStartTime(DateTime value) throws UaException {
        PropertyTypeNode node = this.getStartTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readStartTime() throws UaException {
        try {
            return this.readStartTimeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeStartTime(DateTime value) throws UaException {
        try {
            this.writeStartTimeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readStartTimeAsync() {
        return ((CompletableFuture)this.getStartTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStartTimeAsync(DateTime startTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)startTime));
        return this.getStartTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStartTimeNode() throws UaException {
        try {
            return this.getStartTimeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStartTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StartTime", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getEndTime() throws UaException {
        PropertyTypeNode node = this.getEndTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setEndTime(DateTime value) throws UaException {
        PropertyTypeNode node = this.getEndTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readEndTime() throws UaException {
        try {
            return this.readEndTimeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeEndTime(DateTime value) throws UaException {
        try {
            this.writeEndTimeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readEndTimeAsync() {
        return ((CompletableFuture)this.getEndTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEndTimeAsync(DateTime endTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)endTime));
        return this.getEndTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEndTimeNode() throws UaException {
        try {
            return this.getEndTimeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEndTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EndTime", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public StatusCode getResult() throws UaException {
        PropertyTypeNode node = this.getResultNode();
        return (StatusCode)node.getValue().getValue().getValue();
    }

    @Override
    public void setResult(StatusCode value) throws UaException {
        PropertyTypeNode node = this.getResultNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public StatusCode readResult() throws UaException {
        try {
            return this.readResultAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeResult(StatusCode value) throws UaException {
        try {
            this.writeResultAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends StatusCode> readResultAsync() {
        return ((CompletableFuture)this.getResultNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (StatusCode)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeResultAsync(StatusCode result) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)result));
        return this.getResultNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getResultNode() throws UaException {
        try {
            return this.getResultNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getResultNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Result", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId[] getAffectedTrustLists() throws UaException {
        PropertyTypeNode node = this.getAffectedTrustListsNode();
        return (NodeId[])node.getValue().getValue().getValue();
    }

    @Override
    public void setAffectedTrustLists(NodeId[] value) throws UaException {
        PropertyTypeNode node = this.getAffectedTrustListsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId[] readAffectedTrustLists() throws UaException {
        try {
            return this.readAffectedTrustListsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeAffectedTrustLists(NodeId[] value) throws UaException {
        try {
            this.writeAffectedTrustListsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends NodeId[]> readAffectedTrustListsAsync() {
        return ((CompletableFuture)this.getAffectedTrustListsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAffectedTrustListsAsync(NodeId[] affectedTrustLists) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)affectedTrustLists));
        return this.getAffectedTrustListsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getAffectedTrustListsNode() throws UaException {
        try {
            return this.getAffectedTrustListsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getAffectedTrustListsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AffectedTrustLists", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId[] getAffectedCertificateGroups() throws UaException {
        PropertyTypeNode node = this.getAffectedCertificateGroupsNode();
        return (NodeId[])node.getValue().getValue().getValue();
    }

    @Override
    public void setAffectedCertificateGroups(NodeId[] value) throws UaException {
        PropertyTypeNode node = this.getAffectedCertificateGroupsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId[] readAffectedCertificateGroups() throws UaException {
        try {
            return this.readAffectedCertificateGroupsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeAffectedCertificateGroups(NodeId[] value) throws UaException {
        try {
            this.writeAffectedCertificateGroupsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends NodeId[]> readAffectedCertificateGroupsAsync() {
        return ((CompletableFuture)this.getAffectedCertificateGroupsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAffectedCertificateGroupsAsync(NodeId[] affectedCertificateGroups) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)affectedCertificateGroups));
        return this.getAffectedCertificateGroupsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getAffectedCertificateGroupsNode() throws UaException {
        try {
            return this.getAffectedCertificateGroupsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getAffectedCertificateGroupsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AffectedCertificateGroups", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public TransactionErrorType[] getErrors() throws UaException {
        PropertyTypeNode node = this.getErrorsNode();
        return this.cast(node.getValue().getValue().getValue(), TransactionErrorType[].class);
    }

    @Override
    public void setErrors(TransactionErrorType[] value) throws UaException {
        PropertyTypeNode node = this.getErrorsNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public TransactionErrorType[] readErrors() throws UaException {
        try {
            return this.readErrorsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeErrors(TransactionErrorType[] value) throws UaException {
        try {
            this.writeErrorsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends TransactionErrorType[]> readErrorsAsync() {
        return ((CompletableFuture)this.getErrorsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), TransactionErrorType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeErrorsAsync(TransactionErrorType[] errors) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])errors);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getErrorsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getErrorsNode() throws UaException {
        try {
            return this.getErrorsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getErrorsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Errors", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

