/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.CertificateGroupFolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ServerConfigurationType;
import org.eclipse.milo.opcua.sdk.client.model.objects.TransactionDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ServerConfigurationTypeNode
extends BaseObjectTypeNode
implements ServerConfigurationType {
    public ServerConfigurationTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String getApplicationUri() throws UaException {
        PropertyTypeNode node = this.getApplicationUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setApplicationUri(String value) throws UaException {
        PropertyTypeNode node = this.getApplicationUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readApplicationUri() throws UaException {
        try {
            return this.readApplicationUriAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeApplicationUri(String value) throws UaException {
        try {
            this.writeApplicationUriAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readApplicationUriAsync() {
        return ((CompletableFuture)this.getApplicationUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeApplicationUriAsync(String applicationUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)applicationUri));
        return this.getApplicationUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getApplicationUriNode() throws UaException {
        try {
            return this.getApplicationUriNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getApplicationUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ApplicationUri", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getProductUri() throws UaException {
        PropertyTypeNode node = this.getProductUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setProductUri(String value) throws UaException {
        PropertyTypeNode node = this.getProductUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readProductUri() throws UaException {
        try {
            return this.readProductUriAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeProductUri(String value) throws UaException {
        try {
            this.writeProductUriAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readProductUriAsync() {
        return ((CompletableFuture)this.getProductUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeProductUriAsync(String productUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)productUri));
        return this.getProductUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getProductUriNode() throws UaException {
        try {
            return this.getProductUriNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getProductUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ProductUri", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ApplicationType getApplicationType() throws UaException {
        PropertyTypeNode node = this.getApplicationTypeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return ApplicationType.from((int)((Integer)value));
        }
        if (value instanceof ApplicationType) {
            return (ApplicationType)value;
        }
        return null;
    }

    @Override
    public void setApplicationType(ApplicationType value) throws UaException {
        PropertyTypeNode node = this.getApplicationTypeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ApplicationType readApplicationType() throws UaException {
        try {
            return this.readApplicationTypeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeApplicationType(ApplicationType value) throws UaException {
        try {
            this.writeApplicationTypeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends ApplicationType> readApplicationTypeAsync() {
        return ((CompletableFuture)this.getApplicationTypeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return ApplicationType.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeApplicationTypeAsync(ApplicationType applicationType) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)applicationType));
        return this.getApplicationTypeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getApplicationTypeNode() throws UaException {
        try {
            return this.getApplicationTypeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getApplicationTypeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ApplicationType", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText[] getApplicationNames() throws UaException {
        PropertyTypeNode node = this.getApplicationNamesNode();
        return (LocalizedText[])node.getValue().getValue().getValue();
    }

    @Override
    public void setApplicationNames(LocalizedText[] value) throws UaException {
        PropertyTypeNode node = this.getApplicationNamesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText[] readApplicationNames() throws UaException {
        try {
            return this.readApplicationNamesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeApplicationNames(LocalizedText[] value) throws UaException {
        try {
            this.writeApplicationNamesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText[]> readApplicationNamesAsync() {
        return ((CompletableFuture)this.getApplicationNamesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeApplicationNamesAsync(LocalizedText[] applicationNames) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)applicationNames));
        return this.getApplicationNamesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getApplicationNamesNode() throws UaException {
        try {
            return this.getApplicationNamesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getApplicationNamesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ApplicationNames", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String[] getServerCapabilities() throws UaException {
        PropertyTypeNode node = this.getServerCapabilitiesNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setServerCapabilities(String[] value) throws UaException {
        PropertyTypeNode node = this.getServerCapabilitiesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String[] readServerCapabilities() throws UaException {
        try {
            return this.readServerCapabilitiesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeServerCapabilities(String[] value) throws UaException {
        try {
            this.writeServerCapabilitiesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readServerCapabilitiesAsync() {
        return ((CompletableFuture)this.getServerCapabilitiesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServerCapabilitiesAsync(String[] serverCapabilities) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serverCapabilities));
        return this.getServerCapabilitiesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServerCapabilitiesNode() throws UaException {
        try {
            return this.getServerCapabilitiesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServerCapabilitiesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerCapabilities", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String[] getSupportedPrivateKeyFormats() throws UaException {
        PropertyTypeNode node = this.getSupportedPrivateKeyFormatsNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setSupportedPrivateKeyFormats(String[] value) throws UaException {
        PropertyTypeNode node = this.getSupportedPrivateKeyFormatsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String[] readSupportedPrivateKeyFormats() throws UaException {
        try {
            return this.readSupportedPrivateKeyFormatsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSupportedPrivateKeyFormats(String[] value) throws UaException {
        try {
            this.writeSupportedPrivateKeyFormatsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readSupportedPrivateKeyFormatsAsync() {
        return ((CompletableFuture)this.getSupportedPrivateKeyFormatsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSupportedPrivateKeyFormatsAsync(String[] supportedPrivateKeyFormats) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)supportedPrivateKeyFormats));
        return this.getSupportedPrivateKeyFormatsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSupportedPrivateKeyFormatsNode() throws UaException {
        try {
            return this.getSupportedPrivateKeyFormatsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSupportedPrivateKeyFormatsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SupportedPrivateKeyFormats", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxTrustListSize() throws UaException {
        PropertyTypeNode node = this.getMaxTrustListSizeNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxTrustListSize(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxTrustListSizeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxTrustListSize() throws UaException {
        try {
            return this.readMaxTrustListSizeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxTrustListSize(UInteger value) throws UaException {
        try {
            this.writeMaxTrustListSizeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxTrustListSizeAsync() {
        return ((CompletableFuture)this.getMaxTrustListSizeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxTrustListSizeAsync(UInteger maxTrustListSize) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxTrustListSize));
        return this.getMaxTrustListSizeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxTrustListSizeNode() throws UaException {
        try {
            return this.getMaxTrustListSizeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxTrustListSizeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxTrustListSize", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getMulticastDnsEnabled() throws UaException {
        PropertyTypeNode node = this.getMulticastDnsEnabledNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setMulticastDnsEnabled(Boolean value) throws UaException {
        PropertyTypeNode node = this.getMulticastDnsEnabledNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readMulticastDnsEnabled() throws UaException {
        try {
            return this.readMulticastDnsEnabledAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMulticastDnsEnabled(Boolean value) throws UaException {
        try {
            this.writeMulticastDnsEnabledAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readMulticastDnsEnabledAsync() {
        return ((CompletableFuture)this.getMulticastDnsEnabledNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMulticastDnsEnabledAsync(Boolean multicastDnsEnabled) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)multicastDnsEnabled));
        return this.getMulticastDnsEnabledNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMulticastDnsEnabledNode() throws UaException {
        try {
            return this.getMulticastDnsEnabledNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMulticastDnsEnabledNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MulticastDnsEnabled", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getHasSecureElement() throws UaException {
        PropertyTypeNode node = this.getHasSecureElementNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setHasSecureElement(Boolean value) throws UaException {
        PropertyTypeNode node = this.getHasSecureElementNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readHasSecureElement() throws UaException {
        try {
            return this.readHasSecureElementAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeHasSecureElement(Boolean value) throws UaException {
        try {
            this.writeHasSecureElementAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readHasSecureElementAsync() {
        return ((CompletableFuture)this.getHasSecureElementNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHasSecureElementAsync(Boolean hasSecureElement) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)hasSecureElement));
        return this.getHasSecureElementNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getHasSecureElementNode() throws UaException {
        try {
            return this.getHasSecureElementNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getHasSecureElementNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HasSecureElement", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getSupportsTransactions() throws UaException {
        PropertyTypeNode node = this.getSupportsTransactionsNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setSupportsTransactions(Boolean value) throws UaException {
        PropertyTypeNode node = this.getSupportsTransactionsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readSupportsTransactions() throws UaException {
        try {
            return this.readSupportsTransactionsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSupportsTransactions(Boolean value) throws UaException {
        try {
            this.writeSupportsTransactionsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readSupportsTransactionsAsync() {
        return ((CompletableFuture)this.getSupportsTransactionsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSupportsTransactionsAsync(Boolean supportsTransactions) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)supportsTransactions));
        return this.getSupportsTransactionsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSupportsTransactionsNode() throws UaException {
        try {
            return this.getSupportsTransactionsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSupportsTransactionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SupportsTransactions", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getInApplicationSetup() throws UaException {
        PropertyTypeNode node = this.getInApplicationSetupNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setInApplicationSetup(Boolean value) throws UaException {
        PropertyTypeNode node = this.getInApplicationSetupNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readInApplicationSetup() throws UaException {
        try {
            return this.readInApplicationSetupAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeInApplicationSetup(Boolean value) throws UaException {
        try {
            this.writeInApplicationSetupAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readInApplicationSetupAsync() {
        return ((CompletableFuture)this.getInApplicationSetupNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeInApplicationSetupAsync(Boolean inApplicationSetup) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)inApplicationSetup));
        return this.getInApplicationSetupNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getInApplicationSetupNode() throws UaException {
        try {
            return this.getInApplicationSetupNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getInApplicationSetupNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InApplicationSetup", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public CertificateGroupFolderTypeNode getCertificateGroupsNode() throws UaException {
        try {
            return this.getCertificateGroupsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends CertificateGroupFolderTypeNode> getCertificateGroupsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CertificateGroups", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (CertificateGroupFolderTypeNode)node);
    }

    @Override
    public TransactionDiagnosticsTypeNode getTransactionDiagnosticsNode() throws UaException {
        try {
            return this.getTransactionDiagnosticsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TransactionDiagnosticsTypeNode> getTransactionDiagnosticsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransactionDiagnostics", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TransactionDiagnosticsTypeNode)node);
    }
}

