/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.FolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.OperationLimitsTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.RoleSetTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ServerCapabilitiesType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;

public class ServerCapabilitiesTypeNode
extends BaseObjectTypeNode
implements ServerCapabilitiesType {
    public ServerCapabilitiesTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String[] getServerProfileArray() throws UaException {
        PropertyTypeNode node = this.getServerProfileArrayNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setServerProfileArray(String[] value) throws UaException {
        PropertyTypeNode node = this.getServerProfileArrayNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String[] readServerProfileArray() throws UaException {
        try {
            return this.readServerProfileArrayAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeServerProfileArray(String[] value) throws UaException {
        try {
            this.writeServerProfileArrayAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readServerProfileArrayAsync() {
        return ((CompletableFuture)this.getServerProfileArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServerProfileArrayAsync(String[] serverProfileArray) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serverProfileArray));
        return this.getServerProfileArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServerProfileArrayNode() throws UaException {
        try {
            return this.getServerProfileArrayNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServerProfileArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerProfileArray", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String[] getLocaleIdArray() throws UaException {
        PropertyTypeNode node = this.getLocaleIdArrayNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setLocaleIdArray(String[] value) throws UaException {
        PropertyTypeNode node = this.getLocaleIdArrayNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String[] readLocaleIdArray() throws UaException {
        try {
            return this.readLocaleIdArrayAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeLocaleIdArray(String[] value) throws UaException {
        try {
            this.writeLocaleIdArrayAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readLocaleIdArrayAsync() {
        return ((CompletableFuture)this.getLocaleIdArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLocaleIdArrayAsync(String[] localeIdArray) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)localeIdArray));
        return this.getLocaleIdArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLocaleIdArrayNode() throws UaException {
        try {
            return this.getLocaleIdArrayNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLocaleIdArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LocaleIdArray", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getMinSupportedSampleRate() throws UaException {
        PropertyTypeNode node = this.getMinSupportedSampleRateNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setMinSupportedSampleRate(Double value) throws UaException {
        PropertyTypeNode node = this.getMinSupportedSampleRateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readMinSupportedSampleRate() throws UaException {
        try {
            return this.readMinSupportedSampleRateAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMinSupportedSampleRate(Double value) throws UaException {
        try {
            this.writeMinSupportedSampleRateAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readMinSupportedSampleRateAsync() {
        return ((CompletableFuture)this.getMinSupportedSampleRateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMinSupportedSampleRateAsync(Double minSupportedSampleRate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)minSupportedSampleRate));
        return this.getMinSupportedSampleRateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMinSupportedSampleRateNode() throws UaException {
        try {
            return this.getMinSupportedSampleRateNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMinSupportedSampleRateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MinSupportedSampleRate", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getMaxBrowseContinuationPoints() throws UaException {
        PropertyTypeNode node = this.getMaxBrowseContinuationPointsNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxBrowseContinuationPoints(UShort value) throws UaException {
        PropertyTypeNode node = this.getMaxBrowseContinuationPointsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readMaxBrowseContinuationPoints() throws UaException {
        try {
            return this.readMaxBrowseContinuationPointsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxBrowseContinuationPoints(UShort value) throws UaException {
        try {
            this.writeMaxBrowseContinuationPointsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readMaxBrowseContinuationPointsAsync() {
        return ((CompletableFuture)this.getMaxBrowseContinuationPointsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxBrowseContinuationPointsAsync(UShort maxBrowseContinuationPoints) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxBrowseContinuationPoints));
        return this.getMaxBrowseContinuationPointsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxBrowseContinuationPointsNode() throws UaException {
        try {
            return this.getMaxBrowseContinuationPointsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxBrowseContinuationPointsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxBrowseContinuationPoints", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getMaxQueryContinuationPoints() throws UaException {
        PropertyTypeNode node = this.getMaxQueryContinuationPointsNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxQueryContinuationPoints(UShort value) throws UaException {
        PropertyTypeNode node = this.getMaxQueryContinuationPointsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readMaxQueryContinuationPoints() throws UaException {
        try {
            return this.readMaxQueryContinuationPointsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxQueryContinuationPoints(UShort value) throws UaException {
        try {
            this.writeMaxQueryContinuationPointsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readMaxQueryContinuationPointsAsync() {
        return ((CompletableFuture)this.getMaxQueryContinuationPointsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxQueryContinuationPointsAsync(UShort maxQueryContinuationPoints) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxQueryContinuationPoints));
        return this.getMaxQueryContinuationPointsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxQueryContinuationPointsNode() throws UaException {
        try {
            return this.getMaxQueryContinuationPointsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxQueryContinuationPointsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxQueryContinuationPoints", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getMaxHistoryContinuationPoints() throws UaException {
        PropertyTypeNode node = this.getMaxHistoryContinuationPointsNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxHistoryContinuationPoints(UShort value) throws UaException {
        PropertyTypeNode node = this.getMaxHistoryContinuationPointsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readMaxHistoryContinuationPoints() throws UaException {
        try {
            return this.readMaxHistoryContinuationPointsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxHistoryContinuationPoints(UShort value) throws UaException {
        try {
            this.writeMaxHistoryContinuationPointsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readMaxHistoryContinuationPointsAsync() {
        return ((CompletableFuture)this.getMaxHistoryContinuationPointsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxHistoryContinuationPointsAsync(UShort maxHistoryContinuationPoints) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxHistoryContinuationPoints));
        return this.getMaxHistoryContinuationPointsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxHistoryContinuationPointsNode() throws UaException {
        try {
            return this.getMaxHistoryContinuationPointsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxHistoryContinuationPointsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxHistoryContinuationPoints", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public SignedSoftwareCertificate[] getSoftwareCertificates() throws UaException {
        PropertyTypeNode node = this.getSoftwareCertificatesNode();
        return this.cast(node.getValue().getValue().getValue(), SignedSoftwareCertificate[].class);
    }

    @Override
    public void setSoftwareCertificates(SignedSoftwareCertificate[] value) throws UaException {
        PropertyTypeNode node = this.getSoftwareCertificatesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public SignedSoftwareCertificate[] readSoftwareCertificates() throws UaException {
        try {
            return this.readSoftwareCertificatesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSoftwareCertificates(SignedSoftwareCertificate[] value) throws UaException {
        try {
            this.writeSoftwareCertificatesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends SignedSoftwareCertificate[]> readSoftwareCertificatesAsync() {
        return ((CompletableFuture)this.getSoftwareCertificatesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), SignedSoftwareCertificate[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeSoftwareCertificatesAsync(SignedSoftwareCertificate[] softwareCertificates) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])softwareCertificates);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getSoftwareCertificatesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSoftwareCertificatesNode() throws UaException {
        try {
            return this.getSoftwareCertificatesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSoftwareCertificatesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SoftwareCertificates", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxArrayLength() throws UaException {
        PropertyTypeNode node = this.getMaxArrayLengthNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxArrayLength(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxArrayLengthNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxArrayLength() throws UaException {
        try {
            return this.readMaxArrayLengthAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxArrayLength(UInteger value) throws UaException {
        try {
            this.writeMaxArrayLengthAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxArrayLengthAsync() {
        return ((CompletableFuture)this.getMaxArrayLengthNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxArrayLengthAsync(UInteger maxArrayLength) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxArrayLength));
        return this.getMaxArrayLengthNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxArrayLengthNode() throws UaException {
        try {
            return this.getMaxArrayLengthNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxArrayLengthNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxArrayLength", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxStringLength() throws UaException {
        PropertyTypeNode node = this.getMaxStringLengthNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxStringLength(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxStringLengthNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxStringLength() throws UaException {
        try {
            return this.readMaxStringLengthAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxStringLength(UInteger value) throws UaException {
        try {
            this.writeMaxStringLengthAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxStringLengthAsync() {
        return ((CompletableFuture)this.getMaxStringLengthNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxStringLengthAsync(UInteger maxStringLength) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxStringLength));
        return this.getMaxStringLengthNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxStringLengthNode() throws UaException {
        try {
            return this.getMaxStringLengthNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxStringLengthNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxStringLength", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxByteStringLength() throws UaException {
        PropertyTypeNode node = this.getMaxByteStringLengthNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxByteStringLength(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxByteStringLengthNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxByteStringLength() throws UaException {
        try {
            return this.readMaxByteStringLengthAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxByteStringLength(UInteger value) throws UaException {
        try {
            this.writeMaxByteStringLengthAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxByteStringLengthAsync() {
        return ((CompletableFuture)this.getMaxByteStringLengthNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxByteStringLengthAsync(UInteger maxByteStringLength) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxByteStringLength));
        return this.getMaxByteStringLengthNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxByteStringLengthNode() throws UaException {
        try {
            return this.getMaxByteStringLengthNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxByteStringLengthNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxByteStringLength", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxSessions() throws UaException {
        PropertyTypeNode node = this.getMaxSessionsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxSessions(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxSessionsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxSessions() throws UaException {
        try {
            return this.readMaxSessionsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxSessions(UInteger value) throws UaException {
        try {
            this.writeMaxSessionsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxSessionsAsync() {
        return ((CompletableFuture)this.getMaxSessionsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxSessionsAsync(UInteger maxSessions) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxSessions));
        return this.getMaxSessionsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxSessionsNode() throws UaException {
        try {
            return this.getMaxSessionsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxSessionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxSessions", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxSubscriptions() throws UaException {
        PropertyTypeNode node = this.getMaxSubscriptionsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxSubscriptions(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxSubscriptionsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxSubscriptions() throws UaException {
        try {
            return this.readMaxSubscriptionsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxSubscriptions(UInteger value) throws UaException {
        try {
            this.writeMaxSubscriptionsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxSubscriptionsAsync() {
        return ((CompletableFuture)this.getMaxSubscriptionsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxSubscriptionsAsync(UInteger maxSubscriptions) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxSubscriptions));
        return this.getMaxSubscriptionsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxSubscriptionsNode() throws UaException {
        try {
            return this.getMaxSubscriptionsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxSubscriptionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxSubscriptions", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxMonitoredItems() throws UaException {
        PropertyTypeNode node = this.getMaxMonitoredItemsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxMonitoredItems(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxMonitoredItemsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxMonitoredItems() throws UaException {
        try {
            return this.readMaxMonitoredItemsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxMonitoredItems(UInteger value) throws UaException {
        try {
            this.writeMaxMonitoredItemsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxMonitoredItemsAsync() {
        return ((CompletableFuture)this.getMaxMonitoredItemsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxMonitoredItemsAsync(UInteger maxMonitoredItems) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxMonitoredItems));
        return this.getMaxMonitoredItemsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxMonitoredItemsNode() throws UaException {
        try {
            return this.getMaxMonitoredItemsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxMonitoredItemsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxMonitoredItems", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxSubscriptionsPerSession() throws UaException {
        PropertyTypeNode node = this.getMaxSubscriptionsPerSessionNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxSubscriptionsPerSession(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxSubscriptionsPerSessionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxSubscriptionsPerSession() throws UaException {
        try {
            return this.readMaxSubscriptionsPerSessionAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxSubscriptionsPerSession(UInteger value) throws UaException {
        try {
            this.writeMaxSubscriptionsPerSessionAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxSubscriptionsPerSessionAsync() {
        return ((CompletableFuture)this.getMaxSubscriptionsPerSessionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxSubscriptionsPerSessionAsync(UInteger maxSubscriptionsPerSession) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxSubscriptionsPerSession));
        return this.getMaxSubscriptionsPerSessionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxSubscriptionsPerSessionNode() throws UaException {
        try {
            return this.getMaxSubscriptionsPerSessionNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxSubscriptionsPerSessionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxSubscriptionsPerSession", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxMonitoredItemsPerSubscription() throws UaException {
        PropertyTypeNode node = this.getMaxMonitoredItemsPerSubscriptionNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxMonitoredItemsPerSubscription(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxMonitoredItemsPerSubscriptionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxMonitoredItemsPerSubscription() throws UaException {
        try {
            return this.readMaxMonitoredItemsPerSubscriptionAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxMonitoredItemsPerSubscription(UInteger value) throws UaException {
        try {
            this.writeMaxMonitoredItemsPerSubscriptionAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxMonitoredItemsPerSubscriptionAsync() {
        return ((CompletableFuture)this.getMaxMonitoredItemsPerSubscriptionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxMonitoredItemsPerSubscriptionAsync(UInteger maxMonitoredItemsPerSubscription) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxMonitoredItemsPerSubscription));
        return this.getMaxMonitoredItemsPerSubscriptionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxMonitoredItemsPerSubscriptionNode() throws UaException {
        try {
            return this.getMaxMonitoredItemsPerSubscriptionNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxMonitoredItemsPerSubscriptionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxMonitoredItemsPerSubscription", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxSelectClauseParameters() throws UaException {
        PropertyTypeNode node = this.getMaxSelectClauseParametersNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxSelectClauseParameters(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxSelectClauseParametersNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxSelectClauseParameters() throws UaException {
        try {
            return this.readMaxSelectClauseParametersAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxSelectClauseParameters(UInteger value) throws UaException {
        try {
            this.writeMaxSelectClauseParametersAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxSelectClauseParametersAsync() {
        return ((CompletableFuture)this.getMaxSelectClauseParametersNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxSelectClauseParametersAsync(UInteger maxSelectClauseParameters) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxSelectClauseParameters));
        return this.getMaxSelectClauseParametersNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxSelectClauseParametersNode() throws UaException {
        try {
            return this.getMaxSelectClauseParametersNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxSelectClauseParametersNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxSelectClauseParameters", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxWhereClauseParameters() throws UaException {
        PropertyTypeNode node = this.getMaxWhereClauseParametersNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxWhereClauseParameters(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxWhereClauseParametersNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxWhereClauseParameters() throws UaException {
        try {
            return this.readMaxWhereClauseParametersAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxWhereClauseParameters(UInteger value) throws UaException {
        try {
            this.writeMaxWhereClauseParametersAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxWhereClauseParametersAsync() {
        return ((CompletableFuture)this.getMaxWhereClauseParametersNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxWhereClauseParametersAsync(UInteger maxWhereClauseParameters) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxWhereClauseParameters));
        return this.getMaxWhereClauseParametersNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxWhereClauseParametersNode() throws UaException {
        try {
            return this.getMaxWhereClauseParametersNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxWhereClauseParametersNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxWhereClauseParameters", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxMonitoredItemsQueueSize() throws UaException {
        PropertyTypeNode node = this.getMaxMonitoredItemsQueueSizeNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxMonitoredItemsQueueSize(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxMonitoredItemsQueueSizeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxMonitoredItemsQueueSize() throws UaException {
        try {
            return this.readMaxMonitoredItemsQueueSizeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxMonitoredItemsQueueSize(UInteger value) throws UaException {
        try {
            this.writeMaxMonitoredItemsQueueSizeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxMonitoredItemsQueueSizeAsync() {
        return ((CompletableFuture)this.getMaxMonitoredItemsQueueSizeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxMonitoredItemsQueueSizeAsync(UInteger maxMonitoredItemsQueueSize) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxMonitoredItemsQueueSize));
        return this.getMaxMonitoredItemsQueueSizeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxMonitoredItemsQueueSizeNode() throws UaException {
        try {
            return this.getMaxMonitoredItemsQueueSizeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxMonitoredItemsQueueSizeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxMonitoredItemsQueueSize", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public QualifiedName[] getConformanceUnits() throws UaException {
        PropertyTypeNode node = this.getConformanceUnitsNode();
        return (QualifiedName[])node.getValue().getValue().getValue();
    }

    @Override
    public void setConformanceUnits(QualifiedName[] value) throws UaException {
        PropertyTypeNode node = this.getConformanceUnitsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public QualifiedName[] readConformanceUnits() throws UaException {
        try {
            return this.readConformanceUnitsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeConformanceUnits(QualifiedName[] value) throws UaException {
        try {
            this.writeConformanceUnitsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends QualifiedName[]> readConformanceUnitsAsync() {
        return ((CompletableFuture)this.getConformanceUnitsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (QualifiedName[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConformanceUnitsAsync(QualifiedName[] conformanceUnits) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)conformanceUnits));
        return this.getConformanceUnitsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConformanceUnitsNode() throws UaException {
        try {
            return this.getConformanceUnitsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConformanceUnitsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConformanceUnits", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public OperationLimitsTypeNode getOperationLimitsNode() throws UaException {
        try {
            return this.getOperationLimitsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends OperationLimitsTypeNode> getOperationLimitsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OperationLimits", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (OperationLimitsTypeNode)node);
    }

    @Override
    public FolderTypeNode getModellingRulesNode() throws UaException {
        try {
            return this.getModellingRulesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends FolderTypeNode> getModellingRulesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ModellingRules", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (FolderTypeNode)node);
    }

    @Override
    public FolderTypeNode getAggregateFunctionsNode() throws UaException {
        try {
            return this.getAggregateFunctionsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends FolderTypeNode> getAggregateFunctionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AggregateFunctions", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (FolderTypeNode)node);
    }

    @Override
    public RoleSetTypeNode getRoleSetNode() throws UaException {
        try {
            return this.getRoleSetNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends RoleSetTypeNode> getRoleSetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RoleSet", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (RoleSetTypeNode)node);
    }
}

