/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.PublishedDataSetTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PublishedEventsType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;

public class PublishedEventsTypeNode
extends PublishedDataSetTypeNode
implements PublishedEventsType {
    public PublishedEventsTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public NodeId getPubSubEventNotifier() throws UaException {
        PropertyTypeNode node = this.getPubSubEventNotifierNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setPubSubEventNotifier(NodeId value) throws UaException {
        PropertyTypeNode node = this.getPubSubEventNotifierNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readPubSubEventNotifier() throws UaException {
        try {
            return this.readPubSubEventNotifierAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writePubSubEventNotifier(NodeId value) throws UaException {
        try {
            this.writePubSubEventNotifierAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readPubSubEventNotifierAsync() {
        return ((CompletableFuture)this.getPubSubEventNotifierNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePubSubEventNotifierAsync(NodeId pubSubEventNotifier) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)pubSubEventNotifier));
        return this.getPubSubEventNotifierNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPubSubEventNotifierNode() throws UaException {
        try {
            return this.getPubSubEventNotifierNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPubSubEventNotifierNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PubSubEventNotifier", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public SimpleAttributeOperand[] getSelectedFields() throws UaException {
        PropertyTypeNode node = this.getSelectedFieldsNode();
        return this.cast(node.getValue().getValue().getValue(), SimpleAttributeOperand[].class);
    }

    @Override
    public void setSelectedFields(SimpleAttributeOperand[] value) throws UaException {
        PropertyTypeNode node = this.getSelectedFieldsNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public SimpleAttributeOperand[] readSelectedFields() throws UaException {
        try {
            return this.readSelectedFieldsAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSelectedFields(SimpleAttributeOperand[] value) throws UaException {
        try {
            this.writeSelectedFieldsAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends SimpleAttributeOperand[]> readSelectedFieldsAsync() {
        return ((CompletableFuture)this.getSelectedFieldsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), SimpleAttributeOperand[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeSelectedFieldsAsync(SimpleAttributeOperand[] selectedFields) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])selectedFields);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getSelectedFieldsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSelectedFieldsNode() throws UaException {
        try {
            return this.getSelectedFieldsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSelectedFieldsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SelectedFields", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ContentFilter getFilter() throws UaException {
        PropertyTypeNode node = this.getFilterNode();
        return this.cast(node.getValue().getValue().getValue(), ContentFilter.class);
    }

    @Override
    public void setFilter(ContentFilter value) throws UaException {
        PropertyTypeNode node = this.getFilterNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public ContentFilter readFilter() throws UaException {
        try {
            return this.readFilterAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeFilter(ContentFilter value) throws UaException {
        try {
            this.writeFilterAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends ContentFilter> readFilterAsync() {
        return ((CompletableFuture)this.getFilterNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ContentFilter.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeFilterAsync(ContentFilter filter) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)filter);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getFilterNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getFilterNode() throws UaException {
        try {
            return this.getFilterNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getFilterNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Filter", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

