/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.NonTransparentRedundancyType;
import org.eclipse.milo.opcua.sdk.client.model.objects.ServerRedundancyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class NonTransparentRedundancyTypeNode
extends ServerRedundancyTypeNode
implements NonTransparentRedundancyType {
    public NonTransparentRedundancyTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String[] getServerUriArray() throws UaException {
        PropertyTypeNode node = this.getServerUriArrayNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setServerUriArray(String[] value) throws UaException {
        PropertyTypeNode node = this.getServerUriArrayNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String[] readServerUriArray() throws UaException {
        try {
            return this.readServerUriArrayAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeServerUriArray(String[] value) throws UaException {
        try {
            this.writeServerUriArrayAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readServerUriArrayAsync() {
        return ((CompletableFuture)this.getServerUriArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServerUriArrayAsync(String[] serverUriArray) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serverUriArray));
        return this.getServerUriArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServerUriArrayNode() throws UaException {
        try {
            return this.getServerUriArrayNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServerUriArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerUriArray", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

