/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AlarmConditionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.LimitAlarmType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class LimitAlarmTypeNode
extends AlarmConditionTypeNode
implements LimitAlarmType {
    public LimitAlarmTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public Double getHighHighLimit() throws UaException {
        PropertyTypeNode node = this.getHighHighLimitNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setHighHighLimit(Double value) throws UaException {
        PropertyTypeNode node = this.getHighHighLimitNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readHighHighLimit() throws UaException {
        try {
            return this.readHighHighLimitAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeHighHighLimit(Double value) throws UaException {
        try {
            this.writeHighHighLimitAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readHighHighLimitAsync() {
        return ((CompletableFuture)this.getHighHighLimitNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHighHighLimitAsync(Double highHighLimit) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)highHighLimit));
        return this.getHighHighLimitNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getHighHighLimitNode() throws UaException {
        try {
            return this.getHighHighLimitNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getHighHighLimitNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HighHighLimit", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getHighLimit() throws UaException {
        PropertyTypeNode node = this.getHighLimitNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setHighLimit(Double value) throws UaException {
        PropertyTypeNode node = this.getHighLimitNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readHighLimit() throws UaException {
        try {
            return this.readHighLimitAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeHighLimit(Double value) throws UaException {
        try {
            this.writeHighLimitAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readHighLimitAsync() {
        return ((CompletableFuture)this.getHighLimitNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHighLimitAsync(Double highLimit) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)highLimit));
        return this.getHighLimitNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getHighLimitNode() throws UaException {
        try {
            return this.getHighLimitNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getHighLimitNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HighLimit", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getLowLimit() throws UaException {
        PropertyTypeNode node = this.getLowLimitNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setLowLimit(Double value) throws UaException {
        PropertyTypeNode node = this.getLowLimitNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readLowLimit() throws UaException {
        try {
            return this.readLowLimitAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeLowLimit(Double value) throws UaException {
        try {
            this.writeLowLimitAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readLowLimitAsync() {
        return ((CompletableFuture)this.getLowLimitNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLowLimitAsync(Double lowLimit) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lowLimit));
        return this.getLowLimitNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLowLimitNode() throws UaException {
        try {
            return this.getLowLimitNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLowLimitNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LowLimit", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getLowLowLimit() throws UaException {
        PropertyTypeNode node = this.getLowLowLimitNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setLowLowLimit(Double value) throws UaException {
        PropertyTypeNode node = this.getLowLowLimitNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readLowLowLimit() throws UaException {
        try {
            return this.readLowLowLimitAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeLowLowLimit(Double value) throws UaException {
        try {
            this.writeLowLowLimitAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readLowLowLimitAsync() {
        return ((CompletableFuture)this.getLowLowLimitNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLowLowLimitAsync(Double lowLowLimit) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lowLowLimit));
        return this.getLowLowLimitNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLowLowLimitNode() throws UaException {
        try {
            return this.getLowLowLimitNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLowLowLimitNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LowLowLimit", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getBaseHighHighLimit() throws UaException {
        PropertyTypeNode node = this.getBaseHighHighLimitNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setBaseHighHighLimit(Double value) throws UaException {
        PropertyTypeNode node = this.getBaseHighHighLimitNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readBaseHighHighLimit() throws UaException {
        try {
            return this.readBaseHighHighLimitAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeBaseHighHighLimit(Double value) throws UaException {
        try {
            this.writeBaseHighHighLimitAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readBaseHighHighLimitAsync() {
        return ((CompletableFuture)this.getBaseHighHighLimitNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeBaseHighHighLimitAsync(Double baseHighHighLimit) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)baseHighHighLimit));
        return this.getBaseHighHighLimitNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getBaseHighHighLimitNode() throws UaException {
        try {
            return this.getBaseHighHighLimitNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getBaseHighHighLimitNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BaseHighHighLimit", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getBaseHighLimit() throws UaException {
        PropertyTypeNode node = this.getBaseHighLimitNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setBaseHighLimit(Double value) throws UaException {
        PropertyTypeNode node = this.getBaseHighLimitNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readBaseHighLimit() throws UaException {
        try {
            return this.readBaseHighLimitAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeBaseHighLimit(Double value) throws UaException {
        try {
            this.writeBaseHighLimitAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readBaseHighLimitAsync() {
        return ((CompletableFuture)this.getBaseHighLimitNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeBaseHighLimitAsync(Double baseHighLimit) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)baseHighLimit));
        return this.getBaseHighLimitNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getBaseHighLimitNode() throws UaException {
        try {
            return this.getBaseHighLimitNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getBaseHighLimitNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BaseHighLimit", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getBaseLowLimit() throws UaException {
        PropertyTypeNode node = this.getBaseLowLimitNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setBaseLowLimit(Double value) throws UaException {
        PropertyTypeNode node = this.getBaseLowLimitNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readBaseLowLimit() throws UaException {
        try {
            return this.readBaseLowLimitAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeBaseLowLimit(Double value) throws UaException {
        try {
            this.writeBaseLowLimitAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readBaseLowLimitAsync() {
        return ((CompletableFuture)this.getBaseLowLimitNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeBaseLowLimitAsync(Double baseLowLimit) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)baseLowLimit));
        return this.getBaseLowLimitNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getBaseLowLimitNode() throws UaException {
        try {
            return this.getBaseLowLimitNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getBaseLowLimitNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BaseLowLimit", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getBaseLowLowLimit() throws UaException {
        PropertyTypeNode node = this.getBaseLowLowLimitNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setBaseLowLowLimit(Double value) throws UaException {
        PropertyTypeNode node = this.getBaseLowLowLimitNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readBaseLowLowLimit() throws UaException {
        try {
            return this.readBaseLowLowLimitAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeBaseLowLowLimit(Double value) throws UaException {
        try {
            this.writeBaseLowLowLimitAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readBaseLowLowLimitAsync() {
        return ((CompletableFuture)this.getBaseLowLowLimitNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeBaseLowLowLimitAsync(Double baseLowLowLimit) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)baseLowLowLimit));
        return this.getBaseLowLowLimitNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getBaseLowLowLimitNode() throws UaException {
        try {
            return this.getBaseLowLowLimitNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getBaseLowLowLimitNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BaseLowLowLimit", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getSeverityHighHigh() throws UaException {
        PropertyTypeNode node = this.getSeverityHighHighNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setSeverityHighHigh(UShort value) throws UaException {
        PropertyTypeNode node = this.getSeverityHighHighNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readSeverityHighHigh() throws UaException {
        try {
            return this.readSeverityHighHighAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSeverityHighHigh(UShort value) throws UaException {
        try {
            this.writeSeverityHighHighAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readSeverityHighHighAsync() {
        return ((CompletableFuture)this.getSeverityHighHighNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSeverityHighHighAsync(UShort severityHighHigh) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)severityHighHigh));
        return this.getSeverityHighHighNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSeverityHighHighNode() throws UaException {
        try {
            return this.getSeverityHighHighNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSeverityHighHighNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SeverityHighHigh", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getSeverityHigh() throws UaException {
        PropertyTypeNode node = this.getSeverityHighNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setSeverityHigh(UShort value) throws UaException {
        PropertyTypeNode node = this.getSeverityHighNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readSeverityHigh() throws UaException {
        try {
            return this.readSeverityHighAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSeverityHigh(UShort value) throws UaException {
        try {
            this.writeSeverityHighAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readSeverityHighAsync() {
        return ((CompletableFuture)this.getSeverityHighNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSeverityHighAsync(UShort severityHigh) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)severityHigh));
        return this.getSeverityHighNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSeverityHighNode() throws UaException {
        try {
            return this.getSeverityHighNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSeverityHighNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SeverityHigh", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getSeverityLow() throws UaException {
        PropertyTypeNode node = this.getSeverityLowNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setSeverityLow(UShort value) throws UaException {
        PropertyTypeNode node = this.getSeverityLowNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readSeverityLow() throws UaException {
        try {
            return this.readSeverityLowAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSeverityLow(UShort value) throws UaException {
        try {
            this.writeSeverityLowAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readSeverityLowAsync() {
        return ((CompletableFuture)this.getSeverityLowNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSeverityLowAsync(UShort severityLow) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)severityLow));
        return this.getSeverityLowNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSeverityLowNode() throws UaException {
        try {
            return this.getSeverityLowNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSeverityLowNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SeverityLow", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getSeverityLowLow() throws UaException {
        PropertyTypeNode node = this.getSeverityLowLowNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setSeverityLowLow(UShort value) throws UaException {
        PropertyTypeNode node = this.getSeverityLowLowNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readSeverityLowLow() throws UaException {
        try {
            return this.readSeverityLowLowAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSeverityLowLow(UShort value) throws UaException {
        try {
            this.writeSeverityLowLowAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readSeverityLowLowAsync() {
        return ((CompletableFuture)this.getSeverityLowLowNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSeverityLowLowAsync(UShort severityLowLow) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)severityLowLow));
        return this.getSeverityLowLowNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSeverityLowLowNode() throws UaException {
        try {
            return this.getSeverityLowLowNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSeverityLowLowNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SeverityLowLow", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getHighHighDeadband() throws UaException {
        PropertyTypeNode node = this.getHighHighDeadbandNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setHighHighDeadband(Double value) throws UaException {
        PropertyTypeNode node = this.getHighHighDeadbandNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readHighHighDeadband() throws UaException {
        try {
            return this.readHighHighDeadbandAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeHighHighDeadband(Double value) throws UaException {
        try {
            this.writeHighHighDeadbandAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readHighHighDeadbandAsync() {
        return ((CompletableFuture)this.getHighHighDeadbandNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHighHighDeadbandAsync(Double highHighDeadband) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)highHighDeadband));
        return this.getHighHighDeadbandNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getHighHighDeadbandNode() throws UaException {
        try {
            return this.getHighHighDeadbandNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getHighHighDeadbandNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HighHighDeadband", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getHighDeadband() throws UaException {
        PropertyTypeNode node = this.getHighDeadbandNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setHighDeadband(Double value) throws UaException {
        PropertyTypeNode node = this.getHighDeadbandNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readHighDeadband() throws UaException {
        try {
            return this.readHighDeadbandAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeHighDeadband(Double value) throws UaException {
        try {
            this.writeHighDeadbandAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readHighDeadbandAsync() {
        return ((CompletableFuture)this.getHighDeadbandNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHighDeadbandAsync(Double highDeadband) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)highDeadband));
        return this.getHighDeadbandNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getHighDeadbandNode() throws UaException {
        try {
            return this.getHighDeadbandNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getHighDeadbandNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HighDeadband", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getLowDeadband() throws UaException {
        PropertyTypeNode node = this.getLowDeadbandNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setLowDeadband(Double value) throws UaException {
        PropertyTypeNode node = this.getLowDeadbandNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readLowDeadband() throws UaException {
        try {
            return this.readLowDeadbandAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeLowDeadband(Double value) throws UaException {
        try {
            this.writeLowDeadbandAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readLowDeadbandAsync() {
        return ((CompletableFuture)this.getLowDeadbandNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLowDeadbandAsync(Double lowDeadband) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lowDeadband));
        return this.getLowDeadbandNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLowDeadbandNode() throws UaException {
        try {
            return this.getLowDeadbandNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLowDeadbandNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LowDeadband", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getLowLowDeadband() throws UaException {
        PropertyTypeNode node = this.getLowLowDeadbandNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setLowLowDeadband(Double value) throws UaException {
        PropertyTypeNode node = this.getLowLowDeadbandNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readLowLowDeadband() throws UaException {
        try {
            return this.readLowLowDeadbandAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeLowLowDeadband(Double value) throws UaException {
        try {
            this.writeLowLowDeadbandAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readLowLowDeadbandAsync() {
        return ((CompletableFuture)this.getLowLowDeadbandNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLowLowDeadbandAsync(Double lowLowDeadband) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lowLowDeadband));
        return this.getLowLowDeadbandNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLowLowDeadbandNode() throws UaException {
        try {
            return this.getLowLowDeadbandNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLowLowDeadbandNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LowLowDeadband", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

