/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AggregateConfigurationTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.FolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.HistoricalDataConfigurationType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ExceptionDeviationFormat;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class HistoricalDataConfigurationTypeNode
extends BaseObjectTypeNode
implements HistoricalDataConfigurationType {
    public HistoricalDataConfigurationTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public Boolean getStepped() throws UaException {
        PropertyTypeNode node = this.getSteppedNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setStepped(Boolean value) throws UaException {
        PropertyTypeNode node = this.getSteppedNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readStepped() throws UaException {
        try {
            return this.readSteppedAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeStepped(Boolean value) throws UaException {
        try {
            this.writeSteppedAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readSteppedAsync() {
        return ((CompletableFuture)this.getSteppedNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSteppedAsync(Boolean stepped) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)stepped));
        return this.getSteppedNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSteppedNode() throws UaException {
        try {
            return this.getSteppedNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSteppedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Stepped", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getDefinition() throws UaException {
        PropertyTypeNode node = this.getDefinitionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setDefinition(String value) throws UaException {
        PropertyTypeNode node = this.getDefinitionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readDefinition() throws UaException {
        try {
            return this.readDefinitionAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDefinition(String value) throws UaException {
        try {
            this.writeDefinitionAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readDefinitionAsync() {
        return ((CompletableFuture)this.getDefinitionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDefinitionAsync(String definition) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)definition));
        return this.getDefinitionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDefinitionNode() throws UaException {
        try {
            return this.getDefinitionNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDefinitionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Definition", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getMaxTimeInterval() throws UaException {
        PropertyTypeNode node = this.getMaxTimeIntervalNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxTimeInterval(Double value) throws UaException {
        PropertyTypeNode node = this.getMaxTimeIntervalNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readMaxTimeInterval() throws UaException {
        try {
            return this.readMaxTimeIntervalAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxTimeInterval(Double value) throws UaException {
        try {
            this.writeMaxTimeIntervalAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readMaxTimeIntervalAsync() {
        return ((CompletableFuture)this.getMaxTimeIntervalNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxTimeIntervalAsync(Double maxTimeInterval) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxTimeInterval));
        return this.getMaxTimeIntervalNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxTimeIntervalNode() throws UaException {
        try {
            return this.getMaxTimeIntervalNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxTimeIntervalNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxTimeInterval", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getMinTimeInterval() throws UaException {
        PropertyTypeNode node = this.getMinTimeIntervalNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setMinTimeInterval(Double value) throws UaException {
        PropertyTypeNode node = this.getMinTimeIntervalNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readMinTimeInterval() throws UaException {
        try {
            return this.readMinTimeIntervalAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMinTimeInterval(Double value) throws UaException {
        try {
            this.writeMinTimeIntervalAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readMinTimeIntervalAsync() {
        return ((CompletableFuture)this.getMinTimeIntervalNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMinTimeIntervalAsync(Double minTimeInterval) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)minTimeInterval));
        return this.getMinTimeIntervalNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMinTimeIntervalNode() throws UaException {
        try {
            return this.getMinTimeIntervalNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMinTimeIntervalNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MinTimeInterval", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getExceptionDeviation() throws UaException {
        PropertyTypeNode node = this.getExceptionDeviationNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setExceptionDeviation(Double value) throws UaException {
        PropertyTypeNode node = this.getExceptionDeviationNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readExceptionDeviation() throws UaException {
        try {
            return this.readExceptionDeviationAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeExceptionDeviation(Double value) throws UaException {
        try {
            this.writeExceptionDeviationAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readExceptionDeviationAsync() {
        return ((CompletableFuture)this.getExceptionDeviationNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeExceptionDeviationAsync(Double exceptionDeviation) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)exceptionDeviation));
        return this.getExceptionDeviationNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getExceptionDeviationNode() throws UaException {
        try {
            return this.getExceptionDeviationNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getExceptionDeviationNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ExceptionDeviation", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ExceptionDeviationFormat getExceptionDeviationFormat() throws UaException {
        PropertyTypeNode node = this.getExceptionDeviationFormatNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return ExceptionDeviationFormat.from((int)((Integer)value));
        }
        if (value instanceof ExceptionDeviationFormat) {
            return (ExceptionDeviationFormat)value;
        }
        return null;
    }

    @Override
    public void setExceptionDeviationFormat(ExceptionDeviationFormat value) throws UaException {
        PropertyTypeNode node = this.getExceptionDeviationFormatNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ExceptionDeviationFormat readExceptionDeviationFormat() throws UaException {
        try {
            return this.readExceptionDeviationFormatAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeExceptionDeviationFormat(ExceptionDeviationFormat value) throws UaException {
        try {
            this.writeExceptionDeviationFormatAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends ExceptionDeviationFormat> readExceptionDeviationFormatAsync() {
        return ((CompletableFuture)this.getExceptionDeviationFormatNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return ExceptionDeviationFormat.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeExceptionDeviationFormatAsync(ExceptionDeviationFormat exceptionDeviationFormat) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)exceptionDeviationFormat));
        return this.getExceptionDeviationFormatNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getExceptionDeviationFormatNode() throws UaException {
        try {
            return this.getExceptionDeviationFormatNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getExceptionDeviationFormatNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ExceptionDeviationFormat", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getStartOfArchive() throws UaException {
        PropertyTypeNode node = this.getStartOfArchiveNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setStartOfArchive(DateTime value) throws UaException {
        PropertyTypeNode node = this.getStartOfArchiveNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readStartOfArchive() throws UaException {
        try {
            return this.readStartOfArchiveAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeStartOfArchive(DateTime value) throws UaException {
        try {
            this.writeStartOfArchiveAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readStartOfArchiveAsync() {
        return ((CompletableFuture)this.getStartOfArchiveNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStartOfArchiveAsync(DateTime startOfArchive) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)startOfArchive));
        return this.getStartOfArchiveNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStartOfArchiveNode() throws UaException {
        try {
            return this.getStartOfArchiveNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStartOfArchiveNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StartOfArchive", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getStartOfOnlineArchive() throws UaException {
        PropertyTypeNode node = this.getStartOfOnlineArchiveNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setStartOfOnlineArchive(DateTime value) throws UaException {
        PropertyTypeNode node = this.getStartOfOnlineArchiveNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readStartOfOnlineArchive() throws UaException {
        try {
            return this.readStartOfOnlineArchiveAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeStartOfOnlineArchive(DateTime value) throws UaException {
        try {
            this.writeStartOfOnlineArchiveAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readStartOfOnlineArchiveAsync() {
        return ((CompletableFuture)this.getStartOfOnlineArchiveNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStartOfOnlineArchiveAsync(DateTime startOfOnlineArchive) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)startOfOnlineArchive));
        return this.getStartOfOnlineArchiveNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStartOfOnlineArchiveNode() throws UaException {
        try {
            return this.getStartOfOnlineArchiveNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStartOfOnlineArchiveNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StartOfOnlineArchive", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getServerTimestampSupported() throws UaException {
        PropertyTypeNode node = this.getServerTimestampSupportedNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setServerTimestampSupported(Boolean value) throws UaException {
        PropertyTypeNode node = this.getServerTimestampSupportedNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readServerTimestampSupported() throws UaException {
        try {
            return this.readServerTimestampSupportedAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeServerTimestampSupported(Boolean value) throws UaException {
        try {
            this.writeServerTimestampSupportedAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readServerTimestampSupportedAsync() {
        return ((CompletableFuture)this.getServerTimestampSupportedNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServerTimestampSupportedAsync(Boolean serverTimestampSupported) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serverTimestampSupported));
        return this.getServerTimestampSupportedNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServerTimestampSupportedNode() throws UaException {
        try {
            return this.getServerTimestampSupportedNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServerTimestampSupportedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerTimestampSupported", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getMaxTimeStoredValues() throws UaException {
        PropertyTypeNode node = this.getMaxTimeStoredValuesNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxTimeStoredValues(Double value) throws UaException {
        PropertyTypeNode node = this.getMaxTimeStoredValuesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readMaxTimeStoredValues() throws UaException {
        try {
            return this.readMaxTimeStoredValuesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxTimeStoredValues(Double value) throws UaException {
        try {
            this.writeMaxTimeStoredValuesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readMaxTimeStoredValuesAsync() {
        return ((CompletableFuture)this.getMaxTimeStoredValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxTimeStoredValuesAsync(Double maxTimeStoredValues) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxTimeStoredValues));
        return this.getMaxTimeStoredValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxTimeStoredValuesNode() throws UaException {
        try {
            return this.getMaxTimeStoredValuesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxTimeStoredValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxTimeStoredValues", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxCountStoredValues() throws UaException {
        PropertyTypeNode node = this.getMaxCountStoredValuesNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxCountStoredValues(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxCountStoredValuesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxCountStoredValues() throws UaException {
        try {
            return this.readMaxCountStoredValuesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMaxCountStoredValues(UInteger value) throws UaException {
        try {
            this.writeMaxCountStoredValuesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxCountStoredValuesAsync() {
        return ((CompletableFuture)this.getMaxCountStoredValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxCountStoredValuesAsync(UInteger maxCountStoredValues) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxCountStoredValues));
        return this.getMaxCountStoredValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxCountStoredValuesNode() throws UaException {
        try {
            return this.getMaxCountStoredValuesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxCountStoredValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxCountStoredValues", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public AggregateConfigurationTypeNode getAggregateConfigurationNode() throws UaException {
        try {
            return this.getAggregateConfigurationNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends AggregateConfigurationTypeNode> getAggregateConfigurationNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AggregateConfiguration", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (AggregateConfigurationTypeNode)node);
    }

    @Override
    public FolderTypeNode getAggregateFunctionsNode() throws UaException {
        try {
            return this.getAggregateFunctionsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends FolderTypeNode> getAggregateFunctionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AggregateFunctions", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (FolderTypeNode)node);
    }
}

