/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.ExclusiveDeviationAlarmType;
import org.eclipse.milo.opcua.sdk.client.model.objects.ExclusiveLimitAlarmTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ExclusiveDeviationAlarmTypeNode
extends ExclusiveLimitAlarmTypeNode
implements ExclusiveDeviationAlarmType {
    public ExclusiveDeviationAlarmTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public NodeId getSetpointNode() throws UaException {
        PropertyTypeNode node = this.getSetpointNodeNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setSetpointNode(NodeId value) throws UaException {
        PropertyTypeNode node = this.getSetpointNodeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readSetpointNode() throws UaException {
        try {
            return this.readSetpointNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSetpointNode(NodeId value) throws UaException {
        try {
            this.writeSetpointNodeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readSetpointNodeAsync() {
        return ((CompletableFuture)this.getSetpointNodeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSetpointNodeAsync(NodeId setpointNode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)setpointNode));
        return this.getSetpointNodeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSetpointNodeNode() throws UaException {
        try {
            return this.getSetpointNodeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSetpointNodeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SetpointNode", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId getBaseSetpointNode() throws UaException {
        PropertyTypeNode node = this.getBaseSetpointNodeNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setBaseSetpointNode(NodeId value) throws UaException {
        PropertyTypeNode node = this.getBaseSetpointNodeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readBaseSetpointNode() throws UaException {
        try {
            return this.readBaseSetpointNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeBaseSetpointNode(NodeId value) throws UaException {
        try {
            this.writeBaseSetpointNodeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readBaseSetpointNodeAsync() {
        return ((CompletableFuture)this.getBaseSetpointNodeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeBaseSetpointNodeAsync(NodeId baseSetpointNode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)baseSetpointNode));
        return this.getBaseSetpointNodeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getBaseSetpointNodeNode() throws UaException {
        try {
            return this.getBaseSetpointNodeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getBaseSetpointNodeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BaseSetpointNode", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

