/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.ConditionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.DialogConditionType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.TwoStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class DialogConditionTypeNode
extends ConditionTypeNode
implements DialogConditionType {
    public DialogConditionTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public LocalizedText getPrompt() throws UaException {
        PropertyTypeNode node = this.getPromptNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setPrompt(LocalizedText value) throws UaException {
        PropertyTypeNode node = this.getPromptNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readPrompt() throws UaException {
        try {
            return this.readPromptAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writePrompt(LocalizedText value) throws UaException {
        try {
            this.writePromptAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readPromptAsync() {
        return ((CompletableFuture)this.getPromptNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePromptAsync(LocalizedText prompt) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)prompt));
        return this.getPromptNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPromptNode() throws UaException {
        try {
            return this.getPromptNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPromptNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Prompt", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText[] getResponseOptionSet() throws UaException {
        PropertyTypeNode node = this.getResponseOptionSetNode();
        return (LocalizedText[])node.getValue().getValue().getValue();
    }

    @Override
    public void setResponseOptionSet(LocalizedText[] value) throws UaException {
        PropertyTypeNode node = this.getResponseOptionSetNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText[] readResponseOptionSet() throws UaException {
        try {
            return this.readResponseOptionSetAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeResponseOptionSet(LocalizedText[] value) throws UaException {
        try {
            this.writeResponseOptionSetAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText[]> readResponseOptionSetAsync() {
        return ((CompletableFuture)this.getResponseOptionSetNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeResponseOptionSetAsync(LocalizedText[] responseOptionSet) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)responseOptionSet));
        return this.getResponseOptionSetNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getResponseOptionSetNode() throws UaException {
        try {
            return this.getResponseOptionSetNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getResponseOptionSetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ResponseOptionSet", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Integer getDefaultResponse() throws UaException {
        PropertyTypeNode node = this.getDefaultResponseNode();
        return (Integer)node.getValue().getValue().getValue();
    }

    @Override
    public void setDefaultResponse(Integer value) throws UaException {
        PropertyTypeNode node = this.getDefaultResponseNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Integer readDefaultResponse() throws UaException {
        try {
            return this.readDefaultResponseAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDefaultResponse(Integer value) throws UaException {
        try {
            this.writeDefaultResponseAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Integer> readDefaultResponseAsync() {
        return ((CompletableFuture)this.getDefaultResponseNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Integer)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDefaultResponseAsync(Integer defaultResponse) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)defaultResponse));
        return this.getDefaultResponseNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDefaultResponseNode() throws UaException {
        try {
            return this.getDefaultResponseNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDefaultResponseNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DefaultResponse", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Integer getOkResponse() throws UaException {
        PropertyTypeNode node = this.getOkResponseNode();
        return (Integer)node.getValue().getValue().getValue();
    }

    @Override
    public void setOkResponse(Integer value) throws UaException {
        PropertyTypeNode node = this.getOkResponseNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Integer readOkResponse() throws UaException {
        try {
            return this.readOkResponseAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeOkResponse(Integer value) throws UaException {
        try {
            this.writeOkResponseAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Integer> readOkResponseAsync() {
        return ((CompletableFuture)this.getOkResponseNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Integer)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeOkResponseAsync(Integer okResponse) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)okResponse));
        return this.getOkResponseNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getOkResponseNode() throws UaException {
        try {
            return this.getOkResponseNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getOkResponseNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OkResponse", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Integer getCancelResponse() throws UaException {
        PropertyTypeNode node = this.getCancelResponseNode();
        return (Integer)node.getValue().getValue().getValue();
    }

    @Override
    public void setCancelResponse(Integer value) throws UaException {
        PropertyTypeNode node = this.getCancelResponseNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Integer readCancelResponse() throws UaException {
        try {
            return this.readCancelResponseAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeCancelResponse(Integer value) throws UaException {
        try {
            this.writeCancelResponseAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Integer> readCancelResponseAsync() {
        return ((CompletableFuture)this.getCancelResponseNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Integer)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCancelResponseAsync(Integer cancelResponse) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)cancelResponse));
        return this.getCancelResponseNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getCancelResponseNode() throws UaException {
        try {
            return this.getCancelResponseNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getCancelResponseNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CancelResponse", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Integer getLastResponse() throws UaException {
        PropertyTypeNode node = this.getLastResponseNode();
        return (Integer)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastResponse(Integer value) throws UaException {
        PropertyTypeNode node = this.getLastResponseNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Integer readLastResponse() throws UaException {
        try {
            return this.readLastResponseAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeLastResponse(Integer value) throws UaException {
        try {
            this.writeLastResponseAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Integer> readLastResponseAsync() {
        return ((CompletableFuture)this.getLastResponseNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Integer)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastResponseAsync(Integer lastResponse) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastResponse));
        return this.getLastResponseNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLastResponseNode() throws UaException {
        try {
            return this.getLastResponseNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLastResponseNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastResponse", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getEnabledState() throws UaException {
        TwoStateVariableTypeNode node = this.getEnabledStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setEnabledState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getEnabledStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readEnabledState() throws UaException {
        try {
            return this.readEnabledStateAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeEnabledState(LocalizedText value) throws UaException {
        try {
            this.writeEnabledStateAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readEnabledStateAsync() {
        return ((CompletableFuture)this.getEnabledStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEnabledStateAsync(LocalizedText enabledState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)enabledState));
        return this.getEnabledStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getEnabledStateNode() throws UaException {
        try {
            return this.getEnabledStateNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends TwoStateVariableTypeNode> getEnabledStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EnabledState", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getDialogState() throws UaException {
        TwoStateVariableTypeNode node = this.getDialogStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setDialogState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getDialogStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readDialogState() throws UaException {
        try {
            return this.readDialogStateAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDialogState(LocalizedText value) throws UaException {
        try {
            this.writeDialogStateAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readDialogStateAsync() {
        return ((CompletableFuture)this.getDialogStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDialogStateAsync(LocalizedText dialogState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dialogState));
        return this.getDialogStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getDialogStateNode() throws UaException {
        try {
            return this.getDialogStateNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getDialogStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DialogState", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }
}

