/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.DataSetWriterMessageTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.DataSetWriterTransportTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.DataSetWriterType;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubDiagnosticsDataSetWriterTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubStatusTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.DataSetFieldContentMask;
import org.eclipse.milo.opcua.stack.core.types.structured.KeyValuePair;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class DataSetWriterTypeNode
extends BaseObjectTypeNode
implements DataSetWriterType {
    public DataSetWriterTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UShort getDataSetWriterId() throws UaException {
        PropertyTypeNode node = this.getDataSetWriterIdNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setDataSetWriterId(UShort value) throws UaException {
        PropertyTypeNode node = this.getDataSetWriterIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readDataSetWriterId() throws UaException {
        try {
            return this.readDataSetWriterIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDataSetWriterId(UShort value) throws UaException {
        try {
            this.writeDataSetWriterIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readDataSetWriterIdAsync() {
        return ((CompletableFuture)this.getDataSetWriterIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetWriterIdAsync(UShort dataSetWriterId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataSetWriterId));
        return this.getDataSetWriterIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetWriterIdNode() throws UaException {
        try {
            return this.getDataSetWriterIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetWriterIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetWriterId", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DataSetFieldContentMask getDataSetFieldContentMask() throws UaException {
        PropertyTypeNode node = this.getDataSetFieldContentMaskNode();
        return (DataSetFieldContentMask)node.getValue().getValue().getValue();
    }

    @Override
    public void setDataSetFieldContentMask(DataSetFieldContentMask value) throws UaException {
        PropertyTypeNode node = this.getDataSetFieldContentMaskNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DataSetFieldContentMask readDataSetFieldContentMask() throws UaException {
        try {
            return this.readDataSetFieldContentMaskAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDataSetFieldContentMask(DataSetFieldContentMask value) throws UaException {
        try {
            this.writeDataSetFieldContentMaskAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DataSetFieldContentMask> readDataSetFieldContentMaskAsync() {
        return ((CompletableFuture)this.getDataSetFieldContentMaskNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DataSetFieldContentMask)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetFieldContentMaskAsync(DataSetFieldContentMask dataSetFieldContentMask) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataSetFieldContentMask));
        return this.getDataSetFieldContentMaskNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetFieldContentMaskNode() throws UaException {
        try {
            return this.getDataSetFieldContentMaskNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetFieldContentMaskNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetFieldContentMask", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getKeyFrameCount() throws UaException {
        PropertyTypeNode node = this.getKeyFrameCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setKeyFrameCount(UInteger value) throws UaException {
        PropertyTypeNode node = this.getKeyFrameCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readKeyFrameCount() throws UaException {
        try {
            return this.readKeyFrameCountAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeKeyFrameCount(UInteger value) throws UaException {
        try {
            this.writeKeyFrameCountAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readKeyFrameCountAsync() {
        return ((CompletableFuture)this.getKeyFrameCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeKeyFrameCountAsync(UInteger keyFrameCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)keyFrameCount));
        return this.getKeyFrameCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getKeyFrameCountNode() throws UaException {
        try {
            return this.getKeyFrameCountNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getKeyFrameCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "KeyFrameCount", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public KeyValuePair[] getDataSetWriterProperties() throws UaException {
        PropertyTypeNode node = this.getDataSetWriterPropertiesNode();
        return this.cast(node.getValue().getValue().getValue(), KeyValuePair[].class);
    }

    @Override
    public void setDataSetWriterProperties(KeyValuePair[] value) throws UaException {
        PropertyTypeNode node = this.getDataSetWriterPropertiesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public KeyValuePair[] readDataSetWriterProperties() throws UaException {
        try {
            return this.readDataSetWriterPropertiesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDataSetWriterProperties(KeyValuePair[] value) throws UaException {
        try {
            this.writeDataSetWriterPropertiesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends KeyValuePair[]> readDataSetWriterPropertiesAsync() {
        return ((CompletableFuture)this.getDataSetWriterPropertiesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), KeyValuePair[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetWriterPropertiesAsync(KeyValuePair[] dataSetWriterProperties) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])dataSetWriterProperties);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDataSetWriterPropertiesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetWriterPropertiesNode() throws UaException {
        try {
            return this.getDataSetWriterPropertiesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetWriterPropertiesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetWriterProperties", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DataSetWriterTransportTypeNode getTransportSettingsNode() throws UaException {
        try {
            return this.getTransportSettingsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends DataSetWriterTransportTypeNode> getTransportSettingsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransportSettings", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (DataSetWriterTransportTypeNode)node);
    }

    @Override
    public DataSetWriterMessageTypeNode getMessageSettingsNode() throws UaException {
        try {
            return this.getMessageSettingsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends DataSetWriterMessageTypeNode> getMessageSettingsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MessageSettings", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (DataSetWriterMessageTypeNode)node);
    }

    @Override
    public PubSubStatusTypeNode getStatusNode() throws UaException {
        try {
            return this.getStatusNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PubSubStatusTypeNode> getStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Status", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (PubSubStatusTypeNode)node);
    }

    @Override
    public PubSubDiagnosticsDataSetWriterTypeNode getDiagnosticsNode() throws UaException {
        try {
            return this.getDiagnosticsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PubSubDiagnosticsDataSetWriterTypeNode> getDiagnosticsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Diagnostics", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (PubSubDiagnosticsDataSetWriterTypeNode)node);
    }
}

