/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.DataSetReaderMessageTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.DataSetReaderTransportTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.DataSetReaderType;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubDiagnosticsDataSetReaderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubStatusTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.SubscribedDataSetTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.DataSetFieldContentMask;
import org.eclipse.milo.opcua.stack.core.types.structured.DataSetMetaDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.KeyValuePair;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class DataSetReaderTypeNode
extends BaseObjectTypeNode
implements DataSetReaderType {
    public DataSetReaderTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public Object getPublisherId() throws UaException {
        PropertyTypeNode node = this.getPublisherIdNode();
        return node.getValue().getValue().getValue();
    }

    @Override
    public void setPublisherId(Object value) throws UaException {
        PropertyTypeNode node = this.getPublisherIdNode();
        node.setValue(new Variant(value));
    }

    @Override
    public Object readPublisherId() throws UaException {
        try {
            return this.readPublisherIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writePublisherId(Object value) throws UaException {
        try {
            this.writePublisherIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<?> readPublisherIdAsync() {
        return ((CompletableFuture)this.getPublisherIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePublisherIdAsync(Object publisherId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant(publisherId));
        return this.getPublisherIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPublisherIdNode() throws UaException {
        try {
            return this.getPublisherIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPublisherIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PublisherId", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getWriterGroupId() throws UaException {
        PropertyTypeNode node = this.getWriterGroupIdNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setWriterGroupId(UShort value) throws UaException {
        PropertyTypeNode node = this.getWriterGroupIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readWriterGroupId() throws UaException {
        try {
            return this.readWriterGroupIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeWriterGroupId(UShort value) throws UaException {
        try {
            this.writeWriterGroupIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readWriterGroupIdAsync() {
        return ((CompletableFuture)this.getWriterGroupIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeWriterGroupIdAsync(UShort writerGroupId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)writerGroupId));
        return this.getWriterGroupIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getWriterGroupIdNode() throws UaException {
        try {
            return this.getWriterGroupIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getWriterGroupIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "WriterGroupId", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getDataSetWriterId() throws UaException {
        PropertyTypeNode node = this.getDataSetWriterIdNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setDataSetWriterId(UShort value) throws UaException {
        PropertyTypeNode node = this.getDataSetWriterIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readDataSetWriterId() throws UaException {
        try {
            return this.readDataSetWriterIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDataSetWriterId(UShort value) throws UaException {
        try {
            this.writeDataSetWriterIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readDataSetWriterIdAsync() {
        return ((CompletableFuture)this.getDataSetWriterIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetWriterIdAsync(UShort dataSetWriterId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataSetWriterId));
        return this.getDataSetWriterIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetWriterIdNode() throws UaException {
        try {
            return this.getDataSetWriterIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetWriterIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetWriterId", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DataSetMetaDataType getDataSetMetaData() throws UaException {
        PropertyTypeNode node = this.getDataSetMetaDataNode();
        return this.cast(node.getValue().getValue().getValue(), DataSetMetaDataType.class);
    }

    @Override
    public void setDataSetMetaData(DataSetMetaDataType value) throws UaException {
        PropertyTypeNode node = this.getDataSetMetaDataNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public DataSetMetaDataType readDataSetMetaData() throws UaException {
        try {
            return this.readDataSetMetaDataAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDataSetMetaData(DataSetMetaDataType value) throws UaException {
        try {
            this.writeDataSetMetaDataAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DataSetMetaDataType> readDataSetMetaDataAsync() {
        return ((CompletableFuture)this.getDataSetMetaDataNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), DataSetMetaDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetMetaDataAsync(DataSetMetaDataType dataSetMetaData) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)dataSetMetaData);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDataSetMetaDataNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetMetaDataNode() throws UaException {
        try {
            return this.getDataSetMetaDataNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetMetaDataNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetMetaData", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DataSetFieldContentMask getDataSetFieldContentMask() throws UaException {
        PropertyTypeNode node = this.getDataSetFieldContentMaskNode();
        return (DataSetFieldContentMask)node.getValue().getValue().getValue();
    }

    @Override
    public void setDataSetFieldContentMask(DataSetFieldContentMask value) throws UaException {
        PropertyTypeNode node = this.getDataSetFieldContentMaskNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DataSetFieldContentMask readDataSetFieldContentMask() throws UaException {
        try {
            return this.readDataSetFieldContentMaskAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDataSetFieldContentMask(DataSetFieldContentMask value) throws UaException {
        try {
            this.writeDataSetFieldContentMaskAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends DataSetFieldContentMask> readDataSetFieldContentMaskAsync() {
        return ((CompletableFuture)this.getDataSetFieldContentMaskNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DataSetFieldContentMask)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetFieldContentMaskAsync(DataSetFieldContentMask dataSetFieldContentMask) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataSetFieldContentMask));
        return this.getDataSetFieldContentMaskNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetFieldContentMaskNode() throws UaException {
        try {
            return this.getDataSetFieldContentMaskNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetFieldContentMaskNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetFieldContentMask", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getMessageReceiveTimeout() throws UaException {
        PropertyTypeNode node = this.getMessageReceiveTimeoutNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setMessageReceiveTimeout(Double value) throws UaException {
        PropertyTypeNode node = this.getMessageReceiveTimeoutNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readMessageReceiveTimeout() throws UaException {
        try {
            return this.readMessageReceiveTimeoutAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeMessageReceiveTimeout(Double value) throws UaException {
        try {
            this.writeMessageReceiveTimeoutAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends Double> readMessageReceiveTimeoutAsync() {
        return ((CompletableFuture)this.getMessageReceiveTimeoutNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMessageReceiveTimeoutAsync(Double messageReceiveTimeout) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)messageReceiveTimeout));
        return this.getMessageReceiveTimeoutNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMessageReceiveTimeoutNode() throws UaException {
        try {
            return this.getMessageReceiveTimeoutNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMessageReceiveTimeoutNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MessageReceiveTimeout", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getKeyFrameCount() throws UaException {
        PropertyTypeNode node = this.getKeyFrameCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setKeyFrameCount(UInteger value) throws UaException {
        PropertyTypeNode node = this.getKeyFrameCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readKeyFrameCount() throws UaException {
        try {
            return this.readKeyFrameCountAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeKeyFrameCount(UInteger value) throws UaException {
        try {
            this.writeKeyFrameCountAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readKeyFrameCountAsync() {
        return ((CompletableFuture)this.getKeyFrameCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeKeyFrameCountAsync(UInteger keyFrameCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)keyFrameCount));
        return this.getKeyFrameCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getKeyFrameCountNode() throws UaException {
        try {
            return this.getKeyFrameCountNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getKeyFrameCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "KeyFrameCount", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getHeaderLayoutUri() throws UaException {
        PropertyTypeNode node = this.getHeaderLayoutUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setHeaderLayoutUri(String value) throws UaException {
        PropertyTypeNode node = this.getHeaderLayoutUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readHeaderLayoutUri() throws UaException {
        try {
            return this.readHeaderLayoutUriAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeHeaderLayoutUri(String value) throws UaException {
        try {
            this.writeHeaderLayoutUriAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readHeaderLayoutUriAsync() {
        return ((CompletableFuture)this.getHeaderLayoutUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHeaderLayoutUriAsync(String headerLayoutUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)headerLayoutUri));
        return this.getHeaderLayoutUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getHeaderLayoutUriNode() throws UaException {
        try {
            return this.getHeaderLayoutUriNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getHeaderLayoutUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HeaderLayoutUri", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public MessageSecurityMode getSecurityMode() throws UaException {
        PropertyTypeNode node = this.getSecurityModeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return MessageSecurityMode.from((int)((Integer)value));
        }
        if (value instanceof MessageSecurityMode) {
            return (MessageSecurityMode)value;
        }
        return null;
    }

    @Override
    public void setSecurityMode(MessageSecurityMode value) throws UaException {
        PropertyTypeNode node = this.getSecurityModeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public MessageSecurityMode readSecurityMode() throws UaException {
        try {
            return this.readSecurityModeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSecurityMode(MessageSecurityMode value) throws UaException {
        try {
            this.writeSecurityModeAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends MessageSecurityMode> readSecurityModeAsync() {
        return ((CompletableFuture)this.getSecurityModeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return MessageSecurityMode.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityModeAsync(MessageSecurityMode securityMode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityMode));
        return this.getSecurityModeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecurityModeNode() throws UaException {
        try {
            return this.getSecurityModeNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecurityModeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityMode", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getSecurityGroupId() throws UaException {
        PropertyTypeNode node = this.getSecurityGroupIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSecurityGroupId(String value) throws UaException {
        PropertyTypeNode node = this.getSecurityGroupIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readSecurityGroupId() throws UaException {
        try {
            return this.readSecurityGroupIdAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSecurityGroupId(String value) throws UaException {
        try {
            this.writeSecurityGroupIdAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends String> readSecurityGroupIdAsync() {
        return ((CompletableFuture)this.getSecurityGroupIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityGroupIdAsync(String securityGroupId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityGroupId));
        return this.getSecurityGroupIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecurityGroupIdNode() throws UaException {
        try {
            return this.getSecurityGroupIdNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecurityGroupIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityGroupId", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public EndpointDescription[] getSecurityKeyServices() throws UaException {
        PropertyTypeNode node = this.getSecurityKeyServicesNode();
        return this.cast(node.getValue().getValue().getValue(), EndpointDescription[].class);
    }

    @Override
    public void setSecurityKeyServices(EndpointDescription[] value) throws UaException {
        PropertyTypeNode node = this.getSecurityKeyServicesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public EndpointDescription[] readSecurityKeyServices() throws UaException {
        try {
            return this.readSecurityKeyServicesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeSecurityKeyServices(EndpointDescription[] value) throws UaException {
        try {
            this.writeSecurityKeyServicesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends EndpointDescription[]> readSecurityKeyServicesAsync() {
        return ((CompletableFuture)this.getSecurityKeyServicesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), EndpointDescription[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityKeyServicesAsync(EndpointDescription[] securityKeyServices) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])securityKeyServices);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getSecurityKeyServicesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecurityKeyServicesNode() throws UaException {
        try {
            return this.getSecurityKeyServicesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecurityKeyServicesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityKeyServices", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public KeyValuePair[] getDataSetReaderProperties() throws UaException {
        PropertyTypeNode node = this.getDataSetReaderPropertiesNode();
        return this.cast(node.getValue().getValue().getValue(), KeyValuePair[].class);
    }

    @Override
    public void setDataSetReaderProperties(KeyValuePair[] value) throws UaException {
        PropertyTypeNode node = this.getDataSetReaderPropertiesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public KeyValuePair[] readDataSetReaderProperties() throws UaException {
        try {
            return this.readDataSetReaderPropertiesAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public void writeDataSetReaderProperties(KeyValuePair[] value) throws UaException {
        try {
            this.writeDataSetReaderPropertiesAsync(value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<? extends KeyValuePair[]> readDataSetReaderPropertiesAsync() {
        return ((CompletableFuture)this.getDataSetReaderPropertiesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), KeyValuePair[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetReaderPropertiesAsync(KeyValuePair[] dataSetReaderProperties) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])dataSetReaderProperties);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDataSetReaderPropertiesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetReaderPropertiesNode() throws UaException {
        try {
            return this.getDataSetReaderPropertiesNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetReaderPropertiesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetReaderProperties", ExpandedNodeId.parse((String)"i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DataSetReaderTransportTypeNode getTransportSettingsNode() throws UaException {
        try {
            return this.getTransportSettingsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends DataSetReaderTransportTypeNode> getTransportSettingsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransportSettings", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (DataSetReaderTransportTypeNode)node);
    }

    @Override
    public DataSetReaderMessageTypeNode getMessageSettingsNode() throws UaException {
        try {
            return this.getMessageSettingsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends DataSetReaderMessageTypeNode> getMessageSettingsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MessageSettings", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (DataSetReaderMessageTypeNode)node);
    }

    @Override
    public PubSubStatusTypeNode getStatusNode() throws UaException {
        try {
            return this.getStatusNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PubSubStatusTypeNode> getStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Status", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (PubSubStatusTypeNode)node);
    }

    @Override
    public PubSubDiagnosticsDataSetReaderTypeNode getDiagnosticsNode() throws UaException {
        try {
            return this.getDiagnosticsNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends PubSubDiagnosticsDataSetReaderTypeNode> getDiagnosticsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Diagnostics", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (PubSubDiagnosticsDataSetReaderTypeNode)node);
    }

    @Override
    public SubscribedDataSetTypeNode getSubscribedDataSetNode() throws UaException {
        try {
            return this.getSubscribedDataSetNodeAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<? extends SubscribedDataSetTypeNode> getSubscribedDataSetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SubscribedDataSet", ExpandedNodeId.parse((String)"i=47"), false);
        return future.thenApply(node -> (SubscribedDataSetTypeNode)node);
    }
}

