/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.milo.opcua.sdk.client.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.sdk.client.identity.IdentityProvider;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.security.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

public interface OpcUaClientConfig {
    public EndpointDescription getEndpoint();

    public List<EndpointDescription> getDiscoveryEndpoints();

    public Optional<KeyPair> getKeyPair();

    public Optional<X509Certificate> getCertificate();

    public Optional<X509Certificate[]> getCertificateChain();

    public CertificateValidator getCertificateValidator();

    public LocalizedText getApplicationName();

    public String getApplicationUri();

    public String getProductUri();

    public Supplier<String> getSessionName();

    public String[] getSessionLocaleIds();

    public UInteger getSessionTimeout();

    public UInteger getRequestTimeout();

    public EncodingLimits getEncodingLimits();

    public UInteger getMaxResponseMessageSize();

    public UInteger getMaxPendingPublishRequests();

    public IdentityProvider getIdentityProvider();

    public UInteger getKeepAliveFailuresAllowed();

    public UInteger getKeepAliveInterval();

    public UInteger getKeepAliveTimeout();

    public boolean isSessionEndpointValidationEnabled();

    public static OpcUaClientConfigBuilder builder() {
        return new OpcUaClientConfigBuilder();
    }

    public static OpcUaClientConfigBuilder copy(OpcUaClientConfig config) {
        OpcUaClientConfigBuilder builder = new OpcUaClientConfigBuilder();
        builder.setEndpoint(config.getEndpoint());
        config.getKeyPair().ifPresent(builder::setKeyPair);
        builder.setDiscoveryEndpoints(new ArrayList<EndpointDescription>(config.getDiscoveryEndpoints()));
        config.getCertificate().ifPresent(builder::setCertificate);
        config.getCertificateChain().ifPresent(builder::setCertificateChain);
        builder.setApplicationName(config.getApplicationName());
        builder.setApplicationUri(config.getApplicationUri());
        builder.setProductUri(config.getProductUri());
        builder.setSessionName(config.getSessionName());
        builder.setSessionTimeout(config.getSessionTimeout());
        builder.setRequestTimeout(config.getRequestTimeout());
        builder.setMaxResponseMessageSize(config.getMaxResponseMessageSize());
        builder.setMaxPendingPublishRequests(config.getMaxPendingPublishRequests());
        builder.setIdentityProvider(config.getIdentityProvider());
        builder.setKeepAliveFailuresAllowed(config.getKeepAliveFailuresAllowed());
        builder.setKeepAliveInterval(config.getKeepAliveInterval());
        builder.setKeepAliveTimeout(config.getKeepAliveTimeout());
        builder.setSessionLocaleIds(config.getSessionLocaleIds());
        builder.setSessionEndpointValidationEnabled(config.isSessionEndpointValidationEnabled());
        return builder;
    }

    public static OpcUaClientConfig copy(OpcUaClientConfig config, Consumer<OpcUaClientConfigBuilder> consumer) {
        OpcUaClientConfigBuilder builder = OpcUaClientConfig.copy(config);
        consumer.accept(builder);
        return builder.build();
    }
}

