/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.client.AddressSpace;
import org.eclipse.milo.opcua.sdk.client.CodecFactory;
import org.eclipse.milo.opcua.sdk.client.DiscoveryClient;
import org.eclipse.milo.opcua.sdk.client.ObjectTypeManager;
import org.eclipse.milo.opcua.sdk.client.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.OperationLimits;
import org.eclipse.milo.opcua.sdk.client.ServiceFaultListener;
import org.eclipse.milo.opcua.sdk.client.SessionActivityListener;
import org.eclipse.milo.opcua.sdk.client.VariableTypeManager;
import org.eclipse.milo.opcua.sdk.client.model.ObjectTypeInitializer;
import org.eclipse.milo.opcua.sdk.client.model.VariableTypeInitializer;
import org.eclipse.milo.opcua.sdk.client.session.SessionFsm;
import org.eclipse.milo.opcua.sdk.client.session.SessionFsmFactory;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaSubscription;
import org.eclipse.milo.opcua.sdk.client.subscriptions.PublishingManager;
import org.eclipse.milo.opcua.sdk.client.typetree.DataTypeTreeBuilder;
import org.eclipse.milo.opcua.sdk.client.typetree.ObjectTypeTreeBuilder;
import org.eclipse.milo.opcua.sdk.client.typetree.VariableTypeTreeBuilder;
import org.eclipse.milo.opcua.sdk.core.types.codec.DynamicCodecFactory;
import org.eclipse.milo.opcua.sdk.core.typetree.DataType;
import org.eclipse.milo.opcua.sdk.core.typetree.DataTypeTree;
import org.eclipse.milo.opcua.sdk.core.typetree.ObjectTypeTree;
import org.eclipse.milo.opcua.sdk.core.typetree.VariableTypeTree;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.ServerTable;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.UaServiceFaultException;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.encoding.DefaultEncodingManager;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingManager;
import org.eclipse.milo.opcua.stack.core.security.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.DefaultDataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.UaResponseMessageType;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UNumber;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.NodeTypeDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryFirstRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryFirstResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionAcknowledgement;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.eclipse.milo.opcua.stack.core.util.ExecutionQueue;
import org.eclipse.milo.opcua.stack.core.util.Lazy;
import org.eclipse.milo.opcua.stack.core.util.Lists;
import org.eclipse.milo.opcua.stack.core.util.LongSequence;
import org.eclipse.milo.opcua.stack.core.util.ManifestUtil;
import org.eclipse.milo.opcua.stack.core.util.Tree;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.eclipse.milo.opcua.stack.transport.client.ClientApplicationContext;
import org.eclipse.milo.opcua.stack.transport.client.OpcClientTransport;
import org.eclipse.milo.opcua.stack.transport.client.tcp.OpcTcpClientTransport;
import org.eclipse.milo.opcua.stack.transport.client.tcp.OpcTcpClientTransportConfig;
import org.eclipse.milo.opcua.stack.transport.client.tcp.OpcTcpClientTransportConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaClient {
    public static final String SDK_VERSION = ManifestUtil.read((String)"X-SDK-Version").orElse("dev");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LongSequence requestHandles = new LongSequence(0L, 0xFFFFFFFFL);
    private final List<ServiceFaultListener> faultListeners = new CopyOnWriteArrayList<ServiceFaultListener>();
    private final ExecutionQueue faultNotificationQueue;
    private final AddressSpace addressSpace;
    private final NamespaceTable namespaceTable = new NamespaceTable();
    private final ServerTable serverTable = new ServerTable();
    private final Lazy<OperationLimits> operationLimits = new Lazy();
    private final ObjectTypeManager objectTypeManager = new ObjectTypeManager();
    private final VariableTypeManager variableTypeManager = new VariableTypeManager();
    private DataTypeManagerInitializer dataTypeManagerInitializer = new DefaultDataTypeManagerInitializer();
    private final EncodingManager encodingManager = DefaultEncodingManager.createAndInitialize();
    private final DataTypeManager staticDataTypeManager = DefaultDataTypeManager.createAndInitialize((NamespaceTable)this.namespaceTable);
    private final EncodingContext staticEncodingContext;
    private final Lazy<DataTypeManager> dynamicDataTypeManager = new Lazy();
    private final Lazy<EncodingContext> dynamicEncodingContext = new Lazy();
    private final Lazy<DataTypeTree> dataTypeTree = new Lazy();
    private final Lazy<ObjectTypeTree> objectTypeTree = new Lazy();
    private final Lazy<VariableTypeTree> variableTypeTree = new Lazy();
    private final PublishingManager publishingManager;
    private final Map<UInteger, OpcUaSubscription> subscriptions = new ConcurrentHashMap<UInteger, OpcUaSubscription>();
    private final SessionFsm sessionFsm;
    private final ClientApplicationContext applicationContext;
    private final OpcUaClientConfig config;
    private final OpcClientTransport transport;

    public static OpcUaClient create(OpcUaClientConfig config) throws UaException {
        OpcTcpClientTransportConfig transportConfig = OpcTcpClientTransportConfig.newBuilder().build();
        OpcTcpClientTransport transport = new OpcTcpClientTransport(transportConfig);
        return new OpcUaClient(config, (OpcClientTransport)transport);
    }

    public static OpcUaClient create(OpcUaClientConfig config, Consumer<OpcTcpClientTransportConfigBuilder> configureTransport) throws UaException {
        OpcTcpClientTransportConfigBuilder transportConfigBuilder = OpcTcpClientTransportConfig.newBuilder();
        configureTransport.accept(transportConfigBuilder);
        OpcTcpClientTransportConfig transportConfig = transportConfigBuilder.build();
        return new OpcUaClient(config, (OpcClientTransport)new OpcTcpClientTransport(transportConfig));
    }

    public static OpcUaClient create(String endpointUrl) throws UaException {
        Predicate<EndpointDescription> predicate = e -> SecurityPolicy.None.getUri().equals(e.getSecurityPolicyUri()) && Stream.of(Objects.requireNonNullElse(e.getUserIdentityTokens(), new UserTokenPolicy[0])).anyMatch(p -> p.getTokenType() == UserTokenType.Anonymous);
        return OpcUaClient.create(endpointUrl, endpoints -> endpoints.stream().filter(predicate).findFirst(), b -> {}, b -> {});
    }

    public static OpcUaClient create(String endpointUrl, Function<List<EndpointDescription>, Optional<EndpointDescription>> selectEndpoint, Consumer<OpcTcpClientTransportConfigBuilder> configureTransport, Consumer<OpcUaClientConfigBuilder> configureClient) throws UaException {
        try {
            List<EndpointDescription> endpoints = DiscoveryClient.getEndpoints(endpointUrl, configureTransport).get();
            EndpointDescription endpoint = selectEndpoint.apply(endpoints).orElseThrow(() -> new UaException(0x80890000L, "no endpoint selected"));
            OpcTcpClientTransportConfigBuilder transportConfigBuilder = OpcTcpClientTransportConfig.newBuilder();
            configureTransport.accept(transportConfigBuilder);
            OpcUaClientConfigBuilder clientConfigBuilder = OpcUaClientConfig.builder();
            clientConfigBuilder.setEndpoint(endpoint);
            clientConfigBuilder.setDiscoveryEndpoints(endpoints);
            clientConfigBuilder.setSessionEndpointValidationEnabled(false);
            configureClient.accept(clientConfigBuilder);
            OpcUaClientConfig clientConfig = clientConfigBuilder.build();
            OpcTcpClientTransport transport = new OpcTcpClientTransport(transportConfigBuilder.build());
            return new OpcUaClient(clientConfig, (OpcClientTransport)transport);
        }
        catch (ExecutionException e) {
            if (!endpointUrl.endsWith("/discovery")) {
                StringBuilder discoveryUrl = new StringBuilder(endpointUrl);
                if (!endpointUrl.endsWith("/")) {
                    discoveryUrl.append("/");
                }
                discoveryUrl.append("discovery");
                return OpcUaClient.create(discoveryUrl.toString(), selectEndpoint, configureTransport, configureClient);
            }
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public OpcUaClient(final OpcUaClientConfig config, OpcClientTransport transport) {
        this.config = config;
        this.transport = transport;
        this.staticEncodingContext = new EncodingContext(){

            public DataTypeManager getDataTypeManager() {
                return OpcUaClient.this.staticDataTypeManager;
            }

            public EncodingManager getEncodingManager() {
                return OpcUaClient.this.encodingManager;
            }

            public EncodingLimits getEncodingLimits() {
                return config.getEncodingLimits();
            }

            public NamespaceTable getNamespaceTable() {
                return OpcUaClient.this.namespaceTable;
            }

            public ServerTable getServerTable() {
                return OpcUaClient.this.serverTable;
            }
        };
        this.applicationContext = new ClientApplicationContext(){

            public EndpointDescription getEndpoint() {
                return config.getEndpoint();
            }

            public Optional<KeyPair> getKeyPair() {
                return config.getKeyPair();
            }

            public Optional<X509Certificate> getCertificate() {
                return config.getCertificate();
            }

            public Optional<X509Certificate[]> getCertificateChain() {
                return config.getCertificateChain();
            }

            public CertificateValidator getCertificateValidator() {
                return config.getCertificateValidator();
            }

            public EncodingContext getEncodingContext() {
                return OpcUaClient.this.staticEncodingContext;
            }

            public UInteger getRequestTimeout() {
                return config.getRequestTimeout();
            }
        };
        this.sessionFsm = SessionFsmFactory.newSessionFsm(this);
        this.sessionFsm.addInitializer((client, session) -> {
            this.logger.debug("SessionInitializer: NamespaceTable and ServerTable");
            RequestHeader requestHeader = this.newRequestHeader(session.getAuthenticationToken());
            ReadRequest readRequest = new ReadRequest(requestHeader, Double.valueOf(0.0), TimestampsToReturn.Neither, new ReadValueId[]{new ReadValueId(NodeIds.Server_NamespaceArray, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE), new ReadValueId(NodeIds.Server_ServerArray, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE)});
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)client.sendRequestAsync((UaRequestMessageType)readRequest).thenApply(ReadResponse.class::cast)).thenApply(response -> Objects.requireNonNull(response.getResults()))).thenApply(results -> {
                String[] namespaceArray = (String[])results[0].value().value();
                String[] serverArray = (String[])results[1].value().value();
                if (namespaceArray != null) {
                    this.updateNamespaceTable(namespaceArray);
                }
                if (serverArray != null) {
                    this.updateServerTable(serverArray);
                }
                return Unit.VALUE;
            })).exceptionally(ex -> {
                this.logger.warn("SessionInitializer: NamespaceTable", ex);
                return Unit.VALUE;
            });
        });
        this.faultNotificationQueue = new ExecutionQueue((Executor)transport.getConfig().getExecutor());
        this.addressSpace = new AddressSpace(this);
        this.publishingManager = new PublishingManager(this);
        ObjectTypeInitializer.initialize(this.namespaceTable, this.objectTypeManager);
        VariableTypeInitializer.initialize(this.namespaceTable, this.variableTypeManager);
    }

    public OpcUaClient connect() throws UaException {
        try {
            return this.connectAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<OpcUaClient> connectAsync() {
        return ((CompletableFuture)((CompletableFuture)this.transport.connect(this.applicationContext).handle((u, ex) -> this.sessionFsm.openSession())).thenCompose(Function.identity())).thenApply(s -> this);
    }

    public OpcUaClient disconnect() throws UaException {
        try {
            return this.disconnectAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<OpcUaClient> disconnectAsync() {
        return ((CompletableFuture)((CompletableFuture)this.sessionFsm.closeSession().exceptionally(ex -> Unit.VALUE)).thenCompose(u -> this.transport.disconnect().thenApply(c -> this))).exceptionally(ex -> this);
    }

    public OpcUaSession getSession() throws UaException {
        try {
            return this.getSessionAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<OpcUaSession> getSessionAsync() {
        return this.sessionFsm.getSession();
    }

    public SessionFsm getSessionFsm() {
        return this.sessionFsm;
    }

    public OpcUaClientConfig getConfig() {
        return this.config;
    }

    public OpcClientTransport getTransport() {
        return this.transport;
    }

    public AddressSpace getAddressSpace() {
        return this.addressSpace;
    }

    public ObjectTypeManager getObjectTypeManager() {
        return this.objectTypeManager;
    }

    public VariableTypeManager getVariableTypeManager() {
        return this.variableTypeManager;
    }

    public void addSubscription(OpcUaSubscription subscription) {
        subscription.getSubscriptionId().ifPresent(id -> this.subscriptions.put((UInteger)id, subscription));
    }

    public void removeSubscription(OpcUaSubscription subscription) {
        subscription.getSubscriptionId().ifPresent(this.subscriptions::remove);
    }

    public List<OpcUaSubscription> getSubscriptions() {
        return List.copyOf(this.subscriptions.values());
    }

    public PublishingManager getPublishingManager() {
        return this.publishingManager;
    }

    public DataTypeManager getStaticDataTypeManager() {
        return this.staticDataTypeManager;
    }

    public DataTypeManager getDynamicDataTypeManager() throws UaException {
        return (DataTypeManager)this.dynamicDataTypeManager.getOrThrow(() -> {
            DataTypeManager dataTypeManager = DefaultDataTypeManager.createAndInitialize((NamespaceTable)this.getNamespaceTable());
            this.dataTypeManagerInitializer.initialize(this.getNamespaceTable(), this.getDataTypeTree(), dataTypeManager);
            return dataTypeManager;
        });
    }

    public EncodingContext getStaticEncodingContext() {
        return this.staticEncodingContext;
    }

    public EncodingContext getDynamicEncodingContext() throws UaException {
        return (EncodingContext)this.dynamicEncodingContext.getOrThrow(() -> {
            final DataTypeManager dataTypeManager = this.getDynamicDataTypeManager();
            return new EncodingContext(){

                public DataTypeManager getDataTypeManager() {
                    return dataTypeManager;
                }

                public EncodingManager getEncodingManager() {
                    return OpcUaClient.this.encodingManager;
                }

                public EncodingLimits getEncodingLimits() {
                    return OpcUaClient.this.config.getEncodingLimits();
                }

                public NamespaceTable getNamespaceTable() {
                    return OpcUaClient.this.namespaceTable;
                }

                public ServerTable getServerTable() {
                    return OpcUaClient.this.serverTable;
                }
            };
        });
    }

    public NamespaceTable getNamespaceTable() {
        return this.namespaceTable;
    }

    public NamespaceTable readNamespaceTable() throws UaException {
        try {
            return this.readNamespaceTableAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<NamespaceTable> readNamespaceTableAsync() {
        return this.getSessionAsync().thenCompose(session -> {
            RequestHeader requestHeader = this.newRequestHeader(session.getAuthenticationToken());
            ReadRequest readRequest = new ReadRequest(requestHeader, Double.valueOf(0.0), TimestampsToReturn.Neither, new ReadValueId[]{new ReadValueId(NodeIds.Server_NamespaceArray, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE)});
            CompletionStage namespaceArray = ((CompletableFuture)((CompletableFuture)this.sendRequestAsync((UaRequestMessageType)readRequest).thenApply(ReadResponse.class::cast)).thenApply(response -> Objects.requireNonNull(response.getResults()))).thenApply(results -> (String[])results[0].value().value());
            return ((CompletableFuture)((CompletableFuture)namespaceArray).thenAccept(this::updateNamespaceTable)).thenApply(v -> this.getNamespaceTable());
        });
    }

    public ServerTable getServerTable() {
        return this.serverTable;
    }

    public ServerTable readServerTable() throws UaException {
        try {
            return this.readServerTableAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<ServerTable> readServerTableAsync() {
        return this.getSessionAsync().thenCompose(session -> {
            RequestHeader requestHeader = this.newRequestHeader(session.getAuthenticationToken());
            ReadRequest readRequest = new ReadRequest(requestHeader, Double.valueOf(0.0), TimestampsToReturn.Neither, new ReadValueId[]{new ReadValueId(NodeIds.Server_ServerArray, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE)});
            CompletionStage serverArray = ((CompletableFuture)((CompletableFuture)this.sendRequestAsync((UaRequestMessageType)readRequest).thenApply(ReadResponse.class::cast)).thenApply(response -> Objects.requireNonNull(response.getResults()))).thenApply(results -> (String[])results[0].value().value());
            return ((CompletableFuture)((CompletableFuture)serverArray).thenAccept(this::updateServerTable)).thenApply(v -> this.getServerTable());
        });
    }

    private void updateNamespaceTable(String[] namespaceArray) {
        if (namespaceArray.length > 65535) {
            this.logger.warn("NamespaceTable returned by server contains {} entries", (Object)namespaceArray.length);
        }
        NamespaceTable namespaceTable = this.getNamespaceTable();
        namespaceTable.update(uriTable -> {
            uriTable.clear();
            namespaceTable.add("http://opcfoundation.org/UA/");
            for (String uri : namespaceArray) {
                namespaceTable.add(uri);
            }
        });
    }

    private void updateServerTable(String[] serverArray) {
        if (serverArray.length > 65535) {
            this.logger.warn("ServerTable returned by server contains {} entries", (Object)serverArray.length);
        }
        ServerTable serverTable = this.getServerTable();
        serverTable.update(map -> {
            map.clear();
            for (String uri : serverArray) {
                serverTable.add(uri);
            }
        });
    }

    public DataTypeTree getDataTypeTree() throws UaException {
        try {
            return (DataTypeTree)this.dataTypeTree.getOrThrow(() -> DataTypeTreeBuilder.build(this));
        }
        catch (Exception e) {
            throw new UaException((Throwable)e);
        }
    }

    public DataTypeTree readDataTypeTree() throws UaException {
        this.dataTypeTree.reset();
        return this.getDataTypeTree();
    }

    public CompletionStage<DataTypeTree> readDataTypeTreeAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.readDataTypeTree();
            }
            catch (UaException e) {
                throw new CompletionException(e);
            }
        }, this.transport.getConfig().getExecutor());
    }

    public ObjectTypeTree getObjectTypeTree() throws UaException {
        try {
            return (ObjectTypeTree)this.objectTypeTree.getOrThrow(() -> ObjectTypeTreeBuilder.build(this));
        }
        catch (Exception e) {
            throw new UaException((Throwable)e);
        }
    }

    public ObjectTypeTree readObjectTypeTree() throws UaException {
        this.objectTypeTree.reset();
        return this.getObjectTypeTree();
    }

    public CompletionStage<ObjectTypeTree> readObjectTypeTreeAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.readObjectTypeTree();
            }
            catch (UaException e) {
                throw new CompletionException(e);
            }
        }, this.transport.getConfig().getExecutor());
    }

    public VariableTypeTree getVariableTypeTree() throws UaException {
        try {
            return (VariableTypeTree)this.variableTypeTree.getOrThrow(() -> VariableTypeTreeBuilder.build(this));
        }
        catch (Exception e) {
            throw new UaException((Throwable)e);
        }
    }

    public VariableTypeTree readVariableTypeTree() throws UaException {
        this.variableTypeTree.reset();
        return this.getVariableTypeTree();
    }

    public CompletionStage<VariableTypeTree> readVariableTypeTreeAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.readVariableTypeTree();
            }
            catch (UaException e) {
                throw new CompletionException(e);
            }
        }, this.transport.getConfig().getExecutor());
    }

    public OperationLimits getOperationLimits() throws UaException {
        return (OperationLimits)this.operationLimits.getOrThrow(() -> OperationLimits.read(this));
    }

    public OperationLimits readOperationLimits() throws UaException {
        this.operationLimits.reset();
        return this.getOperationLimits();
    }

    public RequestHeader newRequestHeader() {
        return this.newRequestHeader(NodeId.NULL_VALUE);
    }

    public RequestHeader newRequestHeader(NodeId authToken) {
        return this.newRequestHeader(authToken, this.config.getRequestTimeout());
    }

    public RequestHeader newRequestHeader(NodeId authToken, UInteger requestTimeout) {
        return new RequestHeader(authToken, DateTime.now(), Unsigned.uint((long)this.requestHandles.getAndIncrement()), Unsigned.uint((int)0), null, requestTimeout, null);
    }

    public void setDataTypeManagerInitializer(DataTypeManagerInitializer dataTypeManagerInitializer) {
        this.dataTypeManagerInitializer = dataTypeManagerInitializer;
        this.dynamicDataTypeManager.reset();
        this.dynamicEncodingContext.reset();
    }

    public ReadResponse read(double maxAge, TimestampsToReturn timestampsToReturn, List<ReadValueId> readValueIds) throws UaException {
        try {
            return this.readAsync(maxAge, timestampsToReturn, readValueIds).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public DataValue readValue(double maxAge, TimestampsToReturn timestampsToReturn, NodeId nodeId) throws UaException {
        return this.readValues(maxAge, timestampsToReturn, List.of(nodeId)).get(0);
    }

    public List<DataValue> readValues(double maxAge, TimestampsToReturn timestampsToReturn, List<NodeId> nodeIds) throws UaException {
        try {
            return this.readValuesAsync(maxAge, timestampsToReturn, nodeIds).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<ReadResponse> readAsync(double maxAge, TimestampsToReturn timestampsToReturn, List<ReadValueId> readValueIds) {
        return this.getSessionAsync().thenCompose(session -> {
            ReadRequest request = new ReadRequest(this.newRequestHeader(session.getAuthenticationToken()), Double.valueOf(maxAge), timestampsToReturn, readValueIds.toArray(new ReadValueId[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(ReadResponse.class::cast);
        });
    }

    public CompletableFuture<List<DataValue>> readValuesAsync(double maxAge, TimestampsToReturn timestampsToReturn, List<NodeId> nodeIds) {
        List<ReadValueId> readValueIds = nodeIds.stream().map(nodeId -> new ReadValueId(nodeId, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE)).collect(Collectors.toList());
        return this.readAsync(maxAge, timestampsToReturn, readValueIds).thenApply(r -> Lists.ofNullable((Object[])r.getResults()));
    }

    public WriteResponse write(List<WriteValue> writeValues) throws UaException {
        try {
            return this.writeAsync(writeValues).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public List<StatusCode> writeValues(List<NodeId> nodeIds, List<DataValue> values) throws UaException {
        try {
            return this.writeValuesAsync(nodeIds, values).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<WriteResponse> writeAsync(List<WriteValue> writeValues) {
        return this.getSessionAsync().thenCompose(session -> {
            WriteRequest request = new WriteRequest(this.newRequestHeader(session.getAuthenticationToken()), writeValues.toArray(new WriteValue[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(WriteResponse.class::cast);
        });
    }

    public CompletableFuture<List<StatusCode>> writeValuesAsync(List<NodeId> nodeIds, List<DataValue> values) {
        ArrayList<WriteValue> writeValues = new ArrayList<WriteValue>(nodeIds.size());
        for (int i = 0; i < nodeIds.size(); ++i) {
            NodeId nodeId = nodeIds.get(i);
            DataValue value = values.get(i);
            writeValues.add(new WriteValue(nodeId, AttributeId.Value.uid(), null, value));
        }
        return this.writeAsync(writeValues).thenApply(response -> Lists.ofNullable((Object[])response.getResults()));
    }

    public HistoryReadResponse historyRead(HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, boolean releaseContinuationPoints, List<HistoryReadValueId> nodesToRead) throws UaException {
        try {
            CompletableFuture<HistoryReadResponse> future = this.historyReadAsync(historyReadDetails, timestampsToReturn, releaseContinuationPoints, nodesToRead);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<HistoryReadResponse> historyReadAsync(HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, boolean releaseContinuationPoints, List<HistoryReadValueId> nodesToRead) {
        return this.getSessionAsync().thenCompose(session -> {
            HistoryReadRequest request = new HistoryReadRequest(this.newRequestHeader(session.getAuthenticationToken()), ExtensionObject.encode((EncodingContext)this.getStaticEncodingContext(), (UaStructuredType)historyReadDetails), timestampsToReturn, Boolean.valueOf(releaseContinuationPoints), nodesToRead.toArray(new HistoryReadValueId[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(HistoryReadResponse.class::cast);
        });
    }

    public HistoryUpdateResponse historyUpdate(List<HistoryUpdateDetails> historyUpdateDetails) throws UaException {
        try {
            return this.historyUpdateAsync(historyUpdateDetails).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<HistoryUpdateResponse> historyUpdateAsync(List<HistoryUpdateDetails> historyUpdateDetails) {
        return this.getSessionAsync().thenCompose(session -> {
            ExtensionObject[] details = (ExtensionObject[])historyUpdateDetails.stream().map(hud -> ExtensionObject.encode((EncodingContext)this.getStaticEncodingContext(), (UaStructuredType)hud)).toArray(ExtensionObject[]::new);
            HistoryUpdateRequest request = new HistoryUpdateRequest(this.newRequestHeader(session.getAuthenticationToken()), details);
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(HistoryUpdateResponse.class::cast);
        });
    }

    public CallResponse call(List<CallMethodRequest> requests) throws UaException {
        try {
            return this.callAsync(requests).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<CallResponse> callAsync(List<CallMethodRequest> requests) {
        return this.getSessionAsync().thenCompose(session -> {
            CallRequest request = new CallRequest(this.newRequestHeader(session.getAuthenticationToken()), requests.toArray(new CallMethodRequest[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(CallResponse.class::cast);
        });
    }

    public CreateMonitoredItemsResponse createMonitoredItems(UInteger subscriptionId, TimestampsToReturn timestampsToReturn, List<MonitoredItemCreateRequest> itemsToCreate) throws UaException {
        try {
            return this.createMonitoredItemsAsync(subscriptionId, timestampsToReturn, itemsToCreate).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<CreateMonitoredItemsResponse> createMonitoredItemsAsync(UInteger subscriptionId, TimestampsToReturn timestampsToReturn, List<MonitoredItemCreateRequest> itemsToCreate) {
        return this.getSessionAsync().thenCompose(session -> {
            CreateMonitoredItemsRequest request = new CreateMonitoredItemsRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, timestampsToReturn, itemsToCreate.toArray(new MonitoredItemCreateRequest[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(CreateMonitoredItemsResponse.class::cast);
        });
    }

    public ModifyMonitoredItemsResponse modifyMonitoredItems(UInteger subscriptionId, TimestampsToReturn timestampsToReturn, List<MonitoredItemModifyRequest> itemsToModify) throws UaException {
        try {
            return this.modifyMonitoredItemsAsync(subscriptionId, timestampsToReturn, itemsToModify).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<ModifyMonitoredItemsResponse> modifyMonitoredItemsAsync(UInteger subscriptionId, TimestampsToReturn timestampsToReturn, List<MonitoredItemModifyRequest> itemsToModify) {
        return this.getSessionAsync().thenCompose(session -> {
            ModifyMonitoredItemsRequest request = new ModifyMonitoredItemsRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, timestampsToReturn, itemsToModify.toArray(new MonitoredItemModifyRequest[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(ModifyMonitoredItemsResponse.class::cast);
        });
    }

    public DeleteMonitoredItemsResponse deleteMonitoredItems(UInteger subscriptionId, List<UInteger> monitoredItemIds) throws UaException {
        try {
            return this.deleteMonitoredItemsAsync(subscriptionId, monitoredItemIds).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<DeleteMonitoredItemsResponse> deleteMonitoredItemsAsync(UInteger subscriptionId, List<UInteger> monitoredItemIds) {
        return this.getSessionAsync().thenCompose(session -> {
            DeleteMonitoredItemsRequest request = new DeleteMonitoredItemsRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, monitoredItemIds.toArray(new UInteger[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(DeleteMonitoredItemsResponse.class::cast);
        });
    }

    public SetMonitoringModeResponse setMonitoringMode(UInteger subscriptionId, MonitoringMode monitoringMode, List<UInteger> monitoredItemIds) throws UaException {
        try {
            return this.setMonitoringModeAsync(subscriptionId, monitoringMode, monitoredItemIds).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<SetMonitoringModeResponse> setMonitoringModeAsync(UInteger subscriptionId, MonitoringMode monitoringMode, List<UInteger> monitoredItemIds) {
        return this.getSessionAsync().thenCompose(session -> {
            SetMonitoringModeRequest request = new SetMonitoringModeRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, monitoringMode, monitoredItemIds.toArray(new UInteger[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(SetMonitoringModeResponse.class::cast);
        });
    }

    public SetTriggeringResponse setTriggering(UInteger subscriptionId, UInteger triggeringItemId, List<UInteger> linksToAdd, List<UInteger> linksToRemove) throws UaException {
        try {
            return this.setTriggeringAsync(subscriptionId, triggeringItemId, linksToAdd, linksToRemove).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<SetTriggeringResponse> setTriggeringAsync(UInteger subscriptionId, UInteger triggeringItemId, List<UInteger> linksToAdd, List<UInteger> linksToRemove) {
        return this.getSessionAsync().thenCompose(session -> {
            SetTriggeringRequest request = new SetTriggeringRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, triggeringItemId, linksToAdd.toArray(new UInteger[0]), linksToRemove.toArray(new UInteger[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(SetTriggeringResponse.class::cast);
        });
    }

    public AddNodesResponse addNodes(List<AddNodesItem> nodesToAdd) throws UaException {
        try {
            return this.addNodesAsync(nodesToAdd).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<AddNodesResponse> addNodesAsync(List<AddNodesItem> nodesToAdd) {
        return this.getSessionAsync().thenCompose(session -> {
            AddNodesRequest request = new AddNodesRequest(this.newRequestHeader(session.getAuthenticationToken()), nodesToAdd.toArray(new AddNodesItem[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(AddNodesResponse.class::cast);
        });
    }

    public AddReferencesResponse addReferences(List<AddReferencesItem> referencesToAdd) throws UaException {
        try {
            return this.addReferencesAsync(referencesToAdd).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<AddReferencesResponse> addReferencesAsync(List<AddReferencesItem> referencesToAdd) {
        return this.getSessionAsync().thenCompose(session -> {
            AddReferencesRequest request = new AddReferencesRequest(this.newRequestHeader(session.getAuthenticationToken()), referencesToAdd.toArray(new AddReferencesItem[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(AddReferencesResponse.class::cast);
        });
    }

    public DeleteNodesResponse deleteNodes(List<DeleteNodesItem> nodesToDelete) throws UaException {
        try {
            return this.deleteNodesAsync(nodesToDelete).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<DeleteNodesResponse> deleteNodesAsync(List<DeleteNodesItem> nodesToDelete) {
        return this.getSessionAsync().thenCompose(session -> {
            DeleteNodesRequest request = new DeleteNodesRequest(this.newRequestHeader(session.getAuthenticationToken()), nodesToDelete.toArray(new DeleteNodesItem[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(DeleteNodesResponse.class::cast);
        });
    }

    public DeleteReferencesResponse deleteReferences(List<DeleteReferencesItem> referencesToDelete) throws UaException {
        try {
            return this.deleteReferencesAsync(referencesToDelete).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<DeleteReferencesResponse> deleteReferencesAsync(List<DeleteReferencesItem> referencesToDelete) {
        return this.getSessionAsync().thenCompose(session -> {
            DeleteReferencesRequest request = new DeleteReferencesRequest(this.newRequestHeader(session.getAuthenticationToken()), referencesToDelete.toArray(new DeleteReferencesItem[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(DeleteReferencesResponse.class::cast);
        });
    }

    public QueryFirstResponse queryFirst(ViewDescription view, List<NodeTypeDescription> nodeTypes, ContentFilter filter, UInteger maxDataSetsToReturn, UInteger maxReferencesToReturn) throws UaException {
        try {
            return this.queryFirstAsync(view, nodeTypes, filter, maxDataSetsToReturn, maxReferencesToReturn).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<QueryFirstResponse> queryFirstAsync(ViewDescription view, List<NodeTypeDescription> nodeTypes, ContentFilter filter, UInteger maxDataSetsToReturn, UInteger maxReferencesToReturn) {
        return this.getSessionAsync().thenCompose(session -> {
            QueryFirstRequest request = new QueryFirstRequest(this.newRequestHeader(session.getAuthenticationToken()), view, nodeTypes.toArray(new NodeTypeDescription[0]), filter, maxDataSetsToReturn, maxReferencesToReturn);
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(QueryFirstResponse.class::cast);
        });
    }

    public QueryNextResponse queryNext(boolean releaseContinuationPoint, ByteString continuationPoint) throws UaException {
        try {
            return this.queryNextAsync(releaseContinuationPoint, continuationPoint).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<QueryNextResponse> queryNextAsync(boolean releaseContinuationPoint, ByteString continuationPoint) {
        return this.getSessionAsync().thenCompose(session -> {
            QueryNextRequest request = new QueryNextRequest(this.newRequestHeader(session.getAuthenticationToken()), Boolean.valueOf(releaseContinuationPoint), continuationPoint);
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(QueryNextResponse.class::cast);
        });
    }

    public CreateSubscriptionResponse createSubscription(double requestedPublishingInterval, UInteger requestedLifetimeCount, UInteger requestedMaxKeepAliveCount, UInteger maxNotificationsPerPublish, boolean publishingEnabled, UByte priority) throws UaException {
        try {
            CompletableFuture<CreateSubscriptionResponse> future = this.createSubscriptionAsync(requestedPublishingInterval, requestedLifetimeCount, requestedMaxKeepAliveCount, maxNotificationsPerPublish, publishingEnabled, priority);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<CreateSubscriptionResponse> createSubscriptionAsync(double requestedPublishingInterval, UInteger requestedLifetimeCount, UInteger requestedMaxKeepAliveCount, UInteger maxNotificationsPerPublish, boolean publishingEnabled, UByte priority) {
        return this.getSessionAsync().thenCompose(session -> {
            CreateSubscriptionRequest request = new CreateSubscriptionRequest(this.newRequestHeader(session.getAuthenticationToken()), Double.valueOf(requestedPublishingInterval), requestedLifetimeCount, requestedMaxKeepAliveCount, maxNotificationsPerPublish, Boolean.valueOf(publishingEnabled), priority);
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(CreateSubscriptionResponse.class::cast);
        });
    }

    public ModifySubscriptionResponse modifySubscription(UInteger subscriptionId, double requestedPublishingInterval, UInteger requestedLifetimeCount, UInteger requestedMaxKeepAliveCount, UInteger maxNotificationsPerPublish, UByte priority) throws UaException {
        try {
            CompletableFuture<ModifySubscriptionResponse> future = this.modifySubscriptionAsync(subscriptionId, requestedPublishingInterval, requestedLifetimeCount, requestedMaxKeepAliveCount, maxNotificationsPerPublish, priority);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<ModifySubscriptionResponse> modifySubscriptionAsync(UInteger subscriptionId, double requestedPublishingInterval, UInteger requestedLifetimeCount, UInteger requestedMaxKeepAliveCount, UInteger maxNotificationsPerPublish, UByte priority) {
        return this.getSessionAsync().thenCompose(session -> {
            ModifySubscriptionRequest request = new ModifySubscriptionRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, Double.valueOf(requestedPublishingInterval), requestedLifetimeCount, requestedMaxKeepAliveCount, maxNotificationsPerPublish, priority);
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(ModifySubscriptionResponse.class::cast);
        });
    }

    public DeleteSubscriptionsResponse deleteSubscriptions(List<UInteger> subscriptionIds) throws UaException {
        try {
            CompletableFuture<DeleteSubscriptionsResponse> future = this.deleteSubscriptionsAsync(subscriptionIds);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<DeleteSubscriptionsResponse> deleteSubscriptionsAsync(List<UInteger> subscriptionIds) {
        return this.getSessionAsync().thenCompose(session -> {
            DeleteSubscriptionsRequest request = new DeleteSubscriptionsRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionIds.toArray(new UInteger[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(DeleteSubscriptionsResponse.class::cast);
        });
    }

    public TransferSubscriptionsResponse transferSubscriptions(List<UInteger> subscriptionIds, boolean sendInitialValues) throws UaException {
        try {
            CompletableFuture<TransferSubscriptionsResponse> future = this.transferSubscriptionsAsync(subscriptionIds, sendInitialValues);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<TransferSubscriptionsResponse> transferSubscriptionsAsync(List<UInteger> subscriptionIds, boolean sendInitialValues) {
        return this.getSessionAsync().thenCompose(session -> {
            TransferSubscriptionsRequest request = new TransferSubscriptionsRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionIds.toArray(new UInteger[0]), Boolean.valueOf(sendInitialValues));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(TransferSubscriptionsResponse.class::cast);
        });
    }

    public SetPublishingModeResponse setPublishingMode(boolean publishingEnabled, List<UInteger> subscriptionIds) throws UaException {
        try {
            CompletableFuture<SetPublishingModeResponse> future = this.setPublishingModeAsync(publishingEnabled, subscriptionIds);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<SetPublishingModeResponse> setPublishingModeAsync(boolean publishingEnabled, List<UInteger> subscriptionIds) {
        return this.getSessionAsync().thenCompose(session -> {
            SetPublishingModeRequest request = new SetPublishingModeRequest(this.newRequestHeader(session.getAuthenticationToken()), Boolean.valueOf(publishingEnabled), subscriptionIds.toArray(new UInteger[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(SetPublishingModeResponse.class::cast);
        });
    }

    public PublishResponse publish(List<SubscriptionAcknowledgement> subscriptionAcknowledgements) throws UaException {
        try {
            CompletableFuture<PublishResponse> future = this.publishAsync(subscriptionAcknowledgements);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<PublishResponse> publishAsync(List<SubscriptionAcknowledgement> subscriptionAcknowledgements) {
        return this.getSessionAsync().thenCompose(session -> {
            PublishRequest request = new PublishRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionAcknowledgements.toArray(new SubscriptionAcknowledgement[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(PublishResponse.class::cast);
        });
    }

    public RepublishResponse republish(UInteger subscriptionId, UInteger retransmitSequenceNumber) throws UaException {
        try {
            CompletableFuture<RepublishResponse> future = this.republishAsync(subscriptionId, retransmitSequenceNumber);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<RepublishResponse> republishAsync(UInteger subscriptionId, UInteger retransmitSequenceNumber) {
        return this.getSessionAsync().thenCompose(session -> {
            RepublishRequest request = new RepublishRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, retransmitSequenceNumber);
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(RepublishResponse.class::cast);
        });
    }

    public BrowseResult browse(BrowseDescription nodeToBrowse) throws UaException {
        try {
            return this.browseAsync(nodeToBrowse).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public List<BrowseResult> browse(List<BrowseDescription> nodesToBrowse) throws UaException {
        try {
            return this.browseAsync(nodesToBrowse).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public BrowseResponse browse(ViewDescription viewDescription, UInteger maxReferencesPerNode, List<BrowseDescription> nodesToBrowse) throws UaException {
        try {
            return this.browseAsync(viewDescription, maxReferencesPerNode, nodesToBrowse).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<BrowseResponse> browseAsync(ViewDescription viewDescription, UInteger maxReferencesPerNode, List<BrowseDescription> nodesToBrowse) {
        return this.getSessionAsync().thenCompose(session -> {
            BrowseRequest request = new BrowseRequest(this.newRequestHeader(session.getAuthenticationToken()), viewDescription, maxReferencesPerNode, nodesToBrowse.toArray(new BrowseDescription[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(BrowseResponse.class::cast);
        });
    }

    public CompletableFuture<BrowseResult> browseAsync(BrowseDescription nodeToBrowse) {
        return this.browseAsync(List.of(nodeToBrowse)).thenApply(rs -> (BrowseResult)rs.get(0));
    }

    public CompletableFuture<List<BrowseResult>> browseAsync(List<BrowseDescription> nodesToBrowse) {
        ViewDescription viewDescription = new ViewDescription(NodeId.NULL_VALUE, DateTime.MIN_VALUE, Unsigned.uint((int)0));
        return this.browseAsync(viewDescription, Unsigned.uint((int)0), nodesToBrowse).thenApply(r -> Lists.ofNullable((Object[])r.getResults()));
    }

    public BrowseNextResponse browseNext(boolean releaseContinuationPoints, List<ByteString> continuationPoints) throws UaException {
        try {
            return this.browseNextAsync(releaseContinuationPoints, continuationPoints).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<BrowseNextResponse> browseNextAsync(boolean releaseContinuationPoints, List<ByteString> continuationPoints) {
        return this.getSessionAsync().thenCompose(session -> {
            BrowseNextRequest request = new BrowseNextRequest(this.newRequestHeader(session.getAuthenticationToken()), Boolean.valueOf(releaseContinuationPoints), continuationPoints.toArray(new ByteString[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(BrowseNextResponse.class::cast);
        });
    }

    public TranslateBrowsePathsToNodeIdsResponse translateBrowsePaths(List<BrowsePath> browsePaths) throws UaException {
        try {
            return this.translateBrowsePathsAsync(browsePaths).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<TranslateBrowsePathsToNodeIdsResponse> translateBrowsePathsAsync(List<BrowsePath> browsePaths) {
        return this.getSessionAsync().thenCompose(session -> {
            TranslateBrowsePathsToNodeIdsRequest request = new TranslateBrowsePathsToNodeIdsRequest(this.newRequestHeader(session.getAuthenticationToken()), browsePaths.toArray(new BrowsePath[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(TranslateBrowsePathsToNodeIdsResponse.class::cast);
        });
    }

    public RegisterNodesResponse registerNodes(List<NodeId> nodesToRegister) throws UaException {
        try {
            return this.registerNodesAsync(nodesToRegister).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<RegisterNodesResponse> registerNodesAsync(List<NodeId> nodesToRegister) {
        return this.getSessionAsync().thenCompose(session -> {
            RegisterNodesRequest request = new RegisterNodesRequest(this.newRequestHeader(session.getAuthenticationToken()), nodesToRegister.toArray(new NodeId[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(RegisterNodesResponse.class::cast);
        });
    }

    public UnregisterNodesResponse unregisterNodes(List<NodeId> nodesToUnregister) throws UaException {
        try {
            return this.unregisterNodesAsync(nodesToUnregister).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<UnregisterNodesResponse> unregisterNodesAsync(List<NodeId> nodesToUnregister) {
        return this.getSessionAsync().thenCompose(session -> {
            UnregisterNodesRequest request = new UnregisterNodesRequest(this.newRequestHeader(session.getAuthenticationToken()), nodesToUnregister.toArray(new NodeId[0]));
            return this.sendRequestAsync((UaRequestMessageType)request).thenApply(UnregisterNodesResponse.class::cast);
        });
    }

    public UaResponseMessageType sendRequest(UaRequestMessageType request) throws UaException {
        try {
            return this.sendRequestAsync(request).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<UaResponseMessageType> sendRequestAsync(UaRequestMessageType request) {
        return this.transport.sendRequestMessage(request).whenComplete(this::notifyFaultListeners);
    }

    private void notifyFaultListeners(UaResponseMessageType response, Throwable ex) {
        if (ex == null || this.faultListeners.isEmpty()) {
            return;
        }
        UaServiceFaultException faultException = null;
        if (ex instanceof UaServiceFaultException) {
            faultException = (UaServiceFaultException)ex;
        } else if (ex.getCause() instanceof UaServiceFaultException) {
            faultException = (UaServiceFaultException)ex.getCause();
        }
        if (faultException != null) {
            ServiceFault serviceFault = faultException.getServiceFault();
            this.logger.debug("Notifying {} ServiceFaultListeners", (Object)this.faultListeners.size());
            this.faultNotificationQueue.submit(() -> this.faultListeners.forEach(h -> h.onServiceFault(serviceFault)));
        }
    }

    public void addFaultListener(ServiceFaultListener faultListener) {
        this.faultListeners.add(faultListener);
        this.logger.debug("Added ServiceFaultListener: {}", (Object)faultListener);
    }

    public void removeFaultListener(ServiceFaultListener faultListener) {
        this.faultListeners.remove(faultListener);
        this.logger.debug("Removed ServiceFaultListener: {}", (Object)faultListener);
    }

    public void addSessionActivityListener(SessionActivityListener listener) {
        this.sessionFsm.addActivityListener(listener);
        this.logger.debug("Added SessionActivityListener: {}", (Object)listener);
    }

    public void removeSessionActivityListener(SessionActivityListener listener) {
        this.sessionFsm.removeActivityListener(listener);
        this.logger.debug("Removed SessionActivityListener: {}", (Object)listener);
    }

    public void addSessionInitializer(SessionFsm.SessionInitializer initializer) {
        this.sessionFsm.addInitializer(initializer);
        this.logger.debug("Added SessionInitializer: {}", (Object)initializer);
    }

    public void removeSessionInitializer(SessionFsm.SessionInitializer initializer) {
        this.sessionFsm.removeInitializer(initializer);
        this.logger.debug("Removed SessionInitializer: {}", (Object)initializer);
    }

    static {
        Logger logger = LoggerFactory.getLogger(OpcUaClient.class);
        logger.info("Java version: {}", (Object)System.getProperty("java.version"));
        logger.info("Eclipse Milo OPC UA Stack version: {}", (Object)Stack.VERSION);
        logger.info("Eclipse Milo OPC UA Client SDK version: {}", (Object)SDK_VERSION);
    }

    public static class DefaultDataTypeManagerInitializer
    implements DataTypeManagerInitializer {
        private final CodecFactory codecFactory;

        public DefaultDataTypeManagerInitializer() {
            this(DynamicCodecFactory::create);
        }

        public DefaultDataTypeManagerInitializer(CodecFactory codecFactory) {
            this.codecFactory = codecFactory;
        }

        @Override
        public void initialize(NamespaceTable namespaceTable, DataTypeTree dataTypeTree, DataTypeManager dataTypeManager) {
            Tree structureNode = dataTypeTree.getTreeNode(NodeIds.Structure);
            if (structureNode != null) {
                structureNode.traverse(dataType -> {
                    if (dataType.getDataTypeDefinition() != null) {
                        LoggerFactory.getLogger(this.getClass()).debug("Registering type: name={}, dataTypeId={}", (Object)dataType.getBrowseName(), (Object)dataType.getNodeId());
                        String namespaceUri = namespaceTable.get((UNumber)dataType.getNodeId().getNamespaceIndex());
                        if (namespaceUri == null) {
                            throw new UaRuntimeException(0x80010000L, "DataType namespace not registered: " + dataType.getNodeId().toParseableString());
                        }
                        dataTypeManager.registerType(dataType.getNodeId(), this.codecFactory.create((DataType)dataType, dataTypeTree), DefaultDataTypeManagerInitializer.getBinaryEncodingId(dataType), dataType.getXmlEncodingId(), dataType.getJsonEncodingId());
                    }
                });
            } else {
                LoggerFactory.getLogger(this.getClass()).warn("Structure (i=22) not found in the DataType tree; is the Server's DataType hierarchy sane?");
            }
        }

        private static NodeId getBinaryEncodingId(DataType dataType) {
            DataTypeDefinition dataTypeDefinition;
            NodeId binaryEncodingId = dataType.getBinaryEncodingId();
            if (binaryEncodingId == null && (dataTypeDefinition = dataType.getDataTypeDefinition()) instanceof StructureDefinition) {
                StructureDefinition definition = (StructureDefinition)dataTypeDefinition;
                binaryEncodingId = definition.getDefaultEncodingId();
            }
            return binaryEncodingId;
        }
    }

    public static interface DataTypeManagerInitializer {
        public void initialize(NamespaceTable var1, DataTypeTree var2, DataTypeManager var3) throws UaException;
    }
}

