/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.shaded.com.google.common.cache.Cache;
import org.eclipse.milo.shaded.com.google.common.cache.CacheBuilder;
import org.jspecify.annotations.Nullable;

public class NodeCache {
    private final Cache<NodeId, UaNode> cachedNodes;
    private final ConcurrentMap<NodeId, UaNode> canonicalNodes;

    public NodeCache() {
        this(builder -> {
            builder.expireAfterWrite(2L, TimeUnit.MINUTES);
            builder.maximumSize(16384L);
            builder.recordStats();
        });
    }

    public NodeCache(Consumer<CacheBuilder<Object, Object>> consumer) {
        CacheBuilder builder = CacheBuilder.newBuilder();
        consumer.accept((CacheBuilder<Object, Object>)builder);
        this.cachedNodes = builder.build();
        this.canonicalNodes = new ConcurrentHashMap<NodeId, UaNode>();
    }

    public UaNode canonicalize(UaNode node) {
        NodeId nodeId = node.getNodeId();
        UaNode prev = this.canonicalNodes.putIfAbsent(nodeId, node);
        return prev != null ? prev : node;
    }

    public @Nullable UaNode getIfPresent(NodeId nodeId) {
        return this.canonicalNodes.getOrDefault(nodeId, (UaNode)this.cachedNodes.getIfPresent((Object)nodeId));
    }

    public void put(NodeId nodeId, UaNode node) {
        this.cachedNodes.put((Object)nodeId, (Object)node);
    }

    public void invalidate(NodeId nodeId) {
        this.canonicalNodes.remove(nodeId);
        this.cachedNodes.invalidate((Object)nodeId);
    }
}

