/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.DefaultEncodingContext;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.security.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterServerRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterServerResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisteredServer;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Lists;
import org.eclipse.milo.opcua.stack.transport.client.ClientApplicationContext;
import org.eclipse.milo.opcua.stack.transport.client.OpcClientTransport;
import org.eclipse.milo.opcua.stack.transport.client.tcp.OpcTcpClientTransport;
import org.eclipse.milo.opcua.stack.transport.client.tcp.OpcTcpClientTransportConfig;
import org.eclipse.milo.opcua.stack.transport.client.tcp.OpcTcpClientTransportConfigBuilder;

public class DiscoveryClient {
    private final ClientApplicationContext applicationContext;
    private final OpcClientTransport transport;

    public DiscoveryClient(final EndpointDescription endpoint, OpcClientTransport transport) {
        this.transport = transport;
        this.applicationContext = new ClientApplicationContext(){

            public EndpointDescription getEndpoint() {
                return endpoint;
            }

            public Optional<KeyPair> getKeyPair() {
                return Optional.empty();
            }

            public Optional<X509Certificate> getCertificate() {
                return Optional.empty();
            }

            public Optional<X509Certificate[]> getCertificateChain() {
                return Optional.empty();
            }

            public CertificateValidator getCertificateValidator() {
                return new CertificateValidator.InsecureCertificateValidator();
            }

            public EncodingContext getEncodingContext() {
                return DefaultEncodingContext.INSTANCE;
            }

            public UInteger getRequestTimeout() {
                return Unsigned.uint((int)60000);
            }
        };
    }

    public DiscoveryClient connect() throws UaException {
        try {
            return this.connectAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<DiscoveryClient> connectAsync() {
        return this.transport.connect(this.applicationContext).thenApply(c -> this);
    }

    public DiscoveryClient disconnect() throws UaException {
        try {
            return this.disconnectAsync().get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<DiscoveryClient> disconnectAsync() {
        return this.transport.disconnect().thenApply(c -> this);
    }

    public CompletableFuture<FindServersResponse> findServers(String endpointUrl, String[] localeIds, String[] serverUris) {
        RequestHeader requestHeader = this.newRequestHeader(NodeId.NULL_VALUE, Unsigned.uint((int)60000));
        FindServersRequest request = new FindServersRequest(requestHeader, endpointUrl, localeIds, serverUris);
        return this.transport.sendRequestMessage((UaRequestMessageType)request).thenApply(FindServersResponse.class::cast);
    }

    public CompletableFuture<GetEndpointsResponse> getEndpoints(String endpointUrl, String[] localeIds, String[] profileUris) {
        RequestHeader header = this.newRequestHeader(NodeId.NULL_VALUE, Unsigned.uint((int)60000));
        GetEndpointsRequest request = new GetEndpointsRequest(header, endpointUrl, localeIds, profileUris);
        return this.transport.sendRequestMessage((UaRequestMessageType)request).thenApply(GetEndpointsResponse.class::cast);
    }

    public CompletableFuture<RegisterServerResponse> registerServer(RegisteredServer server) {
        RequestHeader header = this.newRequestHeader(NodeId.NULL_VALUE, Unsigned.uint((int)60000));
        RegisterServerRequest request = new RegisterServerRequest(header, server);
        return this.transport.sendRequestMessage((UaRequestMessageType)request).thenApply(RegisterServerResponse.class::cast);
    }

    public RequestHeader newRequestHeader(NodeId authToken, UInteger requestTimeout) {
        return new RequestHeader(authToken, DateTime.now(), Unsigned.uint((int)0), Unsigned.uint((int)0), null, requestTimeout, null);
    }

    public static CompletableFuture<List<ApplicationDescription>> findServers(String endpointUrl) {
        return DiscoveryClient.findServers(endpointUrl, b -> {});
    }

    public static CompletableFuture<List<ApplicationDescription>> findServers(String endpointUrl, Consumer<OpcTcpClientTransportConfigBuilder> customizer) {
        EndpointDescription endpoint = new EndpointDescription(endpointUrl, null, null, MessageSecurityMode.None, SecurityPolicy.None.getUri(), null, "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary", Unsigned.ubyte((int)0));
        OpcTcpClientTransportConfigBuilder configBuilder = OpcTcpClientTransportConfig.newBuilder();
        customizer.accept(configBuilder);
        OpcTcpClientTransportConfig config = configBuilder.build();
        OpcTcpClientTransport transport = new OpcTcpClientTransport(config);
        DiscoveryClient discoveryClient = new DiscoveryClient(endpoint, (OpcClientTransport)transport);
        return ((CompletableFuture)((CompletableFuture)discoveryClient.connectAsync().thenCompose(c -> c.findServers(endpointUrl, new String[0], new String[0]))).whenComplete((e, ex) -> discoveryClient.disconnectAsync())).thenApply(response -> Lists.ofNullable((Object[])response.getServers()));
    }

    public static CompletableFuture<List<EndpointDescription>> getEndpoints(String endpointUrl) {
        return DiscoveryClient.getEndpoints(endpointUrl, b -> {});
    }

    public static CompletableFuture<List<EndpointDescription>> getEndpoints(String endpointUrl, Consumer<OpcTcpClientTransportConfigBuilder> customizer) {
        String profileUri;
        String scheme = EndpointUtil.getScheme((String)endpointUrl);
        switch (Objects.requireNonNullElse(scheme, "").toLowerCase()) {
            case "opc.tcp": {
                profileUri = "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary";
                break;
            }
            case "http": 
            case "https": 
            case "opc.http": 
            case "opc.https": {
                profileUri = "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
                break;
            }
            case "opc.ws": 
            case "opc.wss": {
                profileUri = "http://opcfoundation.org/UA-Profile/Transport/wss-uasc-uabinary";
                break;
            }
            default: {
                return FutureUtils.failedFuture((Throwable)new UaException(0x80020000L, "unsupported protocol: " + scheme));
            }
        }
        return DiscoveryClient.getEndpoints(endpointUrl, profileUri, customizer);
    }

    private static CompletableFuture<List<EndpointDescription>> getEndpoints(String endpointUrl, String profileUri, Consumer<OpcTcpClientTransportConfigBuilder> customizer) {
        EndpointDescription endpoint = new EndpointDescription(endpointUrl, null, null, MessageSecurityMode.None, SecurityPolicy.None.getUri(), null, profileUri, Unsigned.ubyte((int)0));
        OpcTcpClientTransportConfigBuilder configBuilder = OpcTcpClientTransportConfig.newBuilder();
        customizer.accept(configBuilder);
        OpcTcpClientTransportConfig config = configBuilder.build();
        OpcTcpClientTransport transport = new OpcTcpClientTransport(config);
        DiscoveryClient discoveryClient = new DiscoveryClient(endpoint, (OpcClientTransport)transport);
        return ((CompletableFuture)((CompletableFuture)discoveryClient.connectAsync().thenCompose(c -> c.getEndpoints(endpointUrl, new String[0], new String[]{profileUri}))).whenComplete((e, ex) -> discoveryClient.disconnectAsync())).thenApply(response -> Lists.ofNullable((Object[])response.getEndpoints()));
    }
}

