/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.typetree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.typetree.ClientDataType;
import org.eclipse.milo.opcua.sdk.core.typetree.DataType;
import org.eclipse.milo.opcua.sdk.core.typetree.DataTypeTree;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.util.Lists;
import org.eclipse.milo.opcua.stack.core.util.Tree;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeTreeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTypeTreeBuilder.class);

    public static DataTypeTree build(OpcUaClient client) throws UaException {
        Tree root = new Tree(null, (Object)new ClientDataType(QualifiedName.parse((String)"0:BaseDataType"), NodeIds.BaseDataType, null, null, null, null, true));
        NamespaceTable namespaceTable = client.readNamespaceTable();
        UInteger[] operationLimits = DataTypeTreeBuilder.readOperationLimits(client);
        UInteger maxNodesPerBrowse = operationLimits[0];
        UInteger maxNodesPerRead = operationLimits[1];
        DataTypeTreeBuilder.addChildren(List.of(root), client, namespaceTable, maxNodesPerBrowse, maxNodesPerRead);
        return new DataTypeTree(root);
    }

    public static CompletableFuture<DataTypeTree> buildAsync(OpcUaClient client) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return DataTypeTreeBuilder.build(client);
            }
            catch (UaException e) {
                throw new CompletionException(e);
            }
        }, client.getTransport().getConfig().getExecutor());
    }

    private static void addChildren(List<Tree<DataType>> parentTypes, OpcUaClient client, NamespaceTable namespaceTable, UInteger maxNodesPerBrowse, UInteger maxNodesPerRead) {
        List<List<ReferenceDescription>> parentSubtypes = DataTypeTreeBuilder.browseWithOperationLimits(client, parentTypes.stream().map(tree -> new BrowseDescription(((DataType)tree.getValue()).getNodeId(), BrowseDirection.Forward, NodeIds.HasSubtype, Boolean.valueOf(true), Unsigned.uint((int)NodeClass.DataType.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue()))).collect(Collectors.toList()), maxNodesPerBrowse);
        ArrayList<Tree<DataType>> childTypes = new ArrayList<Tree<DataType>>();
        for (int i = 0; i < parentTypes.size(); ++i) {
            Tree<DataType> tree2 = parentTypes.get(i);
            List<ReferenceDescription> subtypes = parentSubtypes.get(i);
            List<NodeId> dataTypeIds = subtypes.stream().map(reference -> reference.getNodeId().toNodeId(namespaceTable).orElse(NodeId.NULL_VALUE)).collect(Collectors.toList());
            List<List<ReferenceDescription>> encodingReferences = DataTypeTreeBuilder.browseEncodings(client, dataTypeIds, maxNodesPerBrowse);
            List<Attributes> dataTypeAttributes = DataTypeTreeBuilder.readDataTypeAttributes(client, dataTypeIds, maxNodesPerRead);
            assert (subtypes.size() == dataTypeIds.size() && subtypes.size() == encodingReferences.size() && subtypes.size() == dataTypeAttributes.size());
            ArrayList<ClientDataType> dataTypes = new ArrayList<ClientDataType>();
            for (int j = 0; j < subtypes.size(); ++j) {
                QualifiedName browseName = subtypes.get(j).getBrowseName();
                NodeId dataTypeId = dataTypeIds.get(j);
                List<ReferenceDescription> encodings = encodingReferences.get(j);
                DataTypeDefinition dataTypeDefinition = dataTypeAttributes.get((int)j).definition;
                Boolean isAbstract = dataTypeAttributes.get((int)j).isAbstract;
                NodeId binaryEncodingId = null;
                NodeId xmlEncodingId = null;
                NodeId jsonEncodingId = null;
                for (ReferenceDescription r : encodings) {
                    if (r.getBrowseName().equals((Object)DataTypeEncoding.BINARY_ENCODING_NAME) || Objects.equals(r.getBrowseName().name(), "Default Binary")) {
                        binaryEncodingId = r.getNodeId().toNodeId(namespaceTable).orElse(null);
                        continue;
                    }
                    if (r.getBrowseName().equals((Object)DataTypeEncoding.XML_ENCODING_NAME) || Objects.equals(r.getBrowseName().name(), "Default XML")) {
                        xmlEncodingId = r.getNodeId().toNodeId(namespaceTable).orElse(null);
                        continue;
                    }
                    if (!r.getBrowseName().equals((Object)DataTypeEncoding.JSON_ENCODING_NAME) && !Objects.equals(r.getBrowseName().name(), "Default JSON")) continue;
                    jsonEncodingId = r.getNodeId().toNodeId(namespaceTable).orElse(null);
                }
                ClientDataType dataType = new ClientDataType(browseName, dataTypeId, binaryEncodingId, xmlEncodingId, jsonEncodingId, dataTypeDefinition, isAbstract);
                dataTypes.add(dataType);
                LOGGER.debug("Added DataType: {}", (Object)dataType.getBrowseName().toParseableString());
            }
            for (ClientDataType dataType : dataTypes) {
                Tree childNode = tree2.addChild((Object)dataType);
                childTypes.add((Tree<DataType>)childNode);
            }
        }
        if (!childTypes.isEmpty()) {
            DataTypeTreeBuilder.addChildren(childTypes, client, namespaceTable, maxNodesPerBrowse, maxNodesPerRead);
        }
    }

    private static List<List<ReferenceDescription>> browse(OpcUaClient client, List<BrowseDescription> browseDescriptions) {
        if (browseDescriptions.isEmpty()) {
            return List.of();
        }
        ArrayList<List<ReferenceDescription>> referenceDescriptionLists = new ArrayList<List<ReferenceDescription>>();
        try {
            client.browse(browseDescriptions).forEach(result -> {
                if (result.getStatusCode().isGood()) {
                    ArrayList<ReferenceDescription> references = new ArrayList<ReferenceDescription>();
                    ReferenceDescription[] refs = Objects.requireNonNullElse(result.getReferences(), new ReferenceDescription[0]);
                    Collections.addAll(references, refs);
                    ByteString continuationPoint = result.getContinuationPoint();
                    List<ReferenceDescription> nextRefs = DataTypeTreeBuilder.maybeBrowseNext(client, continuationPoint);
                    references.addAll(nextRefs);
                    referenceDescriptionLists.add(references);
                } else {
                    referenceDescriptionLists.add(List.of());
                }
            });
        }
        catch (UaException e) {
            referenceDescriptionLists.addAll(Collections.nCopies(browseDescriptions.size(), List.of()));
        }
        return referenceDescriptionLists;
    }

    private static List<ReferenceDescription> maybeBrowseNext(OpcUaClient client, ByteString continuationPoint) {
        ArrayList<ReferenceDescription> references = new ArrayList<ReferenceDescription>();
        while (continuationPoint != null && continuationPoint.isNotNull()) {
            try {
                BrowseNextResponse response = client.browseNext(false, List.of(continuationPoint));
                BrowseResult result = Objects.requireNonNull(response.getResults())[0];
                ReferenceDescription[] rds = Objects.requireNonNullElse(result.getReferences(), new ReferenceDescription[0]);
                references.addAll(List.of(rds));
                continuationPoint = result.getContinuationPoint();
            }
            catch (Exception e) {
                LOGGER.warn("BrowseNext failed: {}", (Object)e.getMessage(), (Object)e);
                return references;
            }
        }
        return references;
    }

    private static List<List<ReferenceDescription>> browseEncodings(OpcUaClient client, List<NodeId> dataTypeIds, UInteger maxNodesPerBrowse) {
        List<BrowseDescription> browseDescriptions = dataTypeIds.stream().map(dataTypeId -> new BrowseDescription(dataTypeId, BrowseDirection.Forward, NodeIds.HasEncoding, Boolean.valueOf(false), Unsigned.uint((int)NodeClass.Object.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue()))).collect(Collectors.toList());
        return DataTypeTreeBuilder.browseWithOperationLimits(client, browseDescriptions, maxNodesPerBrowse);
    }

    private static List<@Nullable Attributes> readDataTypeAttributes(OpcUaClient client, List<NodeId> dataTypeIds, UInteger maxNodesPerRead) {
        if (dataTypeIds.isEmpty()) {
            return List.of();
        }
        ArrayList<ReadValueId> readValueIds = new ArrayList<ReadValueId>();
        for (NodeId dataTypeId : dataTypeIds) {
            readValueIds.add(new ReadValueId(dataTypeId, AttributeId.IsAbstract.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(dataTypeId, AttributeId.DataTypeDefinition.uid(), null, QualifiedName.NULL_VALUE));
        }
        ArrayList<Attributes> attributes = new ArrayList<Attributes>();
        List<DataValue> values = DataTypeTreeBuilder.readWithOperationLimits(client, readValueIds, maxNodesPerRead);
        for (int i = 0; i < values.size(); i += 2) {
            Object o;
            DataValue isAbstractValue = values.get(i);
            DataValue definitionValue = values.get(i + 1);
            Boolean isAbstract = false;
            DataTypeDefinition definition = null;
            if (isAbstractValue.statusCode().isGood()) {
                isAbstract = (Boolean)isAbstractValue.value().value();
            }
            if (definitionValue.statusCode().isGood() && (o = definitionValue.value().value()) instanceof ExtensionObject) {
                ExtensionObject xo = (ExtensionObject)o;
                try {
                    UaStructuredType decoded = xo.decode(client.getStaticEncodingContext());
                    definition = (DataTypeDefinition)decoded;
                }
                catch (Exception e) {
                    LOGGER.debug("Error decoding DataTypeDefinition: {}", (Object)e.getMessage());
                }
            }
            attributes.add(new Attributes(isAbstract, definition));
        }
        return attributes;
    }

    private static UInteger[] readOperationLimits(OpcUaClient client) throws UaException {
        DataValue maxNodesPerRead;
        UInteger[] operationLimits = new UInteger[]{Unsigned.uint((int)10), Unsigned.uint((int)100)};
        List<DataValue> dataValues = client.readValues(0.0, TimestampsToReturn.Neither, List.of(NodeIds.OperationLimitsType_MaxNodesPerBrowse, NodeIds.OperationLimitsType_MaxNodesPerRead));
        DataValue maxNodesPerBrowse = dataValues.get(0);
        if (maxNodesPerBrowse.statusCode().isGood() && maxNodesPerBrowse.value().value() instanceof UInteger) {
            operationLimits[0] = (UInteger)maxNodesPerBrowse.value().value();
        }
        if ((maxNodesPerRead = dataValues.get(1)).statusCode().isGood() && dataValues.get(1).value().value() instanceof UInteger) {
            operationLimits[1] = (UInteger)maxNodesPerRead.value().value();
        }
        return operationLimits;
    }

    private static List<DataValue> readWithOperationLimits(OpcUaClient client, List<ReadValueId> readValueIds, UInteger maxNodesPerRead) {
        int partitionSize;
        if (readValueIds.isEmpty()) {
            return List.of();
        }
        LOGGER.debug("readWithOperationLimits: {}", (Object)readValueIds.size());
        int n = partitionSize = maxNodesPerRead.longValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : maxNodesPerRead.intValue();
        if (partitionSize == 0) {
            partitionSize = Integer.MAX_VALUE;
        }
        ArrayList<DataValue> values = new ArrayList<DataValue>();
        Lists.partition(readValueIds, (int)partitionSize).forEach(partition -> {
            try {
                ReadResponse response = client.read(0.0, TimestampsToReturn.Neither, (List<ReadValueId>)partition);
                DataValue[] results = response.getResults();
                Collections.addAll(values, Objects.requireNonNull(results));
            }
            catch (UaException e) {
                DataValue value = new DataValue(e.getStatusCode());
                values.addAll(Collections.nCopies(partition.size(), value));
            }
        });
        return values;
    }

    private static List<List<ReferenceDescription>> browseWithOperationLimits(OpcUaClient client, List<BrowseDescription> browseDescriptions, UInteger maxNodesPerBrowse) {
        int partitionSize;
        if (browseDescriptions.isEmpty()) {
            return List.of();
        }
        LOGGER.debug("browseWithOperationLimits: {}", (Object)browseDescriptions.size());
        int n = partitionSize = maxNodesPerBrowse.longValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : maxNodesPerBrowse.intValue();
        if (partitionSize == 0) {
            partitionSize = Integer.MAX_VALUE;
        }
        ArrayList<List<ReferenceDescription>> references = new ArrayList<List<ReferenceDescription>>();
        Lists.partition(browseDescriptions, (int)partitionSize).forEach(partition -> references.addAll(DataTypeTreeBuilder.browse(client, partition)));
        return references;
    }

    private static class Attributes {
        final Boolean isAbstract;
        final DataTypeDefinition definition;

        private Attributes(Boolean isAbstract, DataTypeDefinition definition) {
            this.isAbstract = isAbstract;
            this.definition = definition;
        }
    }
}

