/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.client.AddressSpace;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.UaEnumeratedType;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathResult;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathTarget;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePathElement;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.jspecify.annotations.Nullable;

public abstract class UaNode
implements Node {
    private NodeId nodeId;
    private NodeClass nodeClass;
    private QualifiedName browseName;
    private LocalizedText displayName;
    private LocalizedText description;
    private UInteger writeMask;
    private UInteger userWriteMask;
    private RolePermissionType[] rolePermissions;
    private RolePermissionType[] userRolePermissions;
    private AccessRestrictionType accessRestrictions;
    protected final OpcUaClient client;

    public UaNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        this.client = client;
        this.nodeId = nodeId;
        this.nodeClass = nodeClass;
        this.browseName = browseName;
        this.displayName = displayName;
        this.description = description;
        this.writeMask = writeMask;
        this.userWriteMask = userWriteMask;
    }

    public UaNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions) {
        this.client = client;
        this.nodeId = nodeId;
        this.nodeClass = nodeClass;
        this.browseName = browseName;
        this.displayName = displayName;
        this.description = description;
        this.writeMask = writeMask;
        this.userWriteMask = userWriteMask;
        this.rolePermissions = rolePermissions;
        this.userRolePermissions = userRolePermissions;
        this.accessRestrictions = accessRestrictions;
    }

    public synchronized NodeId getNodeId() {
        return this.nodeId;
    }

    public synchronized NodeClass getNodeClass() {
        return this.nodeClass;
    }

    public synchronized QualifiedName getBrowseName() {
        return this.browseName;
    }

    public synchronized LocalizedText getDisplayName() {
        return this.displayName;
    }

    public synchronized @Nullable LocalizedText getDescription() {
        return this.description;
    }

    public synchronized @Nullable UInteger getWriteMask() {
        return this.writeMask;
    }

    public synchronized @Nullable UInteger getUserWriteMask() {
        return this.userWriteMask;
    }

    public synchronized @Nullable RolePermissionType[] getRolePermissions() {
        return this.rolePermissions;
    }

    public synchronized @Nullable RolePermissionType[] getUserRolePermissions() {
        return this.userRolePermissions;
    }

    public synchronized @Nullable AccessRestrictionType getAccessRestrictions() {
        return this.accessRestrictions;
    }

    public synchronized void setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
    }

    public synchronized void setNodeClass(NodeClass nodeClass) {
        this.nodeClass = nodeClass;
    }

    public synchronized void setBrowseName(QualifiedName browseName) {
        this.browseName = browseName;
    }

    public synchronized void setDisplayName(LocalizedText displayName) {
        this.displayName = displayName;
    }

    public synchronized void setDescription(LocalizedText description) {
        this.description = description;
    }

    public synchronized void setWriteMask(UInteger writeMask) {
        this.writeMask = writeMask;
    }

    public synchronized void setUserWriteMask(UInteger userWriteMask) {
        this.userWriteMask = userWriteMask;
    }

    public synchronized void setRolePermissions(RolePermissionType[] rolePermissions) {
        this.rolePermissions = rolePermissions;
    }

    public synchronized void setUserRolePermissions(RolePermissionType[] userRolePermissions) {
        this.userRolePermissions = userRolePermissions;
    }

    public synchronized void setAccessRestrictions(AccessRestrictionType accessRestrictions) {
        this.accessRestrictions = accessRestrictions;
    }

    public NodeId readNodeId() throws UaException {
        DataValue value = this.readAttribute(AttributeId.NodeId);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read NodeId failed");
        }
        NodeId nodeId = (NodeId)value.value().value();
        this.setNodeId(nodeId);
        return nodeId;
    }

    public NodeClass readNodeClass() throws UaException {
        DataValue value = this.readAttribute(AttributeId.NodeClass);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read NodeClass failed");
        }
        Integer i = Objects.requireNonNullElse(value.value().value(), 0);
        NodeClass nodeClass = NodeClass.from((int)i);
        this.setNodeClass(nodeClass);
        return nodeClass;
    }

    public QualifiedName readBrowseName() throws UaException {
        DataValue value = this.readAttribute(AttributeId.BrowseName);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read BrowseName failed");
        }
        QualifiedName browseName = (QualifiedName)value.value().value();
        this.setBrowseName(browseName);
        return browseName;
    }

    public LocalizedText readDisplayName() throws UaException {
        DataValue value = this.readAttribute(AttributeId.DisplayName);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read DisplayName failed");
        }
        LocalizedText displayName = (LocalizedText)value.value().value();
        this.setDisplayName(displayName);
        return displayName;
    }

    public @Nullable LocalizedText readDescription() throws UaException {
        DataValue value = this.readAttribute(AttributeId.Description);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read Description failed");
        }
        LocalizedText description = (LocalizedText)value.value().value();
        this.setDescription(description);
        return description;
    }

    public @Nullable UInteger readWriteMask() throws UaException {
        DataValue value = this.readAttribute(AttributeId.UserWriteMask);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read WriteMask failed");
        }
        UInteger writeMask = (UInteger)value.value().value();
        this.setWriteMask(writeMask);
        return writeMask;
    }

    public @Nullable UInteger readUserWriteMask() throws UaException {
        DataValue value = this.readAttribute(AttributeId.UserWriteMask);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read UserWriteMask failed");
        }
        UInteger userWriteMask = (UInteger)value.value().value();
        this.setUserWriteMask(userWriteMask);
        return userWriteMask;
    }

    public @Nullable RolePermissionType[] readRolePermissions() throws UaException {
        DataValue value = this.readAttribute(AttributeId.RolePermissions);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read RolePermissions failed");
        }
        RolePermissionType[] rolePermissions = this.cast(value.value().value(), RolePermissionType[].class);
        this.setRolePermissions(rolePermissions);
        return rolePermissions;
    }

    public @Nullable RolePermissionType[] readUserRolePermissions() throws UaException {
        DataValue value = this.readAttribute(AttributeId.UserRolePermissions);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read UserRolePermissions failed");
        }
        RolePermissionType[] userRolePermissions = this.cast(value.value().value(), RolePermissionType[].class);
        this.setUserRolePermissions(userRolePermissions);
        return userRolePermissions;
    }

    public @Nullable AccessRestrictionType readAccessRestrictions() throws UaException {
        DataValue value = this.readAttribute(AttributeId.AccessRestrictions);
        StatusCode statusCode = value.statusCode();
        if (statusCode.isBad()) {
            throw new UaException(statusCode, "read AccessRestriction failed");
        }
        AccessRestrictionType accessRestrictions = new AccessRestrictionType((UShort)value.value().value());
        this.setAccessRestrictions(accessRestrictions);
        return accessRestrictions;
    }

    public void writeNodeId(NodeId nodeId) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)nodeId));
        StatusCode statusCode = this.writeAttribute(AttributeId.NodeId, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write NodeId failed");
        }
        this.setNodeId(nodeId);
    }

    public void writeNodeClass(NodeClass nodeClass) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)nodeClass));
        StatusCode statusCode = this.writeAttribute(AttributeId.NodeClass, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write NodeClass failed");
        }
        this.setNodeClass(nodeClass);
    }

    public void writeBrowseName(QualifiedName browseName) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)browseName));
        StatusCode statusCode = this.writeAttribute(AttributeId.BrowseName, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write BrowseName failed");
        }
        this.setBrowseName(browseName);
    }

    public void writeDisplayName(LocalizedText displayName) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)displayName));
        StatusCode statusCode = this.writeAttribute(AttributeId.DisplayName, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write DisplayName failed");
        }
        this.setDisplayName(displayName);
    }

    public void writeDescription(LocalizedText description) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)description));
        StatusCode statusCode = this.writeAttribute(AttributeId.Description, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write Description failed");
        }
        this.setDescription(description);
    }

    public void writeWriteMask(UInteger writeMask) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)writeMask));
        StatusCode statusCode = this.writeAttribute(AttributeId.WriteMask, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write WriteMask failed");
        }
        this.setWriteMask(writeMask);
    }

    public void writeUserWriteMask(UInteger userWriteMask) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)userWriteMask));
        StatusCode statusCode = this.writeAttribute(AttributeId.UserWriteMask, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write UserWriteMask failed");
        }
        this.setUserWriteMask(userWriteMask);
    }

    public void writeRolePermissions(RolePermissionType[] rolePermissions) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)rolePermissions));
        StatusCode statusCode = this.writeAttribute(AttributeId.RolePermissions, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write RolePermissions failed");
        }
        this.setRolePermissions(rolePermissions);
    }

    public void writeUserRolePermissions(RolePermissionType[] userRolePermissions) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)userRolePermissions));
        StatusCode statusCode = this.writeAttribute(AttributeId.UserRolePermissions, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write UserRolePermissions failed");
        }
        this.setUserRolePermissions(userRolePermissions);
    }

    public void writeAccessRestrictions(AccessRestrictionType accessRestrictions) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)accessRestrictions.getValue()));
        StatusCode statusCode = this.writeAttribute(AttributeId.AccessRestrictions, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write AccessRestrictions failed");
        }
        this.setAccessRestrictions(accessRestrictions);
    }

    public DataValue readAttribute(AttributeId attributeId) throws UaException {
        try {
            return this.readAttributeAsync(attributeId).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public StatusCode writeAttribute(AttributeId attributeId, DataValue value) throws UaException {
        try {
            return this.writeAttributeAsync(attributeId, value).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<DataValue> readAttributeAsync(AttributeId attributeId) {
        ReadValueId readValueId = new ReadValueId(this.getNodeId(), attributeId.uid(), null, QualifiedName.NULL_VALUE);
        CompletableFuture<ReadResponse> future = this.client.readAsync(0.0, TimestampsToReturn.Both, List.of(readValueId));
        return future.thenApply(response -> Objects.requireNonNull(response.getResults())[0]);
    }

    public CompletableFuture<StatusCode> writeAttributeAsync(AttributeId attributeId, DataValue value) {
        WriteValue writeValue = new WriteValue(this.getNodeId(), attributeId.uid(), null, value);
        CompletableFuture<WriteResponse> future = this.client.writeAsync(List.of(writeValue));
        return future.thenApply(response -> Objects.requireNonNull(response.getResults())[0]);
    }

    public List<ReferenceDescription> browse() throws UaException {
        return this.browse(this.client.getAddressSpace().getBrowseOptions());
    }

    public List<ReferenceDescription> browse(AddressSpace.BrowseOptions browseOptions) throws UaException {
        return this.client.getAddressSpace().browse(this, browseOptions);
    }

    public CompletableFuture<List<ReferenceDescription>> browseAsync() {
        return this.browseAsync(this.client.getAddressSpace().getBrowseOptions());
    }

    public CompletableFuture<List<ReferenceDescription>> browseAsync(AddressSpace.BrowseOptions browseOptions) {
        return this.client.getAddressSpace().browseAsync(this, browseOptions);
    }

    public List<? extends UaNode> browseNodes() throws UaException {
        return this.browseNodes(this.client.getAddressSpace().getBrowseOptions());
    }

    public List<? extends UaNode> browseNodes(AddressSpace.BrowseOptions browseOptions) throws UaException {
        return this.client.getAddressSpace().browseNodes(this, browseOptions);
    }

    public CompletableFuture<List<? extends UaNode>> browseNodesAsync() {
        return this.browseNodesAsync(this.client.getAddressSpace().getBrowseOptions());
    }

    public CompletableFuture<List<? extends UaNode>> browseNodesAsync(AddressSpace.BrowseOptions browseOptions) {
        return this.client.getAddressSpace().browseNodesAsync(this, browseOptions);
    }

    public List<DataValue> refresh(Set<AttributeId> attributeIds) throws UaException {
        try {
            return this.refreshAsync(attributeIds).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    public CompletableFuture<List<DataValue>> refreshAsync(Set<AttributeId> attributeIds) {
        List<ReadValueId> readValueIds = attributeIds.stream().map(id -> new ReadValueId(this.nodeId, id.uid(), null, QualifiedName.NULL_VALUE)).collect(Collectors.toList());
        CompletableFuture<ReadResponse> future = this.client.readAsync(0.0, TimestampsToReturn.Neither, readValueIds);
        return future.thenApply(response -> {
            DataValue[] values = Objects.requireNonNullElse(response.getResults(), new DataValue[0]);
            assert (attributeIds.size() == values.length);
            Iterator ai = attributeIds.iterator();
            Iterator vi = Arrays.stream(values).iterator();
            UaNode uaNode = this;
            synchronized (uaNode) {
                if (ai.hasNext() && vi.hasNext()) {
                    AttributeId attributeId = (AttributeId)ai.next();
                    DataValue value = (DataValue)vi.next();
                    StatusCode statusCode = value.statusCode();
                    if (statusCode.isGood()) {
                        this.setAttributeValue(attributeId, value);
                    }
                }
            }
            return List.of(values);
        });
    }

    public List<StatusCode> synchronize(Set<AttributeId> attributeIds) throws UaException {
        try {
            return this.synchronizeAsync(attributeIds).get();
        }
        catch (ExecutionException e) {
            throw new UaException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UaException(0x80010000L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<List<StatusCode>> synchronizeAsync(Set<AttributeId> attributeIds) {
        List<WriteValue> writeValues;
        UaNode uaNode = this;
        synchronized (uaNode) {
            writeValues = attributeIds.stream().map(id -> new WriteValue(this.nodeId, id.uid(), null, this.getAttributeValue((AttributeId)id))).collect(Collectors.toList());
        }
        return this.client.writeAsync(writeValues).thenApply(response -> {
            StatusCode[] results = Objects.requireNonNullElse(response.getResults(), new StatusCode[0]);
            return List.of(results);
        });
    }

    public UaNode canonicalize() {
        return this.client.getAddressSpace().getNodeCache().canonicalize(this);
    }

    public UaNode invalidate() {
        this.client.getAddressSpace().getNodeCache().invalidate(this.nodeId);
        return this;
    }

    protected DataValue getAttributeValue(AttributeId attributeId) {
        return switch (attributeId) {
            case AttributeId.NodeId -> DataValue.valueOnly((Variant)new Variant((Object)this.getNodeId()));
            case AttributeId.NodeClass -> DataValue.valueOnly((Variant)new Variant((Object)this.getNodeClass().getValue()));
            case AttributeId.BrowseName -> DataValue.valueOnly((Variant)new Variant((Object)this.getBrowseName()));
            case AttributeId.DisplayName -> DataValue.valueOnly((Variant)new Variant((Object)this.getDisplayName()));
            case AttributeId.Description -> DataValue.valueOnly((Variant)new Variant((Object)this.getDescription()));
            case AttributeId.WriteMask -> DataValue.valueOnly((Variant)new Variant((Object)this.getWriteMask()));
            case AttributeId.UserWriteMask -> DataValue.valueOnly((Variant)new Variant((Object)this.getUserWriteMask()));
            case AttributeId.RolePermissions -> DataValue.valueOnly((Variant)new Variant((Object)this.getRolePermissions()));
            case AttributeId.UserRolePermissions -> DataValue.valueOnly((Variant)new Variant((Object)this.getUserRolePermissions()));
            case AttributeId.AccessRestrictions -> DataValue.valueOnly((Variant)new Variant((Object)this.getAccessRestrictions().getValue()));
            default -> throw new IllegalArgumentException("attributeId: " + String.valueOf(attributeId));
        };
    }

    protected void setAttributeValue(AttributeId attributeId, DataValue value) {
        switch (attributeId) {
            case NodeId: {
                this.setNodeId((NodeId)value.value().value());
                break;
            }
            case NodeClass: {
                Integer i = Objects.requireNonNullElse(value.value().value(), 0);
                NodeClass nodeClass = NodeClass.from((int)i);
                this.setNodeClass(nodeClass);
                break;
            }
            case BrowseName: {
                this.setBrowseName((QualifiedName)value.value().value());
                break;
            }
            case DisplayName: {
                this.setDisplayName((LocalizedText)value.value().value());
                break;
            }
            case Description: {
                this.setDescription((LocalizedText)value.value().value());
                break;
            }
            case WriteMask: {
                this.setWriteMask((UInteger)value.value().value());
                break;
            }
            case UserWriteMask: {
                this.setUserWriteMask((UInteger)value.value().value());
                break;
            }
            case RolePermissions: {
                this.setRolePermissions((RolePermissionType[])value.value().value());
                break;
            }
            case UserRolePermissions: {
                this.setUserRolePermissions((RolePermissionType[])value.value().value());
                break;
            }
            case AccessRestrictions: {
                this.setAccessRestrictions(new AccessRestrictionType((UShort)value.value().value()));
                break;
            }
            default: {
                throw new IllegalArgumentException("attributeId: " + String.valueOf(attributeId));
            }
        }
    }

    protected CompletableFuture<UaNode> getMemberNodeAsync(String namespaceUri, String name, ExpandedNodeId referenceTypeId, boolean includeSubtypes) {
        return this.readNamespaceIndex(namespaceUri).thenCompose(index -> {
            QualifiedName qualifiedName = new QualifiedName(index, name);
            return this.findMemberNodeId(qualifiedName, referenceTypeId, includeSubtypes).thenCompose(nodeXni -> {
                AddressSpace addressSpace = this.client.getAddressSpace();
                return ((CompletableFuture)addressSpace.toNodeIdAsync((ExpandedNodeId)nodeXni).thenCompose(addressSpace::getNodeAsync)).thenApply(UaNode.class::cast);
            });
        });
    }

    protected CompletableFuture<ExpandedNodeId> findMemberNodeId(QualifiedName name, ExpandedNodeId referenceTypeId, boolean includeSubtypes) {
        ArrayList<BrowsePath> browsePaths = new ArrayList<BrowsePath>();
        try {
            browsePaths.add(new BrowsePath(this.getNodeId(), new RelativePath(new RelativePathElement[]{new RelativePathElement(referenceTypeId.toNodeIdOrThrow(this.client.getNamespaceTable()), Boolean.valueOf(false), Boolean.valueOf(includeSubtypes), name)})));
        }
        catch (Exception e) {
            return FutureUtils.failedFuture((Throwable)e);
        }
        return this.client.translateBrowsePathsAsync(browsePaths).thenCompose(r -> {
            BrowsePathResult result = Objects.requireNonNull(r.getResults())[0];
            if (result.getStatusCode().isGood()) {
                BrowsePathTarget[] targets = Objects.requireNonNull(result.getTargets());
                return CompletableFuture.completedFuture(targets[0].getTargetId());
            }
            return FutureUtils.failedUaFuture((StatusCode)result.getStatusCode());
        });
    }

    protected CompletableFuture<UShort> readNamespaceIndex(String namespaceUri) {
        UShort namespaceIndex = (UShort)this.client.getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return CompletableFuture.completedFuture(namespaceIndex);
        }
        return this.client.readNamespaceTableAsync().thenCompose(namespaceTable -> {
            UShort index = (UShort)this.client.getNamespaceTable().getIndex(namespaceUri);
            if (index != null) {
                return CompletableFuture.completedFuture(index);
            }
            return FutureUtils.failedFuture((Throwable)new Exception("unknown namespace: " + namespaceUri));
        });
    }

    protected CompletableFuture<? extends UaNode> getComponentAsync(QualifiedName browseName, NodeClass nodeClass) {
        UInteger nodeClassMask = Unsigned.uint((int)nodeClass.getValue());
        UInteger resultMask = Unsigned.uint((int)BrowseResultMask.All.getValue());
        CompletableFuture<BrowseResult> future = this.client.browseAsync(new BrowseDescription(this.getNodeId(), BrowseDirection.Forward, NodeIds.HasComponent, Boolean.valueOf(false), nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            ReferenceDescription[] references = Objects.requireNonNullElse(result.getReferences(), new ReferenceDescription[0]);
            Optional node = Stream.of(references).filter(r -> browseName.equals((Object)r.getBrowseName())).flatMap(r -> {
                Optional<CompletableFuture> opt = r.getNodeId().toNodeId(this.client.getNamespaceTable()).map(id -> this.client.getAddressSpace().getNodeAsync((NodeId)id));
                return opt.stream();
            }).findFirst();
            return node.orElse(FutureUtils.failedUaFuture((long)2151546880L));
        });
    }

    protected CompletableFuture<PropertyTypeNode> getPropertyNodeAsync(QualifiedProperty<?> property) {
        return property.getQualifiedName(this.client.getNamespaceTable()).map(this::getPropertyNodeAsync).orElse(FutureUtils.failedUaFuture((long)2151546880L));
    }

    protected CompletableFuture<PropertyTypeNode> getPropertyNodeAsync(QualifiedName browseName) {
        UInteger nodeClassMask = Unsigned.uint((int)NodeClass.Variable.getValue());
        UInteger resultMask = Unsigned.uint((int)BrowseResultMask.BrowseName.getValue());
        CompletableFuture<BrowseResult> future = this.client.browseAsync(new BrowseDescription(this.getNodeId(), BrowseDirection.Forward, NodeIds.HasProperty, Boolean.valueOf(false), nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            ReferenceDescription[] references = Objects.requireNonNullElse(result.getReferences(), new ReferenceDescription[0]);
            Optional node = Stream.of(references).filter(r -> browseName.equals((Object)r.getBrowseName())).flatMap(r -> {
                Optional<CompletableFuture> opt = r.getNodeId().toNodeId(this.client.getNamespaceTable()).map(id -> this.client.getAddressSpace().getNodeAsync((NodeId)id).thenApply(n -> (PropertyTypeNode)n));
                return opt.stream();
            }).findFirst();
            return node.orElse(FutureUtils.failedUaFuture((long)2151546880L));
        });
    }

    public <T> CompletableFuture<T> getProperty(QualifiedProperty<T> property) {
        return ((CompletableFuture)this.getPropertyNodeAsync(property).thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(value -> this.cast(value.value().value(), property.getJavaType()));
    }

    protected <T> CompletableFuture<StatusCode> setProperty(QualifiedProperty<T> property, T value) {
        return this.getPropertyNodeAsync(property).thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, DataValue.valueOnly((Variant)new Variant(value))));
    }

    protected CompletableFuture<DataValue> readProperty(QualifiedProperty<?> property) {
        return this.getPropertyNodeAsync(property).thenCompose(node -> node.readAttributeAsync(AttributeId.Value));
    }

    protected CompletableFuture<StatusCode> writeProperty(QualifiedProperty<?> property, DataValue value) {
        return this.getPropertyNodeAsync(property).thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    protected <T> T cast(Object o, Class<T> clazz) {
        if (UaEnumeratedType.class.isAssignableFrom(clazz) && o instanceof Integer) {
            Integer i = (Integer)o;
            try {
                Object enumeration = clazz.getMethod("from", Integer.class).invoke(null, i);
                return clazz.cast(enumeration);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }
        if (o instanceof ExtensionObject) {
            ExtensionObject xo = (ExtensionObject)o;
            UaStructuredType decoded = xo.decode(this.client.getStaticEncodingContext());
            return clazz.cast(decoded);
        }
        if (o instanceof ExtensionObject[]) {
            ExtensionObject[] xos = (ExtensionObject[])o;
            Class<?> componentType = clazz.getComponentType();
            Object array = Array.newInstance(componentType, xos.length);
            for (int i = 0; i < xos.length; ++i) {
                ExtensionObject xo = xos[i];
                UaStructuredType decoded = xo.decode(this.client.getStaticEncodingContext());
                Array.set(array, i, componentType.cast(decoded));
            }
            return clazz.cast(array);
        }
        return clazz.cast(o);
    }
}

