/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.SubscriptionDiagnosticsType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class SubscriptionDiagnosticsTypeNode
extends BaseDataVariableTypeNode
implements SubscriptionDiagnosticsType {
    public SubscriptionDiagnosticsTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public NodeId getSessionId() throws UaException {
        BaseDataVariableTypeNode node = this.getSessionIdNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setSessionId(NodeId value) throws UaException {
        BaseDataVariableTypeNode node = this.getSessionIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readSessionId() throws UaException {
        try {
            return this.readSessionIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSessionId(NodeId value) throws UaException {
        try {
            this.writeSessionIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readSessionIdAsync() {
        return ((CompletableFuture)this.getSessionIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSessionIdAsync(NodeId sessionId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sessionId));
        return this.getSessionIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSessionIdNode() throws UaException {
        try {
            return this.getSessionIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSessionIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SessionId", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getSubscriptionId() throws UaException {
        BaseDataVariableTypeNode node = this.getSubscriptionIdNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setSubscriptionId(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getSubscriptionIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readSubscriptionId() throws UaException {
        try {
            return this.readSubscriptionIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSubscriptionId(UInteger value) throws UaException {
        try {
            this.writeSubscriptionIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readSubscriptionIdAsync() {
        return ((CompletableFuture)this.getSubscriptionIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSubscriptionIdAsync(UInteger subscriptionId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)subscriptionId));
        return this.getSubscriptionIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSubscriptionIdNode() throws UaException {
        try {
            return this.getSubscriptionIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSubscriptionIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SubscriptionId", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UByte getPriority() throws UaException {
        BaseDataVariableTypeNode node = this.getPriorityNode();
        return (UByte)node.getValue().getValue().getValue();
    }

    @Override
    public void setPriority(UByte value) throws UaException {
        BaseDataVariableTypeNode node = this.getPriorityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte readPriority() throws UaException {
        try {
            return this.readPriorityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePriority(UByte value) throws UaException {
        try {
            this.writePriorityAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UByte> readPriorityAsync() {
        return ((CompletableFuture)this.getPriorityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePriorityAsync(UByte priority) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)priority));
        return this.getPriorityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPriorityNode() throws UaException {
        try {
            return this.getPriorityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPriorityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Priority", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Double getPublishingInterval() throws UaException {
        BaseDataVariableTypeNode node = this.getPublishingIntervalNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setPublishingInterval(Double value) throws UaException {
        BaseDataVariableTypeNode node = this.getPublishingIntervalNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readPublishingInterval() throws UaException {
        try {
            return this.readPublishingIntervalAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePublishingInterval(Double value) throws UaException {
        try {
            this.writePublishingIntervalAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readPublishingIntervalAsync() {
        return ((CompletableFuture)this.getPublishingIntervalNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePublishingIntervalAsync(Double publishingInterval) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)publishingInterval));
        return this.getPublishingIntervalNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPublishingIntervalNode() throws UaException {
        try {
            return this.getPublishingIntervalNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPublishingIntervalNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PublishingInterval", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getMaxKeepAliveCount() throws UaException {
        BaseDataVariableTypeNode node = this.getMaxKeepAliveCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxKeepAliveCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getMaxKeepAliveCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxKeepAliveCount() throws UaException {
        try {
            return this.readMaxKeepAliveCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxKeepAliveCount(UInteger value) throws UaException {
        try {
            this.writeMaxKeepAliveCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxKeepAliveCountAsync() {
        return ((CompletableFuture)this.getMaxKeepAliveCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxKeepAliveCountAsync(UInteger maxKeepAliveCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxKeepAliveCount));
        return this.getMaxKeepAliveCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMaxKeepAliveCountNode() throws UaException {
        try {
            return this.getMaxKeepAliveCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMaxKeepAliveCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxKeepAliveCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getMaxLifetimeCount() throws UaException {
        BaseDataVariableTypeNode node = this.getMaxLifetimeCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxLifetimeCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getMaxLifetimeCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxLifetimeCount() throws UaException {
        try {
            return this.readMaxLifetimeCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxLifetimeCount(UInteger value) throws UaException {
        try {
            this.writeMaxLifetimeCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxLifetimeCountAsync() {
        return ((CompletableFuture)this.getMaxLifetimeCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxLifetimeCountAsync(UInteger maxLifetimeCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxLifetimeCount));
        return this.getMaxLifetimeCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMaxLifetimeCountNode() throws UaException {
        try {
            return this.getMaxLifetimeCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMaxLifetimeCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxLifetimeCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getMaxNotificationsPerPublish() throws UaException {
        BaseDataVariableTypeNode node = this.getMaxNotificationsPerPublishNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNotificationsPerPublish(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getMaxNotificationsPerPublishNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNotificationsPerPublish() throws UaException {
        try {
            return this.readMaxNotificationsPerPublishAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNotificationsPerPublish(UInteger value) throws UaException {
        try {
            this.writeMaxNotificationsPerPublishAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNotificationsPerPublishAsync() {
        return ((CompletableFuture)this.getMaxNotificationsPerPublishNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNotificationsPerPublishAsync(UInteger maxNotificationsPerPublish) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNotificationsPerPublish));
        return this.getMaxNotificationsPerPublishNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMaxNotificationsPerPublishNode() throws UaException {
        try {
            return this.getMaxNotificationsPerPublishNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMaxNotificationsPerPublishNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNotificationsPerPublish", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Boolean getPublishingEnabled() throws UaException {
        BaseDataVariableTypeNode node = this.getPublishingEnabledNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setPublishingEnabled(Boolean value) throws UaException {
        BaseDataVariableTypeNode node = this.getPublishingEnabledNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readPublishingEnabled() throws UaException {
        try {
            return this.readPublishingEnabledAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePublishingEnabled(Boolean value) throws UaException {
        try {
            this.writePublishingEnabledAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readPublishingEnabledAsync() {
        return ((CompletableFuture)this.getPublishingEnabledNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePublishingEnabledAsync(Boolean publishingEnabled) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)publishingEnabled));
        return this.getPublishingEnabledNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPublishingEnabledNode() throws UaException {
        try {
            return this.getPublishingEnabledNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPublishingEnabledNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PublishingEnabled", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getModifyCount() throws UaException {
        BaseDataVariableTypeNode node = this.getModifyCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setModifyCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getModifyCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readModifyCount() throws UaException {
        try {
            return this.readModifyCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeModifyCount(UInteger value) throws UaException {
        try {
            this.writeModifyCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readModifyCountAsync() {
        return ((CompletableFuture)this.getModifyCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeModifyCountAsync(UInteger modifyCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)modifyCount));
        return this.getModifyCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getModifyCountNode() throws UaException {
        try {
            return this.getModifyCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getModifyCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ModifyCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getEnableCount() throws UaException {
        BaseDataVariableTypeNode node = this.getEnableCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setEnableCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getEnableCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readEnableCount() throws UaException {
        try {
            return this.readEnableCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEnableCount(UInteger value) throws UaException {
        try {
            this.writeEnableCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readEnableCountAsync() {
        return ((CompletableFuture)this.getEnableCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEnableCountAsync(UInteger enableCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)enableCount));
        return this.getEnableCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getEnableCountNode() throws UaException {
        try {
            return this.getEnableCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getEnableCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EnableCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getDisableCount() throws UaException {
        BaseDataVariableTypeNode node = this.getDisableCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setDisableCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getDisableCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readDisableCount() throws UaException {
        try {
            return this.readDisableCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDisableCount(UInteger value) throws UaException {
        try {
            this.writeDisableCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readDisableCountAsync() {
        return ((CompletableFuture)this.getDisableCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDisableCountAsync(UInteger disableCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)disableCount));
        return this.getDisableCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDisableCountNode() throws UaException {
        try {
            return this.getDisableCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDisableCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DisableCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getRepublishRequestCount() throws UaException {
        BaseDataVariableTypeNode node = this.getRepublishRequestCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setRepublishRequestCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getRepublishRequestCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readRepublishRequestCount() throws UaException {
        try {
            return this.readRepublishRequestCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRepublishRequestCount(UInteger value) throws UaException {
        try {
            this.writeRepublishRequestCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readRepublishRequestCountAsync() {
        return ((CompletableFuture)this.getRepublishRequestCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRepublishRequestCountAsync(UInteger republishRequestCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)republishRequestCount));
        return this.getRepublishRequestCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRepublishRequestCountNode() throws UaException {
        try {
            return this.getRepublishRequestCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRepublishRequestCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RepublishRequestCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getRepublishMessageRequestCount() throws UaException {
        BaseDataVariableTypeNode node = this.getRepublishMessageRequestCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setRepublishMessageRequestCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getRepublishMessageRequestCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readRepublishMessageRequestCount() throws UaException {
        try {
            return this.readRepublishMessageRequestCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRepublishMessageRequestCount(UInteger value) throws UaException {
        try {
            this.writeRepublishMessageRequestCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readRepublishMessageRequestCountAsync() {
        return ((CompletableFuture)this.getRepublishMessageRequestCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRepublishMessageRequestCountAsync(UInteger republishMessageRequestCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)republishMessageRequestCount));
        return this.getRepublishMessageRequestCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRepublishMessageRequestCountNode() throws UaException {
        try {
            return this.getRepublishMessageRequestCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRepublishMessageRequestCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RepublishMessageRequestCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getRepublishMessageCount() throws UaException {
        BaseDataVariableTypeNode node = this.getRepublishMessageCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setRepublishMessageCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getRepublishMessageCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readRepublishMessageCount() throws UaException {
        try {
            return this.readRepublishMessageCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRepublishMessageCount(UInteger value) throws UaException {
        try {
            this.writeRepublishMessageCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readRepublishMessageCountAsync() {
        return ((CompletableFuture)this.getRepublishMessageCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRepublishMessageCountAsync(UInteger republishMessageCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)republishMessageCount));
        return this.getRepublishMessageCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRepublishMessageCountNode() throws UaException {
        try {
            return this.getRepublishMessageCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRepublishMessageCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RepublishMessageCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getTransferRequestCount() throws UaException {
        BaseDataVariableTypeNode node = this.getTransferRequestCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setTransferRequestCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getTransferRequestCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readTransferRequestCount() throws UaException {
        try {
            return this.readTransferRequestCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTransferRequestCount(UInteger value) throws UaException {
        try {
            this.writeTransferRequestCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readTransferRequestCountAsync() {
        return ((CompletableFuture)this.getTransferRequestCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTransferRequestCountAsync(UInteger transferRequestCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)transferRequestCount));
        return this.getTransferRequestCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getTransferRequestCountNode() throws UaException {
        try {
            return this.getTransferRequestCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getTransferRequestCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransferRequestCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getTransferredToAltClientCount() throws UaException {
        BaseDataVariableTypeNode node = this.getTransferredToAltClientCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setTransferredToAltClientCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getTransferredToAltClientCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readTransferredToAltClientCount() throws UaException {
        try {
            return this.readTransferredToAltClientCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTransferredToAltClientCount(UInteger value) throws UaException {
        try {
            this.writeTransferredToAltClientCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readTransferredToAltClientCountAsync() {
        return ((CompletableFuture)this.getTransferredToAltClientCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTransferredToAltClientCountAsync(UInteger transferredToAltClientCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)transferredToAltClientCount));
        return this.getTransferredToAltClientCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getTransferredToAltClientCountNode() throws UaException {
        try {
            return this.getTransferredToAltClientCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getTransferredToAltClientCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransferredToAltClientCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getTransferredToSameClientCount() throws UaException {
        BaseDataVariableTypeNode node = this.getTransferredToSameClientCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setTransferredToSameClientCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getTransferredToSameClientCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readTransferredToSameClientCount() throws UaException {
        try {
            return this.readTransferredToSameClientCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTransferredToSameClientCount(UInteger value) throws UaException {
        try {
            this.writeTransferredToSameClientCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readTransferredToSameClientCountAsync() {
        return ((CompletableFuture)this.getTransferredToSameClientCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTransferredToSameClientCountAsync(UInteger transferredToSameClientCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)transferredToSameClientCount));
        return this.getTransferredToSameClientCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getTransferredToSameClientCountNode() throws UaException {
        try {
            return this.getTransferredToSameClientCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getTransferredToSameClientCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransferredToSameClientCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getPublishRequestCount() throws UaException {
        BaseDataVariableTypeNode node = this.getPublishRequestCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setPublishRequestCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getPublishRequestCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readPublishRequestCount() throws UaException {
        try {
            return this.readPublishRequestCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePublishRequestCount(UInteger value) throws UaException {
        try {
            this.writePublishRequestCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readPublishRequestCountAsync() {
        return ((CompletableFuture)this.getPublishRequestCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePublishRequestCountAsync(UInteger publishRequestCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)publishRequestCount));
        return this.getPublishRequestCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPublishRequestCountNode() throws UaException {
        try {
            return this.getPublishRequestCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPublishRequestCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PublishRequestCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getDataChangeNotificationsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getDataChangeNotificationsCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setDataChangeNotificationsCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getDataChangeNotificationsCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readDataChangeNotificationsCount() throws UaException {
        try {
            return this.readDataChangeNotificationsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDataChangeNotificationsCount(UInteger value) throws UaException {
        try {
            this.writeDataChangeNotificationsCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readDataChangeNotificationsCountAsync() {
        return ((CompletableFuture)this.getDataChangeNotificationsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDataChangeNotificationsCountAsync(UInteger dataChangeNotificationsCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataChangeNotificationsCount));
        return this.getDataChangeNotificationsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDataChangeNotificationsCountNode() throws UaException {
        try {
            return this.getDataChangeNotificationsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDataChangeNotificationsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataChangeNotificationsCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getEventNotificationsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getEventNotificationsCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setEventNotificationsCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getEventNotificationsCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readEventNotificationsCount() throws UaException {
        try {
            return this.readEventNotificationsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEventNotificationsCount(UInteger value) throws UaException {
        try {
            this.writeEventNotificationsCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readEventNotificationsCountAsync() {
        return ((CompletableFuture)this.getEventNotificationsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEventNotificationsCountAsync(UInteger eventNotificationsCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)eventNotificationsCount));
        return this.getEventNotificationsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getEventNotificationsCountNode() throws UaException {
        try {
            return this.getEventNotificationsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getEventNotificationsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EventNotificationsCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getNotificationsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getNotificationsCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setNotificationsCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getNotificationsCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readNotificationsCount() throws UaException {
        try {
            return this.readNotificationsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNotificationsCount(UInteger value) throws UaException {
        try {
            this.writeNotificationsCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readNotificationsCountAsync() {
        return ((CompletableFuture)this.getNotificationsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNotificationsCountAsync(UInteger notificationsCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)notificationsCount));
        return this.getNotificationsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getNotificationsCountNode() throws UaException {
        try {
            return this.getNotificationsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getNotificationsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NotificationsCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getLatePublishRequestCount() throws UaException {
        BaseDataVariableTypeNode node = this.getLatePublishRequestCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setLatePublishRequestCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getLatePublishRequestCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readLatePublishRequestCount() throws UaException {
        try {
            return this.readLatePublishRequestCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLatePublishRequestCount(UInteger value) throws UaException {
        try {
            this.writeLatePublishRequestCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readLatePublishRequestCountAsync() {
        return ((CompletableFuture)this.getLatePublishRequestCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLatePublishRequestCountAsync(UInteger latePublishRequestCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)latePublishRequestCount));
        return this.getLatePublishRequestCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getLatePublishRequestCountNode() throws UaException {
        try {
            return this.getLatePublishRequestCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getLatePublishRequestCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LatePublishRequestCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getCurrentKeepAliveCount() throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentKeepAliveCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setCurrentKeepAliveCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentKeepAliveCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readCurrentKeepAliveCount() throws UaException {
        try {
            return this.readCurrentKeepAliveCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCurrentKeepAliveCount(UInteger value) throws UaException {
        try {
            this.writeCurrentKeepAliveCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readCurrentKeepAliveCountAsync() {
        return ((CompletableFuture)this.getCurrentKeepAliveCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCurrentKeepAliveCountAsync(UInteger currentKeepAliveCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)currentKeepAliveCount));
        return this.getCurrentKeepAliveCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCurrentKeepAliveCountNode() throws UaException {
        try {
            return this.getCurrentKeepAliveCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCurrentKeepAliveCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CurrentKeepAliveCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getCurrentLifetimeCount() throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentLifetimeCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setCurrentLifetimeCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentLifetimeCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readCurrentLifetimeCount() throws UaException {
        try {
            return this.readCurrentLifetimeCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCurrentLifetimeCount(UInteger value) throws UaException {
        try {
            this.writeCurrentLifetimeCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readCurrentLifetimeCountAsync() {
        return ((CompletableFuture)this.getCurrentLifetimeCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCurrentLifetimeCountAsync(UInteger currentLifetimeCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)currentLifetimeCount));
        return this.getCurrentLifetimeCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCurrentLifetimeCountNode() throws UaException {
        try {
            return this.getCurrentLifetimeCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCurrentLifetimeCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CurrentLifetimeCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getUnacknowledgedMessageCount() throws UaException {
        BaseDataVariableTypeNode node = this.getUnacknowledgedMessageCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setUnacknowledgedMessageCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getUnacknowledgedMessageCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readUnacknowledgedMessageCount() throws UaException {
        try {
            return this.readUnacknowledgedMessageCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeUnacknowledgedMessageCount(UInteger value) throws UaException {
        try {
            this.writeUnacknowledgedMessageCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readUnacknowledgedMessageCountAsync() {
        return ((CompletableFuture)this.getUnacknowledgedMessageCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeUnacknowledgedMessageCountAsync(UInteger unacknowledgedMessageCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)unacknowledgedMessageCount));
        return this.getUnacknowledgedMessageCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getUnacknowledgedMessageCountNode() throws UaException {
        try {
            return this.getUnacknowledgedMessageCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getUnacknowledgedMessageCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UnacknowledgedMessageCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getDiscardedMessageCount() throws UaException {
        BaseDataVariableTypeNode node = this.getDiscardedMessageCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setDiscardedMessageCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getDiscardedMessageCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readDiscardedMessageCount() throws UaException {
        try {
            return this.readDiscardedMessageCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDiscardedMessageCount(UInteger value) throws UaException {
        try {
            this.writeDiscardedMessageCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readDiscardedMessageCountAsync() {
        return ((CompletableFuture)this.getDiscardedMessageCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDiscardedMessageCountAsync(UInteger discardedMessageCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)discardedMessageCount));
        return this.getDiscardedMessageCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDiscardedMessageCountNode() throws UaException {
        try {
            return this.getDiscardedMessageCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDiscardedMessageCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DiscardedMessageCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getMonitoredItemCount() throws UaException {
        BaseDataVariableTypeNode node = this.getMonitoredItemCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMonitoredItemCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getMonitoredItemCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMonitoredItemCount() throws UaException {
        try {
            return this.readMonitoredItemCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMonitoredItemCount(UInteger value) throws UaException {
        try {
            this.writeMonitoredItemCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMonitoredItemCountAsync() {
        return ((CompletableFuture)this.getMonitoredItemCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMonitoredItemCountAsync(UInteger monitoredItemCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)monitoredItemCount));
        return this.getMonitoredItemCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMonitoredItemCountNode() throws UaException {
        try {
            return this.getMonitoredItemCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMonitoredItemCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MonitoredItemCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getDisabledMonitoredItemCount() throws UaException {
        BaseDataVariableTypeNode node = this.getDisabledMonitoredItemCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setDisabledMonitoredItemCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getDisabledMonitoredItemCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readDisabledMonitoredItemCount() throws UaException {
        try {
            return this.readDisabledMonitoredItemCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDisabledMonitoredItemCount(UInteger value) throws UaException {
        try {
            this.writeDisabledMonitoredItemCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readDisabledMonitoredItemCountAsync() {
        return ((CompletableFuture)this.getDisabledMonitoredItemCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDisabledMonitoredItemCountAsync(UInteger disabledMonitoredItemCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)disabledMonitoredItemCount));
        return this.getDisabledMonitoredItemCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDisabledMonitoredItemCountNode() throws UaException {
        try {
            return this.getDisabledMonitoredItemCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDisabledMonitoredItemCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DisabledMonitoredItemCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getMonitoringQueueOverflowCount() throws UaException {
        BaseDataVariableTypeNode node = this.getMonitoringQueueOverflowCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMonitoringQueueOverflowCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getMonitoringQueueOverflowCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMonitoringQueueOverflowCount() throws UaException {
        try {
            return this.readMonitoringQueueOverflowCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMonitoringQueueOverflowCount(UInteger value) throws UaException {
        try {
            this.writeMonitoringQueueOverflowCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMonitoringQueueOverflowCountAsync() {
        return ((CompletableFuture)this.getMonitoringQueueOverflowCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMonitoringQueueOverflowCountAsync(UInteger monitoringQueueOverflowCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)monitoringQueueOverflowCount));
        return this.getMonitoringQueueOverflowCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMonitoringQueueOverflowCountNode() throws UaException {
        try {
            return this.getMonitoringQueueOverflowCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMonitoringQueueOverflowCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MonitoringQueueOverflowCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getNextSequenceNumber() throws UaException {
        BaseDataVariableTypeNode node = this.getNextSequenceNumberNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setNextSequenceNumber(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getNextSequenceNumberNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readNextSequenceNumber() throws UaException {
        try {
            return this.readNextSequenceNumberAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNextSequenceNumber(UInteger value) throws UaException {
        try {
            this.writeNextSequenceNumberAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readNextSequenceNumberAsync() {
        return ((CompletableFuture)this.getNextSequenceNumberNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNextSequenceNumberAsync(UInteger nextSequenceNumber) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)nextSequenceNumber));
        return this.getNextSequenceNumberNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getNextSequenceNumberNode() throws UaException {
        try {
            return this.getNextSequenceNumberNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getNextSequenceNumberNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NextSequenceNumber", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getEventQueueOverflowCount() throws UaException {
        BaseDataVariableTypeNode node = this.getEventQueueOverflowCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setEventQueueOverflowCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getEventQueueOverflowCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readEventQueueOverflowCount() throws UaException {
        try {
            return this.readEventQueueOverflowCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEventQueueOverflowCount(UInteger value) throws UaException {
        try {
            this.writeEventQueueOverflowCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readEventQueueOverflowCountAsync() {
        return ((CompletableFuture)this.getEventQueueOverflowCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEventQueueOverflowCountAsync(UInteger eventQueueOverflowCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)eventQueueOverflowCount));
        return this.getEventQueueOverflowCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getEventQueueOverflowCountNode() throws UaException {
        try {
            return this.getEventQueueOverflowCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getEventQueueOverflowCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EventQueueOverflowCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

