/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.BuildInfoTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.ServerStatusType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ServerStatusTypeNode
extends BaseDataVariableTypeNode
implements ServerStatusType {
    public ServerStatusTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public DateTime getStartTime() throws UaException {
        BaseDataVariableTypeNode node = this.getStartTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setStartTime(DateTime value) throws UaException {
        BaseDataVariableTypeNode node = this.getStartTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readStartTime() throws UaException {
        try {
            return this.readStartTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStartTime(DateTime value) throws UaException {
        try {
            this.writeStartTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readStartTimeAsync() {
        return ((CompletableFuture)this.getStartTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStartTimeAsync(DateTime startTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)startTime));
        return this.getStartTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getStartTimeNode() throws UaException {
        try {
            return this.getStartTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getStartTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StartTime", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public DateTime getCurrentTime() throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setCurrentTime(DateTime value) throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readCurrentTime() throws UaException {
        try {
            return this.readCurrentTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCurrentTime(DateTime value) throws UaException {
        try {
            this.writeCurrentTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readCurrentTimeAsync() {
        return ((CompletableFuture)this.getCurrentTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCurrentTimeAsync(DateTime currentTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)currentTime));
        return this.getCurrentTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCurrentTimeNode() throws UaException {
        try {
            return this.getCurrentTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCurrentTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CurrentTime", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServerState getState() throws UaException {
        BaseDataVariableTypeNode node = this.getStateNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return ServerState.from((int)((Integer)value));
        }
        if (value instanceof ServerState) {
            return (ServerState)value;
        }
        return null;
    }

    @Override
    public void setState(ServerState value) throws UaException {
        BaseDataVariableTypeNode node = this.getStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServerState readState() throws UaException {
        try {
            return this.readStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeState(ServerState value) throws UaException {
        try {
            this.writeStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServerState> readStateAsync() {
        return ((CompletableFuture)this.getStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return ServerState.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeStateAsync(ServerState state) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)state));
        return this.getStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getStateNode() throws UaException {
        try {
            return this.getStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "State", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public BuildInfo getBuildInfo() throws UaException {
        BuildInfoTypeNode node = this.getBuildInfoNode();
        return this.cast(node.getValue().getValue().getValue(), BuildInfo.class);
    }

    @Override
    public void setBuildInfo(BuildInfo value) throws UaException {
        BuildInfoTypeNode node = this.getBuildInfoNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public BuildInfo readBuildInfo() throws UaException {
        try {
            return this.readBuildInfoAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeBuildInfo(BuildInfo value) throws UaException {
        try {
            this.writeBuildInfoAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends BuildInfo> readBuildInfoAsync() {
        return ((CompletableFuture)this.getBuildInfoNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), BuildInfo.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeBuildInfoAsync(BuildInfo buildInfo) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)buildInfo);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getBuildInfoNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BuildInfoTypeNode getBuildInfoNode() throws UaException {
        try {
            return this.getBuildInfoNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BuildInfoTypeNode> getBuildInfoNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BuildInfo", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BuildInfoTypeNode)node);
    }

    @Override
    public UInteger getSecondsTillShutdown() throws UaException {
        BaseDataVariableTypeNode node = this.getSecondsTillShutdownNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setSecondsTillShutdown(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getSecondsTillShutdownNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readSecondsTillShutdown() throws UaException {
        try {
            return this.readSecondsTillShutdownAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecondsTillShutdown(UInteger value) throws UaException {
        try {
            this.writeSecondsTillShutdownAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readSecondsTillShutdownAsync() {
        return ((CompletableFuture)this.getSecondsTillShutdownNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSecondsTillShutdownAsync(UInteger secondsTillShutdown) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)secondsTillShutdown));
        return this.getSecondsTillShutdownNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSecondsTillShutdownNode() throws UaException {
        try {
            return this.getSecondsTillShutdownNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSecondsTillShutdownNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecondsTillShutdown", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public LocalizedText getShutdownReason() throws UaException {
        BaseDataVariableTypeNode node = this.getShutdownReasonNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setShutdownReason(LocalizedText value) throws UaException {
        BaseDataVariableTypeNode node = this.getShutdownReasonNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readShutdownReason() throws UaException {
        try {
            return this.readShutdownReasonAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeShutdownReason(LocalizedText value) throws UaException {
        try {
            this.writeShutdownReasonAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readShutdownReasonAsync() {
        return ((CompletableFuture)this.getShutdownReasonNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeShutdownReasonAsync(LocalizedText shutdownReason) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)shutdownReason));
        return this.getShutdownReasonNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getShutdownReasonNode() throws UaException {
        try {
            return this.getShutdownReasonNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getShutdownReasonNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ShutdownReason", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

