/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PubSubDiagnosticsCounterType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DiagnosticsLevel;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.PubSubDiagnosticsCounterClassification;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class PubSubDiagnosticsCounterTypeNode
extends BaseDataVariableTypeNode
implements PubSubDiagnosticsCounterType {
    public PubSubDiagnosticsCounterTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public Boolean getActive() throws UaException {
        PropertyTypeNode node = this.getActiveNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setActive(Boolean value) throws UaException {
        PropertyTypeNode node = this.getActiveNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readActive() throws UaException {
        try {
            return this.readActiveAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeActive(Boolean value) throws UaException {
        try {
            this.writeActiveAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readActiveAsync() {
        return ((CompletableFuture)this.getActiveNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeActiveAsync(Boolean active) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)active));
        return this.getActiveNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getActiveNode() throws UaException {
        try {
            return this.getActiveNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getActiveNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Active", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public PubSubDiagnosticsCounterClassification getClassification() throws UaException {
        PropertyTypeNode node = this.getClassificationNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return PubSubDiagnosticsCounterClassification.from((int)((Integer)value));
        }
        if (value instanceof PubSubDiagnosticsCounterClassification) {
            return (PubSubDiagnosticsCounterClassification)value;
        }
        return null;
    }

    @Override
    public void setClassification(PubSubDiagnosticsCounterClassification value) throws UaException {
        PropertyTypeNode node = this.getClassificationNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public PubSubDiagnosticsCounterClassification readClassification() throws UaException {
        try {
            return this.readClassificationAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClassification(PubSubDiagnosticsCounterClassification value) throws UaException {
        try {
            this.writeClassificationAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends PubSubDiagnosticsCounterClassification> readClassificationAsync() {
        return ((CompletableFuture)this.getClassificationNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return PubSubDiagnosticsCounterClassification.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeClassificationAsync(PubSubDiagnosticsCounterClassification classification) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)classification));
        return this.getClassificationNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getClassificationNode() throws UaException {
        try {
            return this.getClassificationNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getClassificationNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Classification", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DiagnosticsLevel getDiagnosticsLevel() throws UaException {
        PropertyTypeNode node = this.getDiagnosticsLevelNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return DiagnosticsLevel.from((int)((Integer)value));
        }
        if (value instanceof DiagnosticsLevel) {
            return (DiagnosticsLevel)value;
        }
        return null;
    }

    @Override
    public void setDiagnosticsLevel(DiagnosticsLevel value) throws UaException {
        PropertyTypeNode node = this.getDiagnosticsLevelNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DiagnosticsLevel readDiagnosticsLevel() throws UaException {
        try {
            return this.readDiagnosticsLevelAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDiagnosticsLevel(DiagnosticsLevel value) throws UaException {
        try {
            this.writeDiagnosticsLevelAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DiagnosticsLevel> readDiagnosticsLevelAsync() {
        return ((CompletableFuture)this.getDiagnosticsLevelNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return DiagnosticsLevel.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeDiagnosticsLevelAsync(DiagnosticsLevel diagnosticsLevel) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)diagnosticsLevel));
        return this.getDiagnosticsLevelNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDiagnosticsLevelNode() throws UaException {
        try {
            return this.getDiagnosticsLevelNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDiagnosticsLevelNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DiagnosticsLevel", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getTimeFirstChange() throws UaException {
        PropertyTypeNode node = this.getTimeFirstChangeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setTimeFirstChange(DateTime value) throws UaException {
        PropertyTypeNode node = this.getTimeFirstChangeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readTimeFirstChange() throws UaException {
        try {
            return this.readTimeFirstChangeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTimeFirstChange(DateTime value) throws UaException {
        try {
            this.writeTimeFirstChangeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readTimeFirstChangeAsync() {
        return ((CompletableFuture)this.getTimeFirstChangeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTimeFirstChangeAsync(DateTime timeFirstChange) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)timeFirstChange));
        return this.getTimeFirstChangeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getTimeFirstChangeNode() throws UaException {
        try {
            return this.getTimeFirstChangeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getTimeFirstChangeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TimeFirstChange", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

