/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.ProgramDiagnostic2Type;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ProgramDiagnostic2TypeNode
extends BaseDataVariableTypeNode
implements ProgramDiagnostic2Type {
    public ProgramDiagnostic2TypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public DateTime getLastTransitionTime() throws UaException {
        PropertyTypeNode node = this.getLastTransitionTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastTransitionTime(DateTime value) throws UaException {
        PropertyTypeNode node = this.getLastTransitionTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readLastTransitionTime() throws UaException {
        try {
            return this.readLastTransitionTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastTransitionTime(DateTime value) throws UaException {
        try {
            this.writeLastTransitionTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readLastTransitionTimeAsync() {
        return ((CompletableFuture)this.getLastTransitionTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastTransitionTimeAsync(DateTime lastTransitionTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastTransitionTime));
        return this.getLastTransitionTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLastTransitionTimeNode() throws UaException {
        try {
            return this.getLastTransitionTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLastTransitionTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastTransitionTime", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId getCreateSessionId() throws UaException {
        BaseDataVariableTypeNode node = this.getCreateSessionIdNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setCreateSessionId(NodeId value) throws UaException {
        BaseDataVariableTypeNode node = this.getCreateSessionIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readCreateSessionId() throws UaException {
        try {
            return this.readCreateSessionIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCreateSessionId(NodeId value) throws UaException {
        try {
            this.writeCreateSessionIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readCreateSessionIdAsync() {
        return ((CompletableFuture)this.getCreateSessionIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCreateSessionIdAsync(NodeId createSessionId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)createSessionId));
        return this.getCreateSessionIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCreateSessionIdNode() throws UaException {
        try {
            return this.getCreateSessionIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCreateSessionIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CreateSessionId", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getCreateClientName() throws UaException {
        BaseDataVariableTypeNode node = this.getCreateClientNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setCreateClientName(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getCreateClientNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readCreateClientName() throws UaException {
        try {
            return this.readCreateClientNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCreateClientName(String value) throws UaException {
        try {
            this.writeCreateClientNameAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readCreateClientNameAsync() {
        return ((CompletableFuture)this.getCreateClientNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCreateClientNameAsync(String createClientName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)createClientName));
        return this.getCreateClientNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCreateClientNameNode() throws UaException {
        try {
            return this.getCreateClientNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCreateClientNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CreateClientName", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public DateTime getInvocationCreationTime() throws UaException {
        BaseDataVariableTypeNode node = this.getInvocationCreationTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setInvocationCreationTime(DateTime value) throws UaException {
        BaseDataVariableTypeNode node = this.getInvocationCreationTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readInvocationCreationTime() throws UaException {
        try {
            return this.readInvocationCreationTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeInvocationCreationTime(DateTime value) throws UaException {
        try {
            this.writeInvocationCreationTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readInvocationCreationTimeAsync() {
        return ((CompletableFuture)this.getInvocationCreationTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeInvocationCreationTimeAsync(DateTime invocationCreationTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)invocationCreationTime));
        return this.getInvocationCreationTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getInvocationCreationTimeNode() throws UaException {
        try {
            return this.getInvocationCreationTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getInvocationCreationTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InvocationCreationTime", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getLastMethodCall() throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodCallNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastMethodCall(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodCallNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readLastMethodCall() throws UaException {
        try {
            return this.readLastMethodCallAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastMethodCall(String value) throws UaException {
        try {
            this.writeLastMethodCallAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readLastMethodCallAsync() {
        return ((CompletableFuture)this.getLastMethodCallNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastMethodCallAsync(String lastMethodCall) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastMethodCall));
        return this.getLastMethodCallNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getLastMethodCallNode() throws UaException {
        try {
            return this.getLastMethodCallNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getLastMethodCallNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastMethodCall", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public NodeId getLastMethodSessionId() throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodSessionIdNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastMethodSessionId(NodeId value) throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodSessionIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readLastMethodSessionId() throws UaException {
        try {
            return this.readLastMethodSessionIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastMethodSessionId(NodeId value) throws UaException {
        try {
            this.writeLastMethodSessionIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readLastMethodSessionIdAsync() {
        return ((CompletableFuture)this.getLastMethodSessionIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastMethodSessionIdAsync(NodeId lastMethodSessionId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastMethodSessionId));
        return this.getLastMethodSessionIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getLastMethodSessionIdNode() throws UaException {
        try {
            return this.getLastMethodSessionIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getLastMethodSessionIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastMethodSessionId", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Argument[] getLastMethodInputArguments() throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodInputArgumentsNode();
        return this.cast(node.getValue().getValue().getValue(), Argument[].class);
    }

    @Override
    public void setLastMethodInputArguments(Argument[] value) throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodInputArgumentsNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public Argument[] readLastMethodInputArguments() throws UaException {
        try {
            return this.readLastMethodInputArgumentsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastMethodInputArguments(Argument[] value) throws UaException {
        try {
            this.writeLastMethodInputArgumentsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Argument[]> readLastMethodInputArgumentsAsync() {
        return ((CompletableFuture)this.getLastMethodInputArgumentsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), Argument[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeLastMethodInputArgumentsAsync(Argument[] lastMethodInputArguments) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])lastMethodInputArguments);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getLastMethodInputArgumentsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getLastMethodInputArgumentsNode() throws UaException {
        try {
            return this.getLastMethodInputArgumentsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getLastMethodInputArgumentsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastMethodInputArguments", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Argument[] getLastMethodOutputArguments() throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodOutputArgumentsNode();
        return this.cast(node.getValue().getValue().getValue(), Argument[].class);
    }

    @Override
    public void setLastMethodOutputArguments(Argument[] value) throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodOutputArgumentsNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public Argument[] readLastMethodOutputArguments() throws UaException {
        try {
            return this.readLastMethodOutputArgumentsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastMethodOutputArguments(Argument[] value) throws UaException {
        try {
            this.writeLastMethodOutputArgumentsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Argument[]> readLastMethodOutputArgumentsAsync() {
        return ((CompletableFuture)this.getLastMethodOutputArgumentsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), Argument[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeLastMethodOutputArgumentsAsync(Argument[] lastMethodOutputArguments) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])lastMethodOutputArguments);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getLastMethodOutputArgumentsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getLastMethodOutputArgumentsNode() throws UaException {
        try {
            return this.getLastMethodOutputArgumentsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getLastMethodOutputArgumentsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastMethodOutputArguments", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Object[] getLastMethodInputValues() throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodInputValuesNode();
        return (Object[])node.getValue().getValue().getValue();
    }

    @Override
    public void setLastMethodInputValues(Object[] value) throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodInputValuesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Object[] readLastMethodInputValues() throws UaException {
        try {
            return this.readLastMethodInputValuesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastMethodInputValues(Object[] value) throws UaException {
        try {
            this.writeLastMethodInputValuesAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Object[]> readLastMethodInputValuesAsync() {
        return ((CompletableFuture)this.getLastMethodInputValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Object[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastMethodInputValuesAsync(Object[] lastMethodInputValues) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastMethodInputValues));
        return this.getLastMethodInputValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getLastMethodInputValuesNode() throws UaException {
        try {
            return this.getLastMethodInputValuesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getLastMethodInputValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastMethodInputValues", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Object[] getLastMethodOutputValues() throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodOutputValuesNode();
        return (Object[])node.getValue().getValue().getValue();
    }

    @Override
    public void setLastMethodOutputValues(Object[] value) throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodOutputValuesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Object[] readLastMethodOutputValues() throws UaException {
        try {
            return this.readLastMethodOutputValuesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastMethodOutputValues(Object[] value) throws UaException {
        try {
            this.writeLastMethodOutputValuesAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Object[]> readLastMethodOutputValuesAsync() {
        return ((CompletableFuture)this.getLastMethodOutputValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Object[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastMethodOutputValuesAsync(Object[] lastMethodOutputValues) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastMethodOutputValues));
        return this.getLastMethodOutputValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getLastMethodOutputValuesNode() throws UaException {
        try {
            return this.getLastMethodOutputValuesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getLastMethodOutputValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastMethodOutputValues", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public DateTime getLastMethodCallTime() throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodCallTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastMethodCallTime(DateTime value) throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodCallTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readLastMethodCallTime() throws UaException {
        try {
            return this.readLastMethodCallTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastMethodCallTime(DateTime value) throws UaException {
        try {
            this.writeLastMethodCallTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readLastMethodCallTimeAsync() {
        return ((CompletableFuture)this.getLastMethodCallTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastMethodCallTimeAsync(DateTime lastMethodCallTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastMethodCallTime));
        return this.getLastMethodCallTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getLastMethodCallTimeNode() throws UaException {
        try {
            return this.getLastMethodCallTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getLastMethodCallTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastMethodCallTime", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public StatusCode getLastMethodReturnStatus() throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodReturnStatusNode();
        return (StatusCode)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastMethodReturnStatus(StatusCode value) throws UaException {
        BaseDataVariableTypeNode node = this.getLastMethodReturnStatusNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public StatusCode readLastMethodReturnStatus() throws UaException {
        try {
            return this.readLastMethodReturnStatusAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastMethodReturnStatus(StatusCode value) throws UaException {
        try {
            this.writeLastMethodReturnStatusAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends StatusCode> readLastMethodReturnStatusAsync() {
        return ((CompletableFuture)this.getLastMethodReturnStatusNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (StatusCode)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastMethodReturnStatusAsync(StatusCode lastMethodReturnStatus) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastMethodReturnStatus));
        return this.getLastMethodReturnStatusNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getLastMethodReturnStatusNode() throws UaException {
        try {
            return this.getLastMethodReturnStatusNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getLastMethodReturnStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastMethodReturnStatus", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

