/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.MultiStateDictionaryEntryDiscreteBaseType;
import org.eclipse.milo.opcua.sdk.client.model.variables.MultiStateValueDiscreteTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class MultiStateDictionaryEntryDiscreteBaseTypeNode
extends MultiStateValueDiscreteTypeNode
implements MultiStateDictionaryEntryDiscreteBaseType {
    public MultiStateDictionaryEntryDiscreteBaseTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public Object getEnumDictionaryEntries() throws UaException {
        PropertyTypeNode node = this.getEnumDictionaryEntriesNode();
        return node.getValue().getValue().getValue();
    }

    @Override
    public void setEnumDictionaryEntries(Object value) throws UaException {
        PropertyTypeNode node = this.getEnumDictionaryEntriesNode();
        node.setValue(new Variant(value));
    }

    @Override
    public Object readEnumDictionaryEntries() throws UaException {
        try {
            return this.readEnumDictionaryEntriesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEnumDictionaryEntries(Object value) throws UaException {
        try {
            this.writeEnumDictionaryEntriesAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<?> readEnumDictionaryEntriesAsync() {
        return ((CompletableFuture)this.getEnumDictionaryEntriesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEnumDictionaryEntriesAsync(Object enumDictionaryEntries) {
        DataValue value = DataValue.valueOnly((Variant)new Variant(enumDictionaryEntries));
        return this.getEnumDictionaryEntriesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEnumDictionaryEntriesNode() throws UaException {
        try {
            return this.getEnumDictionaryEntriesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEnumDictionaryEntriesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EnumDictionaryEntries", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId[] getValueAsDictionaryEntries() throws UaException {
        PropertyTypeNode node = this.getValueAsDictionaryEntriesNode();
        return (NodeId[])node.getValue().getValue().getValue();
    }

    @Override
    public void setValueAsDictionaryEntries(NodeId[] value) throws UaException {
        PropertyTypeNode node = this.getValueAsDictionaryEntriesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId[] readValueAsDictionaryEntries() throws UaException {
        try {
            return this.readValueAsDictionaryEntriesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeValueAsDictionaryEntries(NodeId[] value) throws UaException {
        try {
            this.writeValueAsDictionaryEntriesAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId[]> readValueAsDictionaryEntriesAsync() {
        return ((CompletableFuture)this.getValueAsDictionaryEntriesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeValueAsDictionaryEntriesAsync(NodeId[] valueAsDictionaryEntries) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)valueAsDictionaryEntries));
        return this.getValueAsDictionaryEntriesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getValueAsDictionaryEntriesNode() throws UaException {
        try {
            return this.getValueAsDictionaryEntriesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getValueAsDictionaryEntriesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ValueAsDictionaryEntries", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

