/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.CartesianCoordinatesTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.FrameType;
import org.eclipse.milo.opcua.sdk.client.model.variables.OrientationTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.CartesianCoordinates;
import org.eclipse.milo.opcua.stack.core.types.structured.Orientation;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class FrameTypeNode
extends BaseDataVariableTypeNode
implements FrameType {
    public FrameTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public Boolean getConstant() throws UaException {
        PropertyTypeNode node = this.getConstantNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setConstant(Boolean value) throws UaException {
        PropertyTypeNode node = this.getConstantNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readConstant() throws UaException {
        try {
            return this.readConstantAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConstant(Boolean value) throws UaException {
        try {
            this.writeConstantAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readConstantAsync() {
        return ((CompletableFuture)this.getConstantNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConstantAsync(Boolean constant) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)constant));
        return this.getConstantNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConstantNode() throws UaException {
        try {
            return this.getConstantNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConstantNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Constant", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getFixedBase() throws UaException {
        PropertyTypeNode node = this.getFixedBaseNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setFixedBase(Boolean value) throws UaException {
        PropertyTypeNode node = this.getFixedBaseNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readFixedBase() throws UaException {
        try {
            return this.readFixedBaseAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeFixedBase(Boolean value) throws UaException {
        try {
            this.writeFixedBaseAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readFixedBaseAsync() {
        return ((CompletableFuture)this.getFixedBaseNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeFixedBaseAsync(Boolean fixedBase) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)fixedBase));
        return this.getFixedBaseNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getFixedBaseNode() throws UaException {
        try {
            return this.getFixedBaseNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getFixedBaseNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "FixedBase", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public CartesianCoordinates getCartesianCoordinates() throws UaException {
        CartesianCoordinatesTypeNode node = this.getCartesianCoordinatesNode();
        return this.cast(node.getValue().getValue().getValue(), CartesianCoordinates.class);
    }

    @Override
    public void setCartesianCoordinates(CartesianCoordinates value) throws UaException {
        CartesianCoordinatesTypeNode node = this.getCartesianCoordinatesNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public CartesianCoordinates readCartesianCoordinates() throws UaException {
        try {
            return this.readCartesianCoordinatesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCartesianCoordinates(CartesianCoordinates value) throws UaException {
        try {
            this.writeCartesianCoordinatesAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends CartesianCoordinates> readCartesianCoordinatesAsync() {
        return ((CompletableFuture)this.getCartesianCoordinatesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), CartesianCoordinates.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeCartesianCoordinatesAsync(CartesianCoordinates cartesianCoordinates) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)cartesianCoordinates);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getCartesianCoordinatesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public CartesianCoordinatesTypeNode getCartesianCoordinatesNode() throws UaException {
        try {
            return this.getCartesianCoordinatesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends CartesianCoordinatesTypeNode> getCartesianCoordinatesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CartesianCoordinates", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (CartesianCoordinatesTypeNode)node);
    }

    @Override
    public Orientation getOrientation() throws UaException {
        OrientationTypeNode node = this.getOrientationNode();
        return this.cast(node.getValue().getValue().getValue(), Orientation.class);
    }

    @Override
    public void setOrientation(Orientation value) throws UaException {
        OrientationTypeNode node = this.getOrientationNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public Orientation readOrientation() throws UaException {
        try {
            return this.readOrientationAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeOrientation(Orientation value) throws UaException {
        try {
            this.writeOrientationAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Orientation> readOrientationAsync() {
        return ((CompletableFuture)this.getOrientationNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), Orientation.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeOrientationAsync(Orientation orientation) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)orientation);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getOrientationNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public OrientationTypeNode getOrientationNode() throws UaException {
        try {
            return this.getOrientationNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends OrientationTypeNode> getOrientationNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Orientation", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (OrientationTypeNode)node);
    }

    @Override
    public NodeId getBaseFrame() throws UaException {
        BaseDataVariableTypeNode node = this.getBaseFrameNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setBaseFrame(NodeId value) throws UaException {
        BaseDataVariableTypeNode node = this.getBaseFrameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readBaseFrame() throws UaException {
        try {
            return this.readBaseFrameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeBaseFrame(NodeId value) throws UaException {
        try {
            this.writeBaseFrameAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readBaseFrameAsync() {
        return ((CompletableFuture)this.getBaseFrameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeBaseFrameAsync(NodeId baseFrame) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)baseFrame));
        return this.getBaseFrameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getBaseFrameNode() throws UaException {
        try {
            return this.getBaseFrameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getBaseFrameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BaseFrame", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

