/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.DataItemType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class DataItemTypeNode
extends BaseDataVariableTypeNode
implements DataItemType {
    public DataItemTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    @Override
    public String getDefinition() throws UaException {
        PropertyTypeNode node = this.getDefinitionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setDefinition(String value) throws UaException {
        PropertyTypeNode node = this.getDefinitionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readDefinition() throws UaException {
        try {
            return this.readDefinitionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDefinition(String value) throws UaException {
        try {
            this.writeDefinitionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readDefinitionAsync() {
        return ((CompletableFuture)this.getDefinitionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDefinitionAsync(String definition) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)definition));
        return this.getDefinitionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDefinitionNode() throws UaException {
        try {
            return this.getDefinitionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDefinitionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Definition", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getValuePrecision() throws UaException {
        PropertyTypeNode node = this.getValuePrecisionNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setValuePrecision(Double value) throws UaException {
        PropertyTypeNode node = this.getValuePrecisionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readValuePrecision() throws UaException {
        try {
            return this.readValuePrecisionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeValuePrecision(Double value) throws UaException {
        try {
            this.writeValuePrecisionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readValuePrecisionAsync() {
        return ((CompletableFuture)this.getValuePrecisionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeValuePrecisionAsync(Double valuePrecision) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)valuePrecision));
        return this.getValuePrecisionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getValuePrecisionNode() throws UaException {
        try {
            return this.getValuePrecisionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getValuePrecisionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ValuePrecision", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

