/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubDiagnosticsWriterGroupTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubGroupTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.WriterGroupMessageTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.WriterGroupTransportTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.WriterGroupType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class WriterGroupTypeNode
extends PubSubGroupTypeNode
implements WriterGroupType {
    public WriterGroupTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UShort getWriterGroupId() throws UaException {
        PropertyTypeNode node = this.getWriterGroupIdNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setWriterGroupId(UShort value) throws UaException {
        PropertyTypeNode node = this.getWriterGroupIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readWriterGroupId() throws UaException {
        try {
            return this.readWriterGroupIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeWriterGroupId(UShort value) throws UaException {
        try {
            this.writeWriterGroupIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readWriterGroupIdAsync() {
        return ((CompletableFuture)this.getWriterGroupIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeWriterGroupIdAsync(UShort writerGroupId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)writerGroupId));
        return this.getWriterGroupIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getWriterGroupIdNode() throws UaException {
        try {
            return this.getWriterGroupIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getWriterGroupIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "WriterGroupId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getPublishingInterval() throws UaException {
        PropertyTypeNode node = this.getPublishingIntervalNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setPublishingInterval(Double value) throws UaException {
        PropertyTypeNode node = this.getPublishingIntervalNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readPublishingInterval() throws UaException {
        try {
            return this.readPublishingIntervalAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePublishingInterval(Double value) throws UaException {
        try {
            this.writePublishingIntervalAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readPublishingIntervalAsync() {
        return ((CompletableFuture)this.getPublishingIntervalNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePublishingIntervalAsync(Double publishingInterval) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)publishingInterval));
        return this.getPublishingIntervalNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPublishingIntervalNode() throws UaException {
        try {
            return this.getPublishingIntervalNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPublishingIntervalNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PublishingInterval", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getKeepAliveTime() throws UaException {
        PropertyTypeNode node = this.getKeepAliveTimeNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setKeepAliveTime(Double value) throws UaException {
        PropertyTypeNode node = this.getKeepAliveTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readKeepAliveTime() throws UaException {
        try {
            return this.readKeepAliveTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeKeepAliveTime(Double value) throws UaException {
        try {
            this.writeKeepAliveTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readKeepAliveTimeAsync() {
        return ((CompletableFuture)this.getKeepAliveTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeKeepAliveTimeAsync(Double keepAliveTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)keepAliveTime));
        return this.getKeepAliveTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getKeepAliveTimeNode() throws UaException {
        try {
            return this.getKeepAliveTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getKeepAliveTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "KeepAliveTime", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UByte getPriority() throws UaException {
        PropertyTypeNode node = this.getPriorityNode();
        return (UByte)node.getValue().getValue().getValue();
    }

    @Override
    public void setPriority(UByte value) throws UaException {
        PropertyTypeNode node = this.getPriorityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte readPriority() throws UaException {
        try {
            return this.readPriorityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePriority(UByte value) throws UaException {
        try {
            this.writePriorityAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UByte> readPriorityAsync() {
        return ((CompletableFuture)this.getPriorityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePriorityAsync(UByte priority) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)priority));
        return this.getPriorityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPriorityNode() throws UaException {
        try {
            return this.getPriorityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPriorityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Priority", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String[] getLocaleIds() throws UaException {
        PropertyTypeNode node = this.getLocaleIdsNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setLocaleIds(String[] value) throws UaException {
        PropertyTypeNode node = this.getLocaleIdsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String[] readLocaleIds() throws UaException {
        try {
            return this.readLocaleIdsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLocaleIds(String[] value) throws UaException {
        try {
            this.writeLocaleIdsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readLocaleIdsAsync() {
        return ((CompletableFuture)this.getLocaleIdsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLocaleIdsAsync(String[] localeIds) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)localeIds));
        return this.getLocaleIdsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLocaleIdsNode() throws UaException {
        try {
            return this.getLocaleIdsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLocaleIdsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LocaleIds", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getHeaderLayoutUri() throws UaException {
        PropertyTypeNode node = this.getHeaderLayoutUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setHeaderLayoutUri(String value) throws UaException {
        PropertyTypeNode node = this.getHeaderLayoutUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readHeaderLayoutUri() throws UaException {
        try {
            return this.readHeaderLayoutUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeHeaderLayoutUri(String value) throws UaException {
        try {
            this.writeHeaderLayoutUriAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readHeaderLayoutUriAsync() {
        return ((CompletableFuture)this.getHeaderLayoutUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHeaderLayoutUriAsync(String headerLayoutUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)headerLayoutUri));
        return this.getHeaderLayoutUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getHeaderLayoutUriNode() throws UaException {
        try {
            return this.getHeaderLayoutUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getHeaderLayoutUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HeaderLayoutUri", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public WriterGroupTransportTypeNode getTransportSettingsNode() throws UaException {
        try {
            return this.getTransportSettingsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends WriterGroupTransportTypeNode> getTransportSettingsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransportSettings", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (WriterGroupTransportTypeNode)node);
    }

    @Override
    public WriterGroupMessageTypeNode getMessageSettingsNode() throws UaException {
        try {
            return this.getMessageSettingsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends WriterGroupMessageTypeNode> getMessageSettingsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MessageSettings", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (WriterGroupMessageTypeNode)node);
    }

    @Override
    public PubSubDiagnosticsWriterGroupTypeNode getDiagnosticsNode() throws UaException {
        try {
            return this.getDiagnosticsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PubSubDiagnosticsWriterGroupTypeNode> getDiagnosticsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Diagnostics", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (PubSubDiagnosticsWriterGroupTypeNode)node);
    }
}

