/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.DataSetWriterMessageTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.UadpDataSetWriterMessageType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.UadpDataSetMessageContentMask;

public class UadpDataSetWriterMessageTypeNode
extends DataSetWriterMessageTypeNode
implements UadpDataSetWriterMessageType {
    public UadpDataSetWriterMessageTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UadpDataSetMessageContentMask getDataSetMessageContentMask() throws UaException {
        PropertyTypeNode node = this.getDataSetMessageContentMaskNode();
        return (UadpDataSetMessageContentMask)node.getValue().getValue().getValue();
    }

    @Override
    public void setDataSetMessageContentMask(UadpDataSetMessageContentMask value) throws UaException {
        PropertyTypeNode node = this.getDataSetMessageContentMaskNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UadpDataSetMessageContentMask readDataSetMessageContentMask() throws UaException {
        try {
            return this.readDataSetMessageContentMaskAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDataSetMessageContentMask(UadpDataSetMessageContentMask value) throws UaException {
        try {
            this.writeDataSetMessageContentMaskAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UadpDataSetMessageContentMask> readDataSetMessageContentMaskAsync() {
        return ((CompletableFuture)this.getDataSetMessageContentMaskNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UadpDataSetMessageContentMask)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetMessageContentMaskAsync(UadpDataSetMessageContentMask dataSetMessageContentMask) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataSetMessageContentMask));
        return this.getDataSetMessageContentMaskNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetMessageContentMaskNode() throws UaException {
        try {
            return this.getDataSetMessageContentMaskNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetMessageContentMaskNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetMessageContentMask", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getConfiguredSize() throws UaException {
        PropertyTypeNode node = this.getConfiguredSizeNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setConfiguredSize(UShort value) throws UaException {
        PropertyTypeNode node = this.getConfiguredSizeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readConfiguredSize() throws UaException {
        try {
            return this.readConfiguredSizeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConfiguredSize(UShort value) throws UaException {
        try {
            this.writeConfiguredSizeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readConfiguredSizeAsync() {
        return ((CompletableFuture)this.getConfiguredSizeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConfiguredSizeAsync(UShort configuredSize) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)configuredSize));
        return this.getConfiguredSizeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConfiguredSizeNode() throws UaException {
        try {
            return this.getConfiguredSizeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConfiguredSizeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConfiguredSize", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getNetworkMessageNumber() throws UaException {
        PropertyTypeNode node = this.getNetworkMessageNumberNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setNetworkMessageNumber(UShort value) throws UaException {
        PropertyTypeNode node = this.getNetworkMessageNumberNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readNetworkMessageNumber() throws UaException {
        try {
            return this.readNetworkMessageNumberAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNetworkMessageNumber(UShort value) throws UaException {
        try {
            this.writeNetworkMessageNumberAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readNetworkMessageNumberAsync() {
        return ((CompletableFuture)this.getNetworkMessageNumberNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNetworkMessageNumberAsync(UShort networkMessageNumber) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)networkMessageNumber));
        return this.getNetworkMessageNumberNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNetworkMessageNumberNode() throws UaException {
        try {
            return this.getNetworkMessageNumberNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNetworkMessageNumberNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NetworkMessageNumber", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getDataSetOffset() throws UaException {
        PropertyTypeNode node = this.getDataSetOffsetNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setDataSetOffset(UShort value) throws UaException {
        PropertyTypeNode node = this.getDataSetOffsetNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readDataSetOffset() throws UaException {
        try {
            return this.readDataSetOffsetAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDataSetOffset(UShort value) throws UaException {
        try {
            this.writeDataSetOffsetAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readDataSetOffsetAsync() {
        return ((CompletableFuture)this.getDataSetOffsetNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetOffsetAsync(UShort dataSetOffset) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataSetOffset));
        return this.getDataSetOffsetNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetOffsetNode() throws UaException {
        try {
            return this.getDataSetOffsetNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetOffsetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetOffset", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

