/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.DataSetReaderMessageTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.UadpDataSetReaderMessageType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.UadpDataSetMessageContentMask;
import org.eclipse.milo.opcua.stack.core.types.structured.UadpNetworkMessageContentMask;

public class UadpDataSetReaderMessageTypeNode
extends DataSetReaderMessageTypeNode
implements UadpDataSetReaderMessageType {
    public UadpDataSetReaderMessageTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UInteger getGroupVersion() throws UaException {
        PropertyTypeNode node = this.getGroupVersionNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setGroupVersion(UInteger value) throws UaException {
        PropertyTypeNode node = this.getGroupVersionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readGroupVersion() throws UaException {
        try {
            return this.readGroupVersionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeGroupVersion(UInteger value) throws UaException {
        try {
            this.writeGroupVersionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readGroupVersionAsync() {
        return ((CompletableFuture)this.getGroupVersionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeGroupVersionAsync(UInteger groupVersion) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)groupVersion));
        return this.getGroupVersionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getGroupVersionNode() throws UaException {
        try {
            return this.getGroupVersionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getGroupVersionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "GroupVersion", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getNetworkMessageNumber() throws UaException {
        PropertyTypeNode node = this.getNetworkMessageNumberNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setNetworkMessageNumber(UShort value) throws UaException {
        PropertyTypeNode node = this.getNetworkMessageNumberNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readNetworkMessageNumber() throws UaException {
        try {
            return this.readNetworkMessageNumberAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNetworkMessageNumber(UShort value) throws UaException {
        try {
            this.writeNetworkMessageNumberAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readNetworkMessageNumberAsync() {
        return ((CompletableFuture)this.getNetworkMessageNumberNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNetworkMessageNumberAsync(UShort networkMessageNumber) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)networkMessageNumber));
        return this.getNetworkMessageNumberNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNetworkMessageNumberNode() throws UaException {
        try {
            return this.getNetworkMessageNumberNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNetworkMessageNumberNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NetworkMessageNumber", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getDataSetOffset() throws UaException {
        PropertyTypeNode node = this.getDataSetOffsetNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setDataSetOffset(UShort value) throws UaException {
        PropertyTypeNode node = this.getDataSetOffsetNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readDataSetOffset() throws UaException {
        try {
            return this.readDataSetOffsetAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDataSetOffset(UShort value) throws UaException {
        try {
            this.writeDataSetOffsetAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readDataSetOffsetAsync() {
        return ((CompletableFuture)this.getDataSetOffsetNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetOffsetAsync(UShort dataSetOffset) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataSetOffset));
        return this.getDataSetOffsetNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetOffsetNode() throws UaException {
        try {
            return this.getDataSetOffsetNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetOffsetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetOffset", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UUID getDataSetClassId() throws UaException {
        PropertyTypeNode node = this.getDataSetClassIdNode();
        return (UUID)node.getValue().getValue().getValue();
    }

    @Override
    public void setDataSetClassId(UUID value) throws UaException {
        PropertyTypeNode node = this.getDataSetClassIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UUID readDataSetClassId() throws UaException {
        try {
            return this.readDataSetClassIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDataSetClassId(UUID value) throws UaException {
        try {
            this.writeDataSetClassIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UUID> readDataSetClassIdAsync() {
        return ((CompletableFuture)this.getDataSetClassIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UUID)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetClassIdAsync(UUID dataSetClassId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataSetClassId));
        return this.getDataSetClassIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetClassIdNode() throws UaException {
        try {
            return this.getDataSetClassIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetClassIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetClassId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UadpNetworkMessageContentMask getNetworkMessageContentMask() throws UaException {
        PropertyTypeNode node = this.getNetworkMessageContentMaskNode();
        return (UadpNetworkMessageContentMask)node.getValue().getValue().getValue();
    }

    @Override
    public void setNetworkMessageContentMask(UadpNetworkMessageContentMask value) throws UaException {
        PropertyTypeNode node = this.getNetworkMessageContentMaskNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UadpNetworkMessageContentMask readNetworkMessageContentMask() throws UaException {
        try {
            return this.readNetworkMessageContentMaskAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNetworkMessageContentMask(UadpNetworkMessageContentMask value) throws UaException {
        try {
            this.writeNetworkMessageContentMaskAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UadpNetworkMessageContentMask> readNetworkMessageContentMaskAsync() {
        return ((CompletableFuture)this.getNetworkMessageContentMaskNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UadpNetworkMessageContentMask)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNetworkMessageContentMaskAsync(UadpNetworkMessageContentMask networkMessageContentMask) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)networkMessageContentMask));
        return this.getNetworkMessageContentMaskNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNetworkMessageContentMaskNode() throws UaException {
        try {
            return this.getNetworkMessageContentMaskNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNetworkMessageContentMaskNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NetworkMessageContentMask", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UadpDataSetMessageContentMask getDataSetMessageContentMask() throws UaException {
        PropertyTypeNode node = this.getDataSetMessageContentMaskNode();
        return (UadpDataSetMessageContentMask)node.getValue().getValue().getValue();
    }

    @Override
    public void setDataSetMessageContentMask(UadpDataSetMessageContentMask value) throws UaException {
        PropertyTypeNode node = this.getDataSetMessageContentMaskNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UadpDataSetMessageContentMask readDataSetMessageContentMask() throws UaException {
        try {
            return this.readDataSetMessageContentMaskAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDataSetMessageContentMask(UadpDataSetMessageContentMask value) throws UaException {
        try {
            this.writeDataSetMessageContentMaskAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UadpDataSetMessageContentMask> readDataSetMessageContentMaskAsync() {
        return ((CompletableFuture)this.getDataSetMessageContentMaskNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UadpDataSetMessageContentMask)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetMessageContentMaskAsync(UadpDataSetMessageContentMask dataSetMessageContentMask) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataSetMessageContentMask));
        return this.getDataSetMessageContentMaskNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetMessageContentMaskNode() throws UaException {
        try {
            return this.getDataSetMessageContentMaskNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetMessageContentMaskNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetMessageContentMask", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getPublishingInterval() throws UaException {
        PropertyTypeNode node = this.getPublishingIntervalNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setPublishingInterval(Double value) throws UaException {
        PropertyTypeNode node = this.getPublishingIntervalNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readPublishingInterval() throws UaException {
        try {
            return this.readPublishingIntervalAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePublishingInterval(Double value) throws UaException {
        try {
            this.writePublishingIntervalAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readPublishingIntervalAsync() {
        return ((CompletableFuture)this.getPublishingIntervalNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePublishingIntervalAsync(Double publishingInterval) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)publishingInterval));
        return this.getPublishingIntervalNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPublishingIntervalNode() throws UaException {
        try {
            return this.getPublishingIntervalNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPublishingIntervalNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PublishingInterval", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getProcessingOffset() throws UaException {
        PropertyTypeNode node = this.getProcessingOffsetNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setProcessingOffset(Double value) throws UaException {
        PropertyTypeNode node = this.getProcessingOffsetNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readProcessingOffset() throws UaException {
        try {
            return this.readProcessingOffsetAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeProcessingOffset(Double value) throws UaException {
        try {
            this.writeProcessingOffsetAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readProcessingOffsetAsync() {
        return ((CompletableFuture)this.getProcessingOffsetNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeProcessingOffsetAsync(Double processingOffset) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)processingOffset));
        return this.getProcessingOffsetNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getProcessingOffsetNode() throws UaException {
        try {
            return this.getProcessingOffsetNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getProcessingOffsetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ProcessingOffset", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getReceiveOffset() throws UaException {
        PropertyTypeNode node = this.getReceiveOffsetNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setReceiveOffset(Double value) throws UaException {
        PropertyTypeNode node = this.getReceiveOffsetNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readReceiveOffset() throws UaException {
        try {
            return this.readReceiveOffsetAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeReceiveOffset(Double value) throws UaException {
        try {
            this.writeReceiveOffsetAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readReceiveOffsetAsync() {
        return ((CompletableFuture)this.getReceiveOffsetNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeReceiveOffsetAsync(Double receiveOffset) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)receiveOffset));
        return this.getReceiveOffsetNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getReceiveOffsetNode() throws UaException {
        try {
            return this.getReceiveOffsetNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getReceiveOffsetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReceiveOffset", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

