/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.TransitionEventType;
import org.eclipse.milo.opcua.sdk.client.model.variables.StateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.TransitionVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class TransitionEventTypeNode
extends BaseEventTypeNode
implements TransitionEventType {
    public TransitionEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public LocalizedText getTransition() throws UaException {
        TransitionVariableTypeNode node = this.getTransitionNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setTransition(LocalizedText value) throws UaException {
        TransitionVariableTypeNode node = this.getTransitionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readTransition() throws UaException {
        try {
            return this.readTransitionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTransition(LocalizedText value) throws UaException {
        try {
            this.writeTransitionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readTransitionAsync() {
        return ((CompletableFuture)this.getTransitionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTransitionAsync(LocalizedText transition) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)transition));
        return this.getTransitionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TransitionVariableTypeNode getTransitionNode() throws UaException {
        try {
            return this.getTransitionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends TransitionVariableTypeNode> getTransitionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Transition", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (TransitionVariableTypeNode)node);
    }

    @Override
    public LocalizedText getFromState() throws UaException {
        StateVariableTypeNode node = this.getFromStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setFromState(LocalizedText value) throws UaException {
        StateVariableTypeNode node = this.getFromStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readFromState() throws UaException {
        try {
            return this.readFromStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeFromState(LocalizedText value) throws UaException {
        try {
            this.writeFromStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readFromStateAsync() {
        return ((CompletableFuture)this.getFromStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeFromStateAsync(LocalizedText fromState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)fromState));
        return this.getFromStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public StateVariableTypeNode getFromStateNode() throws UaException {
        try {
            return this.getFromStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends StateVariableTypeNode> getFromStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "FromState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (StateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getToState() throws UaException {
        StateVariableTypeNode node = this.getToStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setToState(LocalizedText value) throws UaException {
        StateVariableTypeNode node = this.getToStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readToState() throws UaException {
        try {
            return this.readToStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeToState(LocalizedText value) throws UaException {
        try {
            this.writeToStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readToStateAsync() {
        return ((CompletableFuture)this.getToStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeToStateAsync(LocalizedText toState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)toState));
        return this.getToStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public StateVariableTypeNode getToStateNode() throws UaException {
        try {
            return this.getToStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends StateVariableTypeNode> getToStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ToState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (StateVariableTypeNode)node);
    }
}

