/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.NamespacesTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ServerCapabilitiesTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ServerRedundancyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ServerType;
import org.eclipse.milo.opcua.sdk.client.model.objects.VendorServerInfoTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.ServerStatusTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerStatusDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.TimeZoneDataType;

public class ServerTypeNode
extends BaseObjectTypeNode
implements ServerType {
    public ServerTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String[] getServerArray() throws UaException {
        PropertyTypeNode node = this.getServerArrayNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setServerArray(String[] value) throws UaException {
        PropertyTypeNode node = this.getServerArrayNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String[] readServerArray() throws UaException {
        try {
            return this.readServerArrayAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServerArray(String[] value) throws UaException {
        try {
            this.writeServerArrayAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readServerArrayAsync() {
        return ((CompletableFuture)this.getServerArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServerArrayAsync(String[] serverArray) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serverArray));
        return this.getServerArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServerArrayNode() throws UaException {
        try {
            return this.getServerArrayNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServerArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerArray", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String[] getNamespaceArray() throws UaException {
        PropertyTypeNode node = this.getNamespaceArrayNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setNamespaceArray(String[] value) throws UaException {
        PropertyTypeNode node = this.getNamespaceArrayNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String[] readNamespaceArray() throws UaException {
        try {
            return this.readNamespaceArrayAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNamespaceArray(String[] value) throws UaException {
        try {
            this.writeNamespaceArrayAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readNamespaceArrayAsync() {
        return ((CompletableFuture)this.getNamespaceArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNamespaceArrayAsync(String[] namespaceArray) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)namespaceArray));
        return this.getNamespaceArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNamespaceArrayNode() throws UaException {
        try {
            return this.getNamespaceArrayNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNamespaceArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NamespaceArray", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getUrisVersion() throws UaException {
        PropertyTypeNode node = this.getUrisVersionNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setUrisVersion(UInteger value) throws UaException {
        PropertyTypeNode node = this.getUrisVersionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readUrisVersion() throws UaException {
        try {
            return this.readUrisVersionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeUrisVersion(UInteger value) throws UaException {
        try {
            this.writeUrisVersionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readUrisVersionAsync() {
        return ((CompletableFuture)this.getUrisVersionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeUrisVersionAsync(UInteger urisVersion) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)urisVersion));
        return this.getUrisVersionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getUrisVersionNode() throws UaException {
        try {
            return this.getUrisVersionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUrisVersionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UrisVersion", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UByte getServiceLevel() throws UaException {
        PropertyTypeNode node = this.getServiceLevelNode();
        return (UByte)node.getValue().getValue().getValue();
    }

    @Override
    public void setServiceLevel(UByte value) throws UaException {
        PropertyTypeNode node = this.getServiceLevelNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte readServiceLevel() throws UaException {
        try {
            return this.readServiceLevelAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServiceLevel(UByte value) throws UaException {
        try {
            this.writeServiceLevelAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UByte> readServiceLevelAsync() {
        return ((CompletableFuture)this.getServiceLevelNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServiceLevelAsync(UByte serviceLevel) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serviceLevel));
        return this.getServiceLevelNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServiceLevelNode() throws UaException {
        try {
            return this.getServiceLevelNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServiceLevelNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServiceLevel", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getAuditing() throws UaException {
        PropertyTypeNode node = this.getAuditingNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setAuditing(Boolean value) throws UaException {
        PropertyTypeNode node = this.getAuditingNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readAuditing() throws UaException {
        try {
            return this.readAuditingAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAuditing(Boolean value) throws UaException {
        try {
            this.writeAuditingAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readAuditingAsync() {
        return ((CompletableFuture)this.getAuditingNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAuditingAsync(Boolean auditing) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)auditing));
        return this.getAuditingNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getAuditingNode() throws UaException {
        try {
            return this.getAuditingNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getAuditingNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Auditing", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getEstimatedReturnTime() throws UaException {
        PropertyTypeNode node = this.getEstimatedReturnTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setEstimatedReturnTime(DateTime value) throws UaException {
        PropertyTypeNode node = this.getEstimatedReturnTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readEstimatedReturnTime() throws UaException {
        try {
            return this.readEstimatedReturnTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEstimatedReturnTime(DateTime value) throws UaException {
        try {
            this.writeEstimatedReturnTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readEstimatedReturnTimeAsync() {
        return ((CompletableFuture)this.getEstimatedReturnTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEstimatedReturnTimeAsync(DateTime estimatedReturnTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)estimatedReturnTime));
        return this.getEstimatedReturnTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEstimatedReturnTimeNode() throws UaException {
        try {
            return this.getEstimatedReturnTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEstimatedReturnTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EstimatedReturnTime", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public TimeZoneDataType getLocalTime() throws UaException {
        PropertyTypeNode node = this.getLocalTimeNode();
        return this.cast(node.getValue().getValue().getValue(), TimeZoneDataType.class);
    }

    @Override
    public void setLocalTime(TimeZoneDataType value) throws UaException {
        PropertyTypeNode node = this.getLocalTimeNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public TimeZoneDataType readLocalTime() throws UaException {
        try {
            return this.readLocalTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLocalTime(TimeZoneDataType value) throws UaException {
        try {
            this.writeLocalTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends TimeZoneDataType> readLocalTimeAsync() {
        return ((CompletableFuture)this.getLocalTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), TimeZoneDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeLocalTimeAsync(TimeZoneDataType localTime) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)localTime);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getLocalTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLocalTimeNode() throws UaException {
        try {
            return this.getLocalTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLocalTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LocalTime", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ServerStatusDataType getServerStatus() throws UaException {
        ServerStatusTypeNode node = this.getServerStatusNode();
        return this.cast(node.getValue().getValue().getValue(), ServerStatusDataType.class);
    }

    @Override
    public void setServerStatus(ServerStatusDataType value) throws UaException {
        ServerStatusTypeNode node = this.getServerStatusNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public ServerStatusDataType readServerStatus() throws UaException {
        try {
            return this.readServerStatusAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServerStatus(ServerStatusDataType value) throws UaException {
        try {
            this.writeServerStatusAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServerStatusDataType> readServerStatusAsync() {
        return ((CompletableFuture)this.getServerStatusNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServerStatusDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeServerStatusAsync(ServerStatusDataType serverStatus) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)serverStatus);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getServerStatusNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public ServerStatusTypeNode getServerStatusNode() throws UaException {
        try {
            return this.getServerStatusNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends ServerStatusTypeNode> getServerStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerStatus", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (ServerStatusTypeNode)node);
    }

    @Override
    public ServerCapabilitiesTypeNode getServerCapabilitiesNode() throws UaException {
        try {
            return this.getServerCapabilitiesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends ServerCapabilitiesTypeNode> getServerCapabilitiesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerCapabilities", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (ServerCapabilitiesTypeNode)node);
    }

    @Override
    public ServerDiagnosticsTypeNode getServerDiagnosticsNode() throws UaException {
        try {
            return this.getServerDiagnosticsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends ServerDiagnosticsTypeNode> getServerDiagnosticsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerDiagnostics", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (ServerDiagnosticsTypeNode)node);
    }

    @Override
    public VendorServerInfoTypeNode getVendorServerInfoNode() throws UaException {
        try {
            return this.getVendorServerInfoNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends VendorServerInfoTypeNode> getVendorServerInfoNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "VendorServerInfo", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (VendorServerInfoTypeNode)node);
    }

    @Override
    public ServerRedundancyTypeNode getServerRedundancyNode() throws UaException {
        try {
            return this.getServerRedundancyNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends ServerRedundancyTypeNode> getServerRedundancyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerRedundancy", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (ServerRedundancyTypeNode)node);
    }

    @Override
    public NamespacesTypeNode getNamespacesNode() throws UaException {
        try {
            return this.getNamespacesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends NamespacesTypeNode> getNamespacesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Namespaces", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (NamespacesTypeNode)node);
    }
}

