/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ServerDiagnosticsType;
import org.eclipse.milo.opcua.sdk.client.model.objects.SessionsDiagnosticsSummaryTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.SamplingIntervalDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.ServerDiagnosticsSummaryTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.SubscriptionDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.SamplingIntervalDiagnosticsDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerDiagnosticsSummaryDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionDiagnosticsDataType;

public class ServerDiagnosticsTypeNode
extends BaseObjectTypeNode
implements ServerDiagnosticsType {
    public ServerDiagnosticsTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public Boolean getEnabledFlag() throws UaException {
        PropertyTypeNode node = this.getEnabledFlagNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setEnabledFlag(Boolean value) throws UaException {
        PropertyTypeNode node = this.getEnabledFlagNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readEnabledFlag() throws UaException {
        try {
            return this.readEnabledFlagAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEnabledFlag(Boolean value) throws UaException {
        try {
            this.writeEnabledFlagAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readEnabledFlagAsync() {
        return ((CompletableFuture)this.getEnabledFlagNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEnabledFlagAsync(Boolean enabledFlag) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)enabledFlag));
        return this.getEnabledFlagNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEnabledFlagNode() throws UaException {
        try {
            return this.getEnabledFlagNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEnabledFlagNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EnabledFlag", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ServerDiagnosticsSummaryDataType getServerDiagnosticsSummary() throws UaException {
        ServerDiagnosticsSummaryTypeNode node = this.getServerDiagnosticsSummaryNode();
        return this.cast(node.getValue().getValue().getValue(), ServerDiagnosticsSummaryDataType.class);
    }

    @Override
    public void setServerDiagnosticsSummary(ServerDiagnosticsSummaryDataType value) throws UaException {
        ServerDiagnosticsSummaryTypeNode node = this.getServerDiagnosticsSummaryNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public ServerDiagnosticsSummaryDataType readServerDiagnosticsSummary() throws UaException {
        try {
            return this.readServerDiagnosticsSummaryAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServerDiagnosticsSummary(ServerDiagnosticsSummaryDataType value) throws UaException {
        try {
            this.writeServerDiagnosticsSummaryAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServerDiagnosticsSummaryDataType> readServerDiagnosticsSummaryAsync() {
        return ((CompletableFuture)this.getServerDiagnosticsSummaryNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServerDiagnosticsSummaryDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeServerDiagnosticsSummaryAsync(ServerDiagnosticsSummaryDataType serverDiagnosticsSummary) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)serverDiagnosticsSummary);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getServerDiagnosticsSummaryNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public ServerDiagnosticsSummaryTypeNode getServerDiagnosticsSummaryNode() throws UaException {
        try {
            return this.getServerDiagnosticsSummaryNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends ServerDiagnosticsSummaryTypeNode> getServerDiagnosticsSummaryNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerDiagnosticsSummary", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (ServerDiagnosticsSummaryTypeNode)node);
    }

    @Override
    public SamplingIntervalDiagnosticsDataType[] getSamplingIntervalDiagnosticsArray() throws UaException {
        SamplingIntervalDiagnosticsArrayTypeNode node = this.getSamplingIntervalDiagnosticsArrayNode();
        return this.cast(node.getValue().getValue().getValue(), SamplingIntervalDiagnosticsDataType[].class);
    }

    @Override
    public void setSamplingIntervalDiagnosticsArray(SamplingIntervalDiagnosticsDataType[] value) throws UaException {
        SamplingIntervalDiagnosticsArrayTypeNode node = this.getSamplingIntervalDiagnosticsArrayNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public SamplingIntervalDiagnosticsDataType[] readSamplingIntervalDiagnosticsArray() throws UaException {
        try {
            return this.readSamplingIntervalDiagnosticsArrayAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSamplingIntervalDiagnosticsArray(SamplingIntervalDiagnosticsDataType[] value) throws UaException {
        try {
            this.writeSamplingIntervalDiagnosticsArrayAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends SamplingIntervalDiagnosticsDataType[]> readSamplingIntervalDiagnosticsArrayAsync() {
        return ((CompletableFuture)this.getSamplingIntervalDiagnosticsArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), SamplingIntervalDiagnosticsDataType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeSamplingIntervalDiagnosticsArrayAsync(SamplingIntervalDiagnosticsDataType[] samplingIntervalDiagnosticsArray) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])samplingIntervalDiagnosticsArray);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getSamplingIntervalDiagnosticsArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public SamplingIntervalDiagnosticsArrayTypeNode getSamplingIntervalDiagnosticsArrayNode() throws UaException {
        try {
            return this.getSamplingIntervalDiagnosticsArrayNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends SamplingIntervalDiagnosticsArrayTypeNode> getSamplingIntervalDiagnosticsArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SamplingIntervalDiagnosticsArray", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (SamplingIntervalDiagnosticsArrayTypeNode)node);
    }

    @Override
    public SubscriptionDiagnosticsDataType[] getSubscriptionDiagnosticsArray() throws UaException {
        SubscriptionDiagnosticsArrayTypeNode node = this.getSubscriptionDiagnosticsArrayNode();
        return this.cast(node.getValue().getValue().getValue(), SubscriptionDiagnosticsDataType[].class);
    }

    @Override
    public void setSubscriptionDiagnosticsArray(SubscriptionDiagnosticsDataType[] value) throws UaException {
        SubscriptionDiagnosticsArrayTypeNode node = this.getSubscriptionDiagnosticsArrayNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public SubscriptionDiagnosticsDataType[] readSubscriptionDiagnosticsArray() throws UaException {
        try {
            return this.readSubscriptionDiagnosticsArrayAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSubscriptionDiagnosticsArray(SubscriptionDiagnosticsDataType[] value) throws UaException {
        try {
            this.writeSubscriptionDiagnosticsArrayAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends SubscriptionDiagnosticsDataType[]> readSubscriptionDiagnosticsArrayAsync() {
        return ((CompletableFuture)this.getSubscriptionDiagnosticsArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), SubscriptionDiagnosticsDataType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeSubscriptionDiagnosticsArrayAsync(SubscriptionDiagnosticsDataType[] subscriptionDiagnosticsArray) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])subscriptionDiagnosticsArray);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getSubscriptionDiagnosticsArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public SubscriptionDiagnosticsArrayTypeNode getSubscriptionDiagnosticsArrayNode() throws UaException {
        try {
            return this.getSubscriptionDiagnosticsArrayNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends SubscriptionDiagnosticsArrayTypeNode> getSubscriptionDiagnosticsArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SubscriptionDiagnosticsArray", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (SubscriptionDiagnosticsArrayTypeNode)node);
    }

    @Override
    public SessionsDiagnosticsSummaryTypeNode getSessionsDiagnosticsSummaryNode() throws UaException {
        try {
            return this.getSessionsDiagnosticsSummaryNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends SessionsDiagnosticsSummaryTypeNode> getSessionsDiagnosticsSummaryNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SessionsDiagnosticsSummary", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (SessionsDiagnosticsSummaryTypeNode)node);
    }
}

